/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openfuxml.addon.wiki.data.jaxb.Ofx;
import org.openfuxml.addon.wiki.data.jaxb.Ofxchart;
import org.openfuxml.util.translation.DoubleMapTranslation;

public class OfxchartUtil {
    static Log logger = LogFactory.getLog(OfxchartUtil.class);

    public static synchronized Ofxchart getChart(Ofx ofx, String id, String type) {
        for (Ofxchart ofxchart : ofx.getOfxchart()) {
            if (!ofxchart.getId().equals(id) || !ofxchart.getType().equals(type)) continue;
            return ofxchart;
        }
        logger.warn((Object)("Chart not found for id=" + id + " type=" + type));
        return null;
    }

    public static synchronized Ofxchart translate(Ofxchart ofxchart, DoubleMapTranslation translation, String lang) {
        String label;
        if (ofxchart.isSetXAxis() && ofxchart.getXAxis().isSetKey()) {
            label = translation.translate(ofxchart.getXAxis().getKey(), lang);
            ofxchart.getXAxis().setLabel(label);
        }
        if (ofxchart.isSetYAxis() && ofxchart.getYAxis().isSetKey()) {
            label = translation.translate(ofxchart.getYAxis().getKey(), lang);
            ofxchart.getYAxis().setLabel(label);
        }
        if (ofxchart.isSetTitle() && ofxchart.getTitle().isSetKey()) {
            label = translation.translate(ofxchart.getTitle().getKey(), lang);
            ofxchart.getTitle().setLabel(label);
        }
        return ofxchart;
    }
}

