/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.media.image;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import javax.imageio.ImageIO;
import net.sourceforge.jwbf.core.actions.util.ActionException;
import net.sourceforge.jwbf.core.actions.util.ProcessException;
import net.sourceforge.jwbf.mediawiki.actions.queries.ImageInfo;
import net.sourceforge.jwbf.mediawiki.actions.util.VersionException;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import org.apache.commons.configuration.Configuration;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiImageProcessor {
    static final Logger logger = LoggerFactory.getLogger(WikiImageProcessor.class);
    private BufferedImage image;
    private Configuration config;

    public WikiImageProcessor(Configuration config) {
        this.config = config;
    }

    public void fetch(String imageName) {
        try {
            MediaWikiBot bot = new MediaWikiBot("http://de.wikipedia.org/w/");
            ImageInfo wikiImage = new ImageInfo(bot, imageName);
            logger.debug(wikiImage.getUrlAsString());
            this.image = wikiImage.getAsImage();
        }
        catch (MalformedURLException e) {
            logger.error("", (Throwable)e);
        }
        catch (VersionException e) {
            logger.error("", (Throwable)e);
        }
        catch (ProcessException e) {
            logger.error("", (Throwable)e);
        }
        catch (ActionException e) {
            logger.error("", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
    }

    public void save(String fileName) {
        this.savePNG(fileName);
        this.saveEPS(fileName);
    }

    private void savePNG(String fileName) {
        File f = new File(this.config.getString("/ofx/dir[@type='image-web']") + "/" + fileName + ".png");
        try {
            ImageIO.write((RenderedImage)this.image, "png", f);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
    }

    private void saveEPS(String fileName) {
        File f = new File(this.config.getString("/ofx/dir[@type='image-eps']") + "/" + fileName + ".eps");
        try {
            EPSDocumentGraphics2D g2d = new EPSDocumentGraphics2D(false);
            g2d.setGraphicContext(new GraphicContext());
            FileOutputStream out = new FileOutputStream(f);
            g2d.setupDocument((OutputStream)out, this.image.getWidth(), this.image.getHeight());
            g2d.drawImage((Image)this.image, 0, 0, null);
            g2d.finish();
            out.close();
        }
        catch (FileNotFoundException e) {
            logger.error("", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
    }
}

