/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.parser;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.sf.exlp.core.handler.EhResultContainer;
import net.sf.exlp.core.listener.LogListenerXml;
import net.sf.exlp.core.parser.AbstractLogParser;
import net.sf.exlp.interfaces.LogEvent;
import net.sf.exlp.interfaces.LogEventHandler;
import net.sf.exlp.interfaces.LogParser;
import net.sf.exlp.util.io.LoggerInit;
import org.openfuxml.addon.wiki.data.jaxb.Ofxchart;
import org.openfuxml.addon.wiki.data.jaxb.Ofxchartcontainer;
import org.openfuxml.addon.wiki.data.jaxb.Ofxchartdata;
import org.openfuxml.addon.wiki.event.WikiChartEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiTimelineParser
extends AbstractLogParser
implements LogParser {
    static final Logger logger = LoggerFactory.getLogger(WikiTimelineParser.class);
    private Section section;
    private ArrayList<Pattern> alP = new ArrayList();
    private ArrayList<Pattern> alPBarData = new ArrayList();
    private ArrayList<Pattern> alPPlotData = new ArrayList();
    private Ofxchart ofxChart;
    private StringBuffer sbParseLine;

    public WikiTimelineParser(LogEventHandler leh) {
        super(leh);
        this.alP.add(Pattern.compile("BarData=(.*)"));
        this.alP.add(Pattern.compile("PlotData=(.*)"));
        this.alPBarData.add(Pattern.compile("[ ]*bar:(\\d*) text:([\\d\\w]*)(.*)"));
        this.alPPlotData.add(Pattern.compile("[ ]*bar:(\\d*) from:(\\d*) till: (\\d*)(.*)"));
        this.alPPlotData.add(Pattern.compile("[ ]*bar:(\\d*) at:(\\d*)(.*)"));
        this.alPPlotData.add(Pattern.compile("[ ]*color:(\\w*)(.*)"));
    }

    public void parseLine(String line) {
        this.sbParseLine.append(" parseLine:" + line);
        ++this.allLines;
        boolean unknownPattern = true;
        for (int i = 0; i < this.alP.size(); ++i) {
            Matcher m = this.alP.get(i).matcher(line);
            if (!m.matches()) continue;
            switch (i) {
                case 0: {
                    this.section = Section.bardata;
                    this.sbParseLine.append(" new-BarData");
                    break;
                }
                case 1: {
                    this.section = Section.plotdata;
                    Ofxchartcontainer ds = new Ofxchartcontainer();
                    ds.setType("dataseries");
                    this.ofxChart.getOfxchartcontainer().add(ds);
                    this.sbParseLine.append(" new-PlotData");
                }
            }
            i = this.alP.size();
            unknownPattern = false;
        }
        if (unknownPattern) {
            logger.warn("Unknown pattern: " + line);
            ++this.unknownLines;
        }
    }

    private void parseBarData(String line) {
        this.sbParseLine.append(" parseBarData:" + line);
        boolean unknownPattern = true;
        for (int i = 0; i < this.alPBarData.size(); ++i) {
            Matcher m = this.alPBarData.get(i).matcher(line);
            if (!m.matches()) continue;
            switch (i) {
                case 0: {
                    this.addChartData(m.group(1), m.group(2), "label");
                }
            }
            i = this.alPBarData.size();
            unknownPattern = false;
        }
        if (unknownPattern) {
            this.sbParseLine.append(" UNKNOW ... parsing line!");
            this.section = Section.none;
            this.parseLine(line);
        }
    }

    private void addChartData(String x, String dataType, String containerType) {
        Ofxchartdata cs = new Ofxchartdata();
        cs.setType(dataType);
        cs.setValue(new Double(x).doubleValue());
        boolean labelContanerMissing = true;
        for (Ofxchartcontainer ofxChartContainer : this.ofxChart.getOfxchartcontainer()) {
            if (!ofxChartContainer.getType().equals(containerType)) continue;
            ofxChartContainer.getOfxchartdata().add(cs);
            labelContanerMissing = false;
            break;
        }
        if (labelContanerMissing) {
            Ofxchartcontainer cc = new Ofxchartcontainer();
            cc.getOfxchartdata().add(cs);
            cc.setType(containerType);
            this.ofxChart.getOfxchartcontainer().add(cc);
        }
    }

    private void parsePlotData(String line) {
        this.sbParseLine.append(" parsePlotData:" + line);
        boolean unknownPattern = true;
        for (int i = 0; i < this.alPPlotData.size(); ++i) {
            Matcher m = this.alPPlotData.get(i).matcher(line);
            if (!m.matches()) continue;
            switch (i) {
                case 0: {
                    this.addPlotData(m);
                }
            }
            i = this.alPPlotData.size();
            unknownPattern = false;
        }
        if (unknownPattern) {
            this.section = Section.none;
            this.parseLine(line);
        }
    }

    private void addPlotData(Matcher m) {
        Ofxchartcontainer ofxDataSet = new Ofxchartcontainer();
        ofxDataSet.setType("dataset");
        Ofxchartdata dX = new Ofxchartdata();
        dX.setType("X");
        dX.setValue(new Double(m.group(1)).doubleValue());
        ofxDataSet.getOfxchartdata().add(dX);
        Ofxchartdata dMinY = new Ofxchartdata();
        dMinY.setType("minY");
        dMinY.setValue(new Double(m.group(2)).doubleValue());
        ofxDataSet.getOfxchartdata().add(dMinY);
        Ofxchartdata dMaxY = new Ofxchartdata();
        dMaxY.setType("maxY");
        dMaxY.setValue(new Double(m.group(3)).doubleValue());
        ofxDataSet.getOfxchartdata().add(dMaxY);
        int index = this.ofxChart.getOfxchartcontainer().size() - 1;
        ((Ofxchartcontainer)this.ofxChart.getOfxchartcontainer().get(index)).getOfxchartcontainer().add(ofxDataSet);
    }

    private void parse(String line) {
        this.sbParseLine = new StringBuffer();
        this.sbParseLine.append("Section:" + (Object)((Object)this.section));
        switch (this.section) {
            case none: {
                this.parseLine(line);
                break;
            }
            case bardata: {
                this.parseBarData(line);
                break;
            }
            case plotdata: {
                this.parsePlotData(line);
            }
        }
        logger.trace(this.sbParseLine.toString());
    }

    public void parseItem(List<String> item) {
        this.ofxChart = new Ofxchart();
        this.ofxChart.setType("bar");
        this.section = Section.none;
        logger.debug("Item received with " + item.size() + " entries");
        for (String line : item) {
            this.parse(line);
        }
        WikiChartEvent event = new WikiChartEvent(this.ofxChart);
        this.leh.handleEvent((LogEvent)event);
    }

    private void debug() {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Ofxchart.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)this.ofxChart, (OutputStream)System.out);
        }
        catch (JAXBException e) {
            logger.error("", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("resources/config");
        loggerInit.init();
        EhResultContainer leh = new EhResultContainer();
        WikiTimelineParser lp = new WikiTimelineParser((LogEventHandler)leh);
        LogListenerXml ll = new LogListenerXml("resources/data/timeline.xml", (LogParser)lp);
        ll.processMulti("/wikiinjection/wikicontent");
        EhResultContainer results = leh;
        logger.debug("Results: " + results.getAlResults().size());
        WikiChartEvent event = (WikiChartEvent)((Object)results.getAlResults().get(0));
        Ofxchart ofxChart = event.getOfxChart();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Ofxchart.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)ofxChart, new File("resources/data/timeline-ofxchart.xml"));
        }
        catch (JAXBException e) {
            logger.error("", (Throwable)e);
        }
    }

    private static enum Section {
        none,
        bardata,
        plotdata;

    }
}

