/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.markup;

import java.io.File;
import net.sf.exlp.util.io.StringIO;
import org.openfuxml.addon.wiki.data.jaxb.Category;
import org.openfuxml.addon.wiki.data.jaxb.Content;
import org.openfuxml.addon.wiki.data.jaxb.Page;
import org.openfuxml.addon.wiki.model.WikiDefaultModel;
import org.openfuxml.addon.wiki.processor.util.AbstractWikiProcessor;
import org.openfuxml.addon.wiki.processor.util.WikiProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiModelProcessor
extends AbstractWikiProcessor
implements WikiProcessor {
    static final Logger logger = LoggerFactory.getLogger(WikiModelProcessor.class);

    @Override
    protected void processCategory(Content content) {
        Category category = content.getCategory();
        for (Page page : category.getPage()) {
            this.processPage(page);
        }
    }

    @Override
    protected void processPage(Content content) {
        Page page = content.getPage();
        this.processPage(page);
    }

    private void processPage(Page page) {
        String fNameMarkup = page.getFile() + "." + (Object)((Object)WikiProcessor.WikiFileExtension.txt);
        String fNameModel = page.getFile() + "." + (Object)((Object)WikiProcessor.WikiFileExtension.xhtml);
        logger.debug("ProcessingPage: " + this.srcDir + "/" + fNameMarkup + " -> " + this.dstDir + "/" + fNameModel);
        String txtMarkup = StringIO.loadTxt((File)this.srcDir, (String)fNameMarkup);
        String result = this.process(txtMarkup);
        StringIO.writeTxt((File)this.dstDir, (String)fNameModel, (String)result);
    }

    public String process(String txtMarkup) {
        logger.warn("Check image and title");
        String wikiImage = "file:///c:/temp/${image}";
        String wikiTitle = "file:///c:/temp/${title}";
        WikiDefaultModel myWikiModel = new WikiDefaultModel(wikiImage, wikiTitle);
        String xHtml = myWikiModel.render(txtMarkup);
        return xHtml;
    }
}

