/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.ofx;

import org.openfuxml.addon.wiki.WikiTemplates;
import org.openfuxml.addon.wiki.data.jaxb.Content;
import org.openfuxml.addon.wiki.data.jaxb.Page;
import org.openfuxml.addon.wiki.processor.ofx.xml.WikiCategoryProcessor;
import org.openfuxml.addon.wiki.processor.ofx.xml.WikiPageProcessor;
import org.openfuxml.addon.wiki.processor.util.AbstractWikiProcessor;
import org.openfuxml.addon.wiki.processor.util.WikiProcessor;
import org.openfuxml.exception.OfxAuthoringException;
import org.openfuxml.exception.OfxInternalProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiXmlProcessor
extends AbstractWikiProcessor
implements WikiProcessor {
    static final Logger logger = LoggerFactory.getLogger(WikiXmlProcessor.class);
    private WikiPageProcessor pageProcessor;
    private WikiCategoryProcessor categoryProcessor;

    public WikiXmlProcessor() {
        WikiTemplates.init();
    }

    @Override
    protected void processCategory(Content content) throws OfxAuthoringException, OfxInternalProcessingException {
        this.getCategoryProcessor().processCategory(content);
    }

    @Override
    protected void processPage(Content content) throws OfxAuthoringException, OfxInternalProcessingException {
        Page page = content.getPage();
        this.getPageProcessor().processPage(page);
    }

    private WikiPageProcessor getPageProcessor() {
        if (this.pageProcessor == null) {
            this.pageProcessor = new WikiPageProcessor();
            this.pageProcessor.setDirectories(this.srcDir, this.dstDir);
        }
        return this.pageProcessor;
    }

    private WikiCategoryProcessor getCategoryProcessor() {
        if (this.categoryProcessor == null) {
            this.categoryProcessor = new WikiCategoryProcessor(this.getPageProcessor());
            this.categoryProcessor.setDirectories(this.srcDir, this.dstDir);
        }
        return this.categoryProcessor;
    }
}

