/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.ofx.emitter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.openfuxml.interfaces.transformer.Emitter;
import org.openfuxml.transform.xhtml.EmitterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class HeaderEmitter
implements Emitter {
    static final Logger logger = LoggerFactory.getLogger(HeaderEmitter.class);
    private Pattern pHeader = Pattern.compile("h(\\d)");
    private Emitter next;
    private int nestLevel = 0;
    private final int headerLevel;
    private String sectionName;
    private boolean dispatching = false;
    private boolean sectionOpen = false;
    private EmitterFactory ef;

    public HeaderEmitter(EmitterFactory ef, int headerLevel) {
        this.ef = ef;
        this.headerLevel = headerLevel;
        this.sectionName = "ofx:section";
        logger.debug("inited sectionName:" + this.sectionName);
    }

    public void content(XMLStreamWriter writer, char[] ch, int start, int length) throws XMLStreamException {
        if (!this.dispatching && this.nestLevel == 1) {
            writer.writeCharacters(ch, start, length);
        } else {
            this.dispatchContent(writer, ch, start, length);
        }
    }

    public boolean end(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
        --this.nestLevel;
        if (!this.dispatching && this.nestLevel == 0) {
            this.closeTitle();
            this.dispatching = true;
        } else {
            this.dispatchEnd(writer, htmlElementName);
        }
        return false;
    }

    public boolean start(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
        ++this.nestLevel;
        if (!this.dispatching && this.nestLevel == 1) {
            this.openSection(atts);
        } else {
            int localLevel;
            Matcher matcher = this.pHeader.matcher(htmlElementName);
            if (matcher.matches() && (localLevel = Integer.parseInt(matcher.group(1))) <= this.headerLevel) {
                this.closeSection();
                return false;
            }
            this.dispatchStart(writer, htmlElementName, atts);
        }
        return true;
    }

    private void dispatchStart(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
        if (this.next == null) {
            this.next = this.ef.getEmitter(htmlElementName);
        }
        if (!this.next.start(writer, htmlElementName, atts)) {
            this.next.close();
            this.next = this.ef.getEmitter(htmlElementName);
            if (!this.next.start(writer, htmlElementName, atts)) {
                throw new IllegalStateException();
            }
        }
    }

    private void dispatchEnd(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
        if (this.next != null) {
            if (this.next.end(writer, htmlElementName)) {
                this.next.close();
                this.next = null;
            }
        } else {
            throw new IllegalStateException();
        }
    }

    private void dispatchContent(XMLStreamWriter writer, char[] ch, int start, int length) throws XMLStreamException {
        if (this.next != null) {
            this.next.content(writer, ch, start, length);
        } else {
            writer.writeCharacters(ch, start, length);
        }
    }

    private void openSection(Attributes atts) throws XMLStreamException {
        this.sectionOpen = true;
        this.ef.getWriter().writeStartElement(this.sectionName);
        this.ef.getWriter().writeStartElement("ofx:title");
        String elementId = atts.getValue("id");
        if (elementId != null) {
            this.ef.getWriter().writeAttribute("id", elementId);
        }
    }

    private void closeSection() throws XMLStreamException {
        if (this.next != null) {
            this.next.close();
            this.next = null;
        }
        this.ef.getWriter().writeEndElement();
        this.next = null;
        this.dispatching = false;
        this.sectionOpen = false;
    }

    private void closeTitle() throws XMLStreamException {
        this.ef.getWriter().writeEndElement();
    }

    public void close() throws XMLStreamException {
        if (this.next != null) {
            this.next.close();
            this.next = null;
        }
        if (this.sectionOpen) {
            this.closeSection();
        }
    }
}

