/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.ofx.xml;

import java.io.File;
import net.sf.exlp.util.xml.JaxbUtil;
import org.openfuxml.addon.wiki.data.jaxb.Category;
import org.openfuxml.addon.wiki.data.jaxb.Content;
import org.openfuxml.addon.wiki.data.jaxb.Page;
import org.openfuxml.addon.wiki.processor.ofx.xml.WikiPageProcessor;
import org.openfuxml.addon.wiki.processor.util.AbstractWikiProcessor;
import org.openfuxml.addon.wiki.processor.util.WikiContentIO;
import org.openfuxml.addon.wiki.processor.util.WikiProcessor;
import org.openfuxml.content.ofx.Section;
import org.openfuxml.content.ofx.Sections;
import org.openfuxml.exception.OfxAuthoringException;
import org.openfuxml.exception.OfxInternalProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiCategoryProcessor
extends AbstractWikiProcessor {
    static final Logger logger = LoggerFactory.getLogger(WikiCategoryProcessor.class);
    private WikiPageProcessor pageProcessor;

    public WikiCategoryProcessor(WikiPageProcessor pageProcessor) {
        this.pageProcessor = pageProcessor;
    }

    @Override
    public void processCategory(Content content) throws OfxAuthoringException, OfxInternalProcessingException {
        Category category = content.getCategory();
        Sections sections = new Sections();
        for (Page page : category.getPage()) {
            page.setSection(new Section());
            logger.warn("HandlerType set manually !!!");
            Section section = new Section();
            section.setExternal(true);
            section.setSource(this.dstDir.getName() + "/" + page.getFile() + "." + (Object)((Object)WikiProcessor.WikiFileExtension.xml));
            sections.getContent().add(section);
            this.pageProcessor.processPage(page);
        }
        String fName = WikiContentIO.getFileFromSource(content.getSource()) + "." + (Object)((Object)WikiProcessor.WikiFileExtension.xml);
        File f = new File(this.dstDir, fName);
        logger.debug("Writing categories external XML: " + f.getAbsolutePath());
        JaxbUtil.save((File)f, (Object)sections, (boolean)true);
    }
}

