/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.pre;

import java.util.List;
import net.sf.exlp.util.xml.JDomUtil;
import net.sf.exlp.util.xml.JaxbUtil;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.xpath.XPath;
import org.openfuxml.addon.wiki.data.jaxb.Content;
import org.openfuxml.addon.wiki.data.jaxb.Contents;
import org.openfuxml.content.ofx.Document;
import org.openfuxml.content.ofx.Section;
import org.openfuxml.content.ofx.Sections;
import org.openfuxml.exception.OfxAuthoringException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiExternalIntegrator {
    static final Logger logger = LoggerFactory.getLogger(WikiExternalIntegrator.class);
    private Namespace ns;
    private XPath xpath;
    private int counter;
    private String wikiXmlDirName;
    private Document ofxDocWithWikisAsExternal;
    private Contents wikiQueries;

    public WikiExternalIntegrator(String wikiXmlDirName) {
        this.wikiXmlDirName = wikiXmlDirName;
        try {
            this.ns = Namespace.getNamespace((String)"ofx", (String)"http://www.openfuxml.org");
            this.ns = Namespace.getNamespace((String)"wiki", (String)"http://www.openfuxml.org/wiki");
            this.xpath = XPath.newInstance((String)"//wiki:content");
            this.xpath.addNamespace(this.ns);
        }
        catch (JDOMException e) {
            logger.error("", (Throwable)e);
        }
        this.xpath.addNamespace(this.ns);
        this.counter = 1;
        this.wikiQueries = new Contents();
    }

    public void integrateWikiAsExternal(Document ofxDoc) throws OfxAuthoringException {
        org.jdom2.Document doc = JaxbUtil.toDocument((Object)ofxDoc);
        try {
            List list = this.xpath.selectNodes((Object)doc.getRootElement());
            logger.debug(list.size() + " <wiki:content/> found");
            for (Element eChild : list) {
                logger.trace(eChild.getName());
                Content wikiContent = (Content)JDomUtil.toJaxb((Element)eChild, Content.class);
                Element eOfx = this.processWikiContent(wikiContent);
                wikiContent.setSource(eOfx.getAttributeValue("source"));
                this.wikiQueries.getContent().add(wikiContent);
                int index = eChild.getParentElement().indexOf((org.jdom2.Content)eChild);
                eChild.getParentElement().addContent(index, (org.jdom2.Content)eOfx);
                eChild.detach();
            }
        }
        catch (JDOMException e) {
            logger.error("", (Throwable)e);
        }
        this.ofxDocWithWikisAsExternal = (Document)JDomUtil.toJaxb((org.jdom2.Document)doc, Document.class);
    }

    public Document getResult() {
        return this.ofxDocWithWikisAsExternal;
    }

    public Contents getWikiQueries() {
        return this.wikiQueries;
    }

    private Element processWikiContent(Content wikiContent) throws OfxAuthoringException {
        Element e = null;
        if (wikiContent.isSetPage()) {
            e = this.getSection(wikiContent);
        } else if (wikiContent.isSetCategory()) {
            e = this.getCategory(wikiContent);
        } else {
            throw new OfxAuthoringException("Element wiki:content has no known child");
        }
        return e;
    }

    private Element getCategory(Content wikiContent) {
        Sections ofxSections = new Sections();
        ofxSections.setExternal(true);
        ofxSections.setSource(this.wikiXmlDirName + "/" + this.counter + ".xml");
        ++this.counter;
        Element eResult = JaxbUtil.toDocument((Object)ofxSections).getRootElement();
        eResult.detach();
        return eResult;
    }

    private Element getSection(Content wikiContent) {
        Section ofxSection = new Section();
        ofxSection.setExternal(true);
        ofxSection.setSource(this.wikiXmlDirName + "/" + this.counter + ".xml");
        ++this.counter;
        Element eResult = JaxbUtil.toDocument((Object)ofxSection).getRootElement();
        eResult.detach();
        return eResult;
    }
}

