/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.template;

import java.util.List;
import net.sf.exlp.util.xml.JDomUtil;
import net.sf.exlp.util.xml.JaxbUtil;
import net.sf.exlp.xml.ns.NsPrefixMapperInterface;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.xpath.XPath;
import org.openfuxml.addon.wiki.processor.util.AbstractWikiProcessor;
import org.openfuxml.addon.wiki.processor.util.WikiProcessor;
import org.openfuxml.content.ofx.Document;
import org.openfuxml.exception.OfxInternalProcessingException;
import org.openfuxml.xml.OfxNsPrefixMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiTemplateCorrector
extends AbstractWikiProcessor
implements WikiProcessor {
    static final Logger logger = LoggerFactory.getLogger(WikiTemplateCorrector.class);
    private final String startDelimiter = "&lt;wiki:injection id=&quot;";
    private final String endDelimiter = "&quot;/&gt;";
    private OfxNsPrefixMapper nsPrefixMapper = new OfxNsPrefixMapper();
    private XPath xpath;

    public WikiTemplateCorrector() {
        try {
            Namespace nsOfx = Namespace.getNamespace((String)"ofx", (String)"http://www.openfuxml.org");
            Namespace nsWiki = Namespace.getNamespace((String)"wiki", (String)"http://www.openfuxml.org/wiki");
            this.xpath = XPath.newInstance((String)"//wiki:template");
            this.xpath.addNamespace(nsOfx);
            this.xpath.addNamespace(nsWiki);
        }
        catch (JDOMException e) {
            logger.error("", (Throwable)e);
        }
    }

    public Document correctTemplateInjections(Document ofxDoc) throws OfxInternalProcessingException {
        org.jdom2.Document doc = this.transformToElement(ofxDoc);
        doc = this.exchangeParagraphByTemplate(doc);
        ofxDoc = (Document)JDomUtil.toJaxb((org.jdom2.Document)doc, Document.class);
        return ofxDoc;
    }

    private org.jdom2.Document exchangeParagraphByTemplate(org.jdom2.Document doc) {
        try {
            Namespace nsOfx = Namespace.getNamespace((String)"ofx", (String)"http://www.openfuxml.org");
            Namespace nsWiki = Namespace.getNamespace((String)"wiki", (String)"http://www.openfuxml.org/wiki");
            XPath xpath = XPath.newInstance((String)"//wiki:template");
            xpath.addNamespace(nsOfx);
            xpath.addNamespace(nsWiki);
            Element result = this.exchangeParagraphByTemplate(doc.getRootElement(), xpath);
            result.detach();
            doc.setRootElement(result);
        }
        catch (JDOMException e) {
            logger.error("", (Throwable)e);
        }
        return doc;
    }

    private Element exchangeParagraphByTemplate(Element rootElement, XPath xpath) {
        try {
            List list = xpath.selectNodes((Object)rootElement);
            logger.debug(list.size() + " sections");
            for (Element eTemplate : list) {
                int index = eTemplate.getParentElement().getParentElement().indexOf((Content)eTemplate.getParentElement());
                Element parent = eTemplate.getParentElement().getParentElement();
                eTemplate.detach();
                parent.removeContent(index);
                parent.addContent(index, (Content)this.createExternalTemplate(eTemplate));
            }
        }
        catch (JDOMException e) {
            logger.error("", (Throwable)e);
        }
        return rootElement;
    }

    private Element createExternalTemplate(Element eTemplate) {
        StringBuffer sb = new StringBuffer();
        sb.append(WikiProcessor.WikiDir.ofxTemplate.toString());
        sb.append("/").append(eTemplate.getAttributeValue("id")).append(".xml");
        eTemplate.setAttribute("external", "true");
        eTemplate.setAttribute("source", sb.toString());
        return eTemplate;
    }

    private org.jdom2.Document transformToElement(Document ofxDoc) {
        String txt = JaxbUtil.toString((Object)ofxDoc, (NsPrefixMapperInterface)this.nsPrefixMapper, (boolean)true);
        int beginIndex = -1;
        while ((beginIndex = txt.indexOf("&lt;wiki:injection id=&quot;")) >= 0) {
            String behindStart = txt.substring(beginIndex + "&lt;wiki:injection id=&quot;".length(), txt.length());
            int endIndex = behindStart.indexOf("&quot;/&gt;");
            String id = behindStart.substring(0, endIndex);
            StringBuffer sb = new StringBuffer();
            sb.append(txt.substring(0, beginIndex));
            sb.append(this.getTemplateXml(id));
            sb.append(txt.substring(beginIndex + "&lt;wiki:injection id=&quot;".length() + id.length() + "&quot;/&gt;".length()));
            txt = sb.toString();
        }
        org.jdom2.Document doc = null;
        try {
            doc = JDomUtil.txtToDoc((String)txt);
        }
        catch (JDOMException e) {
            logger.error("", (Throwable)e);
        }
        return doc;
    }

    private String getTemplateXml(String id) {
        StringBuffer sb = new StringBuffer();
        sb.append("<wiki:template id=\"");
        sb.append(id);
        sb.append("\"/>");
        return sb.toString();
    }
}

