/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.template.exlp.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.exlp.core.parser.AbstractLogParser;
import net.sf.exlp.interfaces.LogEvent;
import net.sf.exlp.interfaces.LogEventHandler;
import net.sf.exlp.interfaces.LogParser;
import net.sf.exlp.util.io.LoggerInit;
import org.openfuxml.addon.wiki.data.jaxb.Markup;
import org.openfuxml.addon.wiki.data.jaxb.TemplateKv;
import org.openfuxml.addon.wiki.processor.template.exlp.event.WikiKeyValueEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiKeyValueParser
extends AbstractLogParser
implements LogParser {
    static final Logger logger = LoggerFactory.getLogger(WikiKeyValueParser.class);
    private TemplateKv wikiKV;

    public WikiKeyValueParser(LogEventHandler leh) {
        super(leh);
        this.pattern.add(Pattern.compile("^$"));
        this.pattern.add(Pattern.compile("^\\|([a-zA-Z]*)=(.*)"));
        this.pattern.add(Pattern.compile("(.*)"));
        logger.debug("Pattern defined: " + this.pattern.size());
    }

    public void parseLine(String line) {
        ++this.allLines;
        boolean unknownPattern = true;
        for (int i = 0; i < this.pattern.size(); ++i) {
            Matcher m = ((Pattern)this.pattern.get(i)).matcher(line);
            if (!m.matches()) continue;
            switch (i) {
                case 0: {
                    this.blank();
                    break;
                }
                case 1: {
                    this.key(m);
                    break;
                }
                case 2: {
                    this.value(m);
                }
            }
            i = this.pattern.size();
            unknownPattern = false;
        }
        if (unknownPattern) {
            logger.warn("Unknown pattern: " + line);
            ++this.unknownLines;
        }
    }

    private void blank() {
        if (this.wikiKV != null) {
            // empty if block
        }
    }

    private void key(Matcher m) {
        if (this.wikiKV != null) {
            this.event();
        }
        this.wikiKV = new TemplateKv();
        this.wikiKV.setKey(m.group(1));
        this.wikiKV.setMarkup(new Markup());
        this.wikiKV.getMarkup().setValue(m.group(2));
    }

    public void value(Matcher m) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.wikiKV.getMarkup().getValue());
        sb.append(System.lineSeparator());
        sb.append(m.group(0));
        this.wikiKV.getMarkup().setValue(sb.toString());
    }

    public void close() {
        if (this.wikiKV != null) {
            this.event();
        }
    }

    public void event() {
        WikiKeyValueEvent event = new WikiKeyValueEvent(this.wikiKV);
        this.leh.handleEvent((LogEvent)event);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("resources/config");
        loggerInit.init();
        logger.warn("This is only a pattern test-class!");
        String sPattern = "^\\|([a-zA-Z]*)=(.*)";
        String sTest = "|Goal=blabla bla blablub";
        logger.debug("Pattern: " + sPattern);
        logger.debug("Test:    " + sTest);
        Pattern p = Pattern.compile(sPattern);
        Matcher m = p.matcher(sTest);
        logger.debug("" + m.matches());
        if (m.matches()) {
            logger.debug("Group Count " + m.groupCount());
            for (int i = 0; i <= m.groupCount(); ++i) {
                logger.debug(i + " " + m.group(i));
            }
        }
    }
}

