/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.template.transformator;

import java.io.Serializable;
import java.util.List;
import net.sf.exlp.util.xml.JaxbUtil;
import net.sf.exlp.xml.ns.NsPrefixMapperInterface;
import org.jdom2.Element;
import org.openfuxml.addon.wiki.data.jaxb.Template;
import org.openfuxml.addon.wiki.data.jaxb.TemplateKv;
import org.openfuxml.addon.wiki.processor.markup.WikiInlineProcessor;
import org.openfuxml.addon.wiki.processor.template.transformator.WikiTemplateTransformator;
import org.openfuxml.content.ofx.Paragraph;
import org.openfuxml.content.ofx.Section;
import org.openfuxml.content.table.Body;
import org.openfuxml.content.table.Cell;
import org.openfuxml.content.table.Columns;
import org.openfuxml.content.table.Content;
import org.openfuxml.content.table.Head;
import org.openfuxml.content.table.Row;
import org.openfuxml.content.table.Specification;
import org.openfuxml.content.table.Table;
import org.openfuxml.exception.OfxInternalProcessingException;
import org.openfuxml.factory.ofx.table.ColumnFactory;
import org.openfuxml.factory.xml.ofx.content.text.XmlTitleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiTemplateGenericTable
implements WikiTemplateTransformator {
    static final Logger logger = LoggerFactory.getLogger(WikiTemplateGenericTable.class);
    private NsPrefixMapperInterface nsPrefixMapper;
    private WikiInlineProcessor wikiInlineProcessor;

    public WikiTemplateGenericTable(NsPrefixMapperInterface nsPrefixMapper) {
        this.nsPrefixMapper = nsPrefixMapper;
    }

    @Override
    public Element transform(Template template) {
        Section section = new Section();
        section.setContainer(true);
        Table table = this.getTable(template.getTemplateKv());
        section.getContent().add(table);
        Element result = JaxbUtil.toDocument((Object)section, (Object)this.nsPrefixMapper).getRootElement();
        result.detach();
        return result;
    }

    private Table getTable(List<TemplateKv> listKv) {
        Table table = new Table();
        table.setTitle(XmlTitleFactory.build((String)"TestTitle"));
        table.setSpecification(this.getSpecification());
        table.setContent(this.getTableContent(listKv));
        return table;
    }

    private Specification getSpecification() {
        Specification specification = new Specification();
        Columns columns = new Columns();
        columns.getColumn().add(ColumnFactory.create((String)"left", (double)2.0));
        columns.getColumn().add(ColumnFactory.create((String)"left", (double)4.0));
        specification.setColumns(columns);
        return specification;
    }

    private Content getTableContent(List<TemplateKv> listKv) {
        Content tgroup = new Content();
        tgroup.setHead(this.getTableHead());
        tgroup.getBody().add(this.getTableBody(listKv));
        return tgroup;
    }

    private Head getTableHead() {
        Head head = new Head();
        Row row = new Row();
        Cell cellKey = new Cell();
        cellKey.getContent().add("Key");
        row.getCell().add(cellKey);
        Cell teValue = new Cell();
        teValue.getContent().add("Value");
        row.getCell().add(teValue);
        head.getRow().add(row);
        return head;
    }

    private Body getTableBody(List<TemplateKv> listKv) {
        Body tbody = new Body();
        for (TemplateKv kv : listKv) {
            tbody.getRow().add(this.getRow(kv));
        }
        return tbody;
    }

    private Row getRow(TemplateKv kv) {
        Row row = new Row();
        Paragraph p = new Paragraph();
        p.getContent().add(kv.getKey());
        Cell cellKey = new Cell();
        cellKey.getContent().add(p);
        row.getCell().add(cellKey);
        Cell cellValue = new Cell();
        try {
            Section section = this.wikiInlineProcessor.toOfx(kv.getMarkup().getValue());
            for (Object s : section.getContent()) {
                cellValue.getContent().add((Serializable)s);
            }
        }
        catch (OfxInternalProcessingException e) {
            logger.error("", (Throwable)e);
        }
        row.getCell().add(cellValue);
        return row;
    }

    @Override
    public void setNsPrefixMapperInterface(NsPrefixMapperInterface nsPrefixMapper) {
    }

    @Override
    public void setWikiInlineProcessor(WikiInlineProcessor wikiInlineProcessor) {
        this.wikiInlineProcessor = wikiInlineProcessor;
    }
}

