/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.xhtml.mods;

import java.util.ArrayList;
import net.sf.exlp.util.xml.JDomUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfxPushUp {
    static final Logger logger = LoggerFactory.getLogger(OfxPushUp.class);

    public String moveOfxElements(String xHtmlText) {
        Document doc = null;
        try {
            doc = JDomUtil.txtToDoc((String)xHtmlText);
        }
        catch (JDOMException e) {
            logger.error("", (Throwable)e);
        }
        Element rootElement = doc.getRootElement();
        rootElement.detach();
        ArrayList<Element> al = this.moveOfxElement(rootElement, "wikiinjection", 0);
        if (al.size() > 1) {
            logger.warn("Moved Elements has a size>1 !!!");
        }
        rootElement = al.get(0);
        doc.addContent((Content)rootElement);
        xHtmlText = JDomUtil.docToTxt((Document)doc);
        return xHtmlText;
    }

    public ArrayList<Element> moveOfxElement(Element oldRoot, String tag, int level) {
        ArrayList<Element> movedElements = new ArrayList<Element>();
        Element newRoot = new Element(oldRoot.getName());
        for (Object oAtt : oldRoot.getAttributes()) {
            Attribute att = (Attribute)oAtt;
            Attribute newAtt = new Attribute(att.getName(), att.getValue());
            newRoot.setAttribute(newAtt);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Tag=" + tag + " Level=" + level);
        for (Object o : oldRoot.getContent()) {
            if (Text.class.isInstance(o)) {
                Text txt = (Text)o;
                Text newText = new Text(txt.getText());
                newRoot.addContent((Content)newText);
                sb.append(" txt");
                continue;
            }
            if (Element.class.isInstance(o)) {
                Element oldChild = (Element)o;
                sb.append(" " + oldChild.getName());
                if (oldChild.getName().equals(tag)) {
                    logger.debug("Detaching " + oldChild.getName());
                    movedElements.addAll(this.moveOfxElement(oldChild, tag, level + 1));
                    continue;
                }
                ArrayList<Element> al = this.moveOfxElement(oldChild, tag, level + 1);
                newRoot.addContent(al);
                continue;
            }
            logger.warn("Unknown content: " + o.getClass().getName());
        }
        logger.trace(sb.toString());
        ArrayList<Element> result = new ArrayList<Element>();
        result.add(newRoot);
        result.addAll(movedElements);
        return result;
    }
}

