/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.xhtml.mods;

import java.util.Iterator;
import java.util.List;
import net.sf.exlp.util.xml.JDomUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.xpath.XPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XhtmlCodePreMover {
    static final Logger logger = LoggerFactory.getLogger(XhtmlCodePreMover.class);
    private XPath xpathCode;
    private XPath xpParent;
    private XPath xpathPre;
    private Element rootElement;

    public XhtmlCodePreMover() {
        try {
            this.xpathCode = XPath.newInstance((String)"//code");
            this.xpParent = XPath.newInstance((String)"..");
            this.xpathPre = XPath.newInstance((String)"following-sibling::pre[position()=1]");
        }
        catch (JDOMException e) {
            logger.error("", (Throwable)e);
        }
    }

    public String move(String xHtmlText) throws JDOMException {
        Document doc = JDomUtil.txtToDoc((String)xHtmlText);
        this.rootElement = doc.getRootElement();
        logger.debug(JDomUtil.docToTxt((Document)doc));
        this.process();
        xHtmlText = JDomUtil.docToTxt((Document)doc);
        return xHtmlText;
    }

    private void process() throws JDOMException {
        List list = this.xpathCode.selectNodes((Object)this.rootElement);
        logger.debug(list.size() + " <code> elements found in " + this.rootElement.getName());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Element eP;
            logger.trace("Processing code *************");
            Element eCode = (Element)iter.next();
            if (eCode.getChildren().size() != 0 || (eP = (Element)this.xpParent.selectSingleNode((Object)eCode)) == null) continue;
            logger.trace("eP=" + eP);
            Element ePre = (Element)this.xpathPre.selectSingleNode((Object)eP);
            if (ePre == null) continue;
            logger.trace("ePre=" + ePre);
            int iP = eP.getParent().indexOf((Content)eP);
            int iPre = ePre.getParent().indexOf((Content)ePre);
            logger.trace(iP + " " + iPre);
            if (iPre != iP + 1) continue;
            eCode.setText(ePre.getText());
            ePre.detach();
            Element eCodeGrandParent = eCode.getParentElement().getParentElement();
            int iCodeParent = eCodeGrandParent.indexOf((Content)eCode.getParentElement());
            logger.debug(iCodeParent + "");
            eCode.detach();
            eCodeGrandParent.removeContent(iCodeParent);
            eCodeGrandParent.addContent(iCodeParent, (Content)eCode);
        }
    }
}

