/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.util;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdomXmlStreamer {
    static final Logger logger = LoggerFactory.getLogger(JdomXmlStreamer.class);
    private XMLStreamWriter writer;

    public JdomXmlStreamer(XMLStreamWriter writer) {
        this.writer = writer;
    }

    public void write(Element rootElement) throws XMLStreamException {
        this.writer.writeStartElement(rootElement.getName());
        for (Object o : rootElement.getAttributes()) {
            Attribute a = (Attribute)o;
            this.writer.writeAttribute(a.getName(), a.getValue());
        }
        for (Object o : rootElement.getContent()) {
            if (Text.class.isInstance(o)) {
                Text txt = (Text)o;
                this.writer.writeCharacters(txt.getText());
                continue;
            }
            if (Element.class.isInstance(o)) {
                Element child = (Element)o;
                this.write(child);
                continue;
            }
            logger.warn("Unknown content: " + o.getClass().getName());
        }
        this.writer.writeEndElement();
    }
}

