/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.sf.exlp.util.io.StringBufferOutputStream;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.openfuxml.addon.wiki.data.jaxb.Wikiinjection;
import org.openfuxml.xml.OfxNsPrefixMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiContentIO {
    static final Logger logger = LoggerFactory.getLogger(WikiContentIO.class);

    public static synchronized void writeXml(String dirName, String fileName, String content) {
        logger.debug("Writing Xml to " + dirName + "/" + fileName);
        try {
            StringReader sr = new StringReader(content);
            Document doc = new SAXBuilder().build((Reader)sr);
            XMLOutputter xmlOut = new XMLOutputter(Format.getRawFormat());
            File f = new File(dirName + "/" + fileName);
            FileOutputStream os = new FileOutputStream(f);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, "UTF-8");
            xmlOut.output(doc, (Writer)osw);
            osw.close();
            ((OutputStream)os).close();
        }
        catch (JDOMException e) {
            logger.error("", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
    }

    public static synchronized String loadTxt(String dirName, String fileName) {
        logger.debug("Reading Txt from " + dirName + "/" + fileName);
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader bw = new BufferedReader(new FileReader(new File(dirName + "/" + fileName)));
            while (bw.ready()) {
                sb.append(bw.readLine());
            }
            bw.close();
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        return sb.toString();
    }

    public static synchronized StringBuffer toString(Wikiinjection injection) {
        StringBufferOutputStream sbos = new StringBufferOutputStream();
        try {
            Element element = WikiContentIO.toElement(injection, Wikiinjection.class);
            XMLOutputter xmlOut = new XMLOutputter(Format.getRawFormat());
            xmlOut.output(element, (OutputStream)sbos);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        return sbos.getStringBuffer();
    }

    public static synchronized Element toElement(Object o, Class<?> c) {
        Element result = null;
        try {
            StringBufferOutputStream sbos = new StringBufferOutputStream();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{c});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
            m.marshal(o, (OutputStream)sbos);
            StringReader sr = new StringReader(sbos.getStringBuffer().toString());
            Document doc = new SAXBuilder().build((Reader)sr);
            result = WikiContentIO.unsetNameSpace(doc.getRootElement());
        }
        catch (JAXBException e) {
            logger.error("", (Throwable)e);
        }
        catch (JDOMException e) {
            logger.error("", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        return result;
    }

    private static synchronized Element unsetNameSpace(Element e) {
        e.setNamespace(null);
        for (Object o : e.getChildren()) {
            Element eChild = (Element)o;
            Element element = WikiContentIO.unsetNameSpace(eChild);
        }
        return e;
    }

    public static synchronized void toFile(Wikiinjection injection, File baseDir) {
        File f = new File(baseDir, injection.getId() + "-" + injection.getOfxtag() + ".xml");
        if (f.exists() && f.isFile()) {
            f.delete();
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Wikiinjection.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new OfxNsPrefixMapper());
            m.marshal((Object)injection, f);
        }
        catch (JAXBException e) {
            logger.error("", (Throwable)e);
        }
    }
}

