/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.transform.xhtml.emitter;

import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.openfuxml.factory.txt.TxtTagFactory;
import org.openfuxml.interfaces.xml.OfxEmphasis;
import org.openfuxml.transform.xhtml.EmitterFactory;
import org.openfuxml.transform.xhtml.emitter.NestingEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class EmphasisEmitter
extends NestingEmitter {
    static final Logger logger = LoggerFactory.getLogger(EmphasisEmitter.class);
    private Map<String, String> attributes;
    private OfxEmphasis.Emphasis emphasis;

    public EmphasisEmitter(EmitterFactory ef, OfxEmphasis.Emphasis emphasis) {
        super(ef);
        this.emphasis = emphasis;
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new TreeMap<String, String>();
        }
        this.attributes.put(name, value);
    }

    @Override
    protected boolean localStart(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
        String elementId;
        writer.writeStartElement(TxtTagFactory.tag(OfxEmphasis.class));
        this.writeStyle(writer);
        this.writeEmphasis(writer);
        boolean hasId = false;
        if (this.attributes != null) {
            for (Map.Entry<String, String> attr : this.attributes.entrySet()) {
                writer.writeAttribute(attr.getKey(), attr.getValue());
            }
            if (this.attributes.containsKey("id")) {
                hasId = true;
            }
        }
        if (!hasId && (elementId = atts.getValue("id")) != null) {
            writer.writeAttribute("id", elementId);
        }
        return true;
    }

    @Override
    protected boolean localEnd(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
        writer.writeEndElement();
        return true;
    }

    private void writeStyle(XMLStreamWriter writer) throws XMLStreamException {
    }

    private void writeEmphasis(XMLStreamWriter writer) throws XMLStreamException {
        switch (this.emphasis) {
            case bold: {
                writer.writeAttribute("bold", "true");
                break;
            }
            case italic: {
                writer.writeAttribute("italic", "true");
                break;
            }
            case superscript: {
                writer.writeAttribute(OfxEmphasis.Emphasis.superscript.toString(), "true");
                break;
            }
            case subscript: {
                writer.writeAttribute(OfxEmphasis.Emphasis.subscript.toString(), "true");
                break;
            }
            default: {
                logger.warn("Emphasis " + this.emphasis + " is not yet implemented");
            }
        }
    }
}

