/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.transform.xhtml.emitter;

import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.openfuxml.transform.xhtml.EmitterFactory;
import org.openfuxml.transform.xhtml.emitter.NestingEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class SimpleEmitter
extends NestingEmitter {
    static final Logger logger = LoggerFactory.getLogger(SimpleEmitter.class);
    private final String[] tags;
    private Map<String, String> attributes;

    public SimpleEmitter(EmitterFactory ef, String ... ofxTagNames) {
        super(ef);
        this.tags = ofxTagNames;
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new TreeMap<String, String>();
        }
        this.attributes.put(name, value);
    }

    @Override
    protected boolean localStart(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
        String elementId;
        for (String tag : this.tags) {
            writer.writeStartElement(tag);
        }
        boolean hasId = false;
        if (this.attributes != null) {
            for (Map.Entry<String, String> attr : this.attributes.entrySet()) {
                writer.writeAttribute(attr.getKey(), attr.getValue());
            }
            if (this.attributes.containsKey("id")) {
                hasId = true;
            }
        }
        if (!hasId && (elementId = atts.getValue("id")) != null) {
            writer.writeAttribute("id", elementId);
        }
        return true;
    }

    @Override
    protected boolean localEnd(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
        logger.trace("localEnd " + this.tags.length);
        for (int x = 0; x < this.tags.length; ++x) {
            writer.writeEndElement();
        }
        return true;
    }
}

