/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.emitter;

import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.openfuxml.transform.xhtml.EmitterFactory;
import org.openfuxml.transform.xhtml.emitter.SimpleEmitter;
import org.xml.sax.Attributes;

public class GlosstermEmitter
extends SimpleEmitter {
    private String acronymTitle;
    private StringBuilder acronym = new StringBuilder();

    public GlosstermEmitter(EmitterFactory ef) {
        super(ef, "glossterm");
    }

    @Override
    protected void localContent(XMLStreamWriter writer, char[] ch, int start, int length) throws XMLStreamException {
        if (length > 0) {
            this.acronym.append(ch, start, length);
        }
        super.localContent(writer, ch, start, length);
    }

    @Override
    public boolean localEnd(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
        String previousTitle;
        String acronym;
        HashMap<String, String> acronyms = new HashMap<String, String>();
        if (this.acronym.length() > 0 && (acronym = this.acronym.toString().trim()).length() > 0 && (previousTitle = acronyms.put(acronym, this.acronymTitle)) != null && (this.acronymTitle == null || previousTitle.length() > this.acronymTitle.length())) {
            acronyms.put(acronym, previousTitle);
        }
        return super.localEnd(writer, htmlElementName);
    }

    @Override
    public boolean localStart(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
        if (htmlElementName.equals("acronym")) {
            this.acronymTitle = atts.getValue("title");
        }
        return super.localStart(writer, htmlElementName, atts);
    }
}

