/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.parser;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.exlp.core.handler.EhDebug;
import net.sf.exlp.core.listener.LogListenerXml;
import net.sf.exlp.core.parser.AbstractLogParser;
import net.sf.exlp.interfaces.LogEvent;
import net.sf.exlp.interfaces.LogEventHandler;
import net.sf.exlp.interfaces.LogParser;
import net.sf.exlp.util.io.LoggerInit;
import org.openfuxml.addon.wiki.data.jaxb.Ofxgallery;
import org.openfuxml.addon.wiki.event.WikiImageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiGalleryParser
extends AbstractLogParser
implements LogParser {
    static final Logger logger = LoggerFactory.getLogger(WikiGalleryParser.class);
    private ArrayList<Pattern> alP = new ArrayList();

    public WikiGalleryParser(LogEventHandler leh) {
        super(leh);
        this.alP.add(Pattern.compile("[ ]*Bild:([&\\w\\s\\.]+)\\|(.*)"));
    }

    public void parseLine(String line) {
        ++this.allLines;
        boolean unknownPattern = true;
        for (int i = 0; i < this.alP.size(); ++i) {
            Matcher m = this.alP.get(i).matcher(line);
            if (!m.matches()) continue;
            switch (i) {
                case 0: {
                    this.event(m);
                }
            }
            i = this.alP.size();
            unknownPattern = false;
        }
        if (unknownPattern) {
            logger.warn("Unknown pattern: " + line);
            ++this.unknownLines;
        }
    }

    private void event(Matcher m) {
        Ofxgallery.Ofximage ofxImage = new Ofxgallery.Ofximage();
        ofxImage.setWikilink(m.group(1));
        ofxImage.setValue(m.group(2));
        WikiImageEvent event = new WikiImageEvent(ofxImage);
        this.leh.handleEvent((LogEvent)event);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("resources/config");
        loggerInit.init();
        EhDebug leh = new EhDebug();
        WikiGalleryParser lp = new WikiGalleryParser((LogEventHandler)leh);
        LogListenerXml ll = new LogListenerXml("resources/data/gallery.xml", (LogParser)lp);
        ll.processSingle("/wikiinjection/wikicontent");
    }
}

