/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.ofx;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.openfuxml.addon.wiki.WikiTemplates;
import org.openfuxml.addon.wiki.processor.ofx.emitter.OfxSectionEmitter;
import org.openfuxml.transform.xhtml.EmitterFactory;
import org.openfuxml.transform.xhtml.emitter.NestingEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class OfxHtmlContentHandler
implements ContentHandler {
    static final Logger logger = LoggerFactory.getLogger(OfxHtmlContentHandler.class);
    private OfxSectionEmitter sctionEmitter;
    private NestingEmitter emitter;
    private XMLStreamWriter writer;
    private Map<String, String> acronyms = new HashMap<String, String>();
    private EmitterFactory ef;

    public OfxHtmlContentHandler(XMLStreamWriter writer, String injectionDir) {
        this.writer = writer;
        this.ef = new EmitterFactory(writer, injectionDir);
        this.sctionEmitter = new OfxSectionEmitter(this.ef);
        this.emitter = this.sctionEmitter;
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.writer.writeStartDocument();
            this.writer.writeDTD(WikiTemplates.xmlDoctype);
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        try {
            if (this.emitter == null) {
                System.out.println("em==null");
            }
            if (!this.emitter.start(this.writer, localName, atts)) {
                throw new IllegalStateException();
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.emitter.content(this.writer, ch, start, length);
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        try {
            if (this.emitter.end(this.writer, localName)) {
                this.emitter.close();
                this.emitter = new NestingEmitter(this.ef);
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.emitter.close();
            this.emitter = null;
            this.writer.writeEndDocument();
            this.acronyms.clear();
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }
}

