/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.ofx.emitter;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.openfuxml.transform.xhtml.EmitterFactory;
import org.openfuxml.transform.xhtml.emitter.SimpleEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class OfxSectionEmitter
extends SimpleEmitter {
    static final Logger logger = LoggerFactory.getLogger(OfxSectionEmitter.class);
    private String bookTitle;

    public OfxSectionEmitter(EmitterFactory ef) {
        super(ef, "ofx:section");
    }

    @Override
    public boolean localStart(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
        boolean ok = super.localStart(writer, htmlElementName, atts);
        logger.debug("localstart ok?" + ok);
        if (ok && this.bookTitle != null) {
            logger.debug("booktitel");
            writer.writeStartElement("titel");
            writer.writeCharacters(this.bookTitle);
            writer.writeEndElement();
        }
        return ok;
    }

    @Override
    protected boolean localEnd(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
        HashMap acronyms = new HashMap();
        logger.debug("localend acronyms?" + !acronyms.isEmpty());
        if (!acronyms.isEmpty()) {
            writer.writeStartElement("appendix");
            writer.writeAttribute("id", "glossary");
            writer.writeStartElement("title");
            writer.writeAttribute("id", "glossary-end");
            writer.writeCharacters("Glossary");
            writer.writeEndElement();
            writer.writeStartElement("glosslist");
            for (Map.Entry glossEntry : new TreeMap(acronyms).entrySet()) {
                writer.writeStartElement("glossentry");
                writer.writeStartElement("glossterm");
                writer.writeCharacters((String)glossEntry.getKey());
                writer.writeEndElement();
                writer.writeStartElement("glossdef");
                writer.writeStartElement("para");
                writer.writeCharacters((String)glossEntry.getValue());
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
        return super.localEnd(writer, htmlElementName);
    }

    public String getBookTitle() {
        return this.bookTitle;
    }

    public void setBookTitle(String bookTitle) {
        this.bookTitle = bookTitle;
    }

    @Override
    protected boolean permitsMultipleNexting() {
        return true;
    }
}

