/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.template.transformator;

import net.sf.exlp.core.handler.EhResultContainer;
import net.sf.exlp.core.listener.LogListenerString;
import net.sf.exlp.interfaces.LogEvent;
import net.sf.exlp.interfaces.LogEventHandler;
import net.sf.exlp.interfaces.LogParser;
import net.sf.exlp.xml.ns.NsPrefixMapperInterface;
import org.jdom2.Element;
import org.openfuxml.addon.wiki.data.jaxb.Template;
import org.openfuxml.addon.wiki.processor.markup.WikiInlineProcessor;
import org.openfuxml.addon.wiki.processor.template.exlp.event.WikiKeyValueEvent;
import org.openfuxml.addon.wiki.processor.template.exlp.parser.WikiKeyValueParser;
import org.openfuxml.addon.wiki.processor.template.transformator.WikiTemplateGenericTable;
import org.openfuxml.xml.OfxNsPrefixMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiTemplateKeyValueTransformator {
    static final Logger logger = LoggerFactory.getLogger(WikiTemplateKeyValueTransformator.class);
    private NsPrefixMapperInterface nsPrefixMapper;
    private WikiInlineProcessor wikiInlineProcessor;

    public WikiTemplateKeyValueTransformator(WikiInlineProcessor wikiInlineProcessor) {
        this.wikiInlineProcessor = wikiInlineProcessor;
        this.nsPrefixMapper = new OfxNsPrefixMapper();
    }

    public Element transform(Template templateDef, Template template) {
        EhResultContainer leh = new EhResultContainer();
        WikiKeyValueParser lp = new WikiKeyValueParser((LogEventHandler)leh);
        LogListenerString ll = new LogListenerString(template.getMarkup().getValue(), (LogParser)lp);
        ll.processSingle();
        for (LogEvent logEvent : leh.getAlResults()) {
            WikiKeyValueEvent kvEvent = (WikiKeyValueEvent)logEvent;
            template.getTemplateKv().add(kvEvent.getKv());
        }
        return this.transformWithClass(templateDef, template);
    }

    private Element transformWithClass(Template templateDef, Template template) {
        WikiTemplateGenericTable genericTable = new WikiTemplateGenericTable(this.nsPrefixMapper);
        genericTable.setWikiInlineProcessor(this.wikiInlineProcessor);
        Element e = genericTable.transform(template);
        return e;
    }
}

