/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.util;

import java.net.MalformedURLException;
import java.net.URL;
import net.sourceforge.jwbf.core.actions.util.ActionException;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import org.openfuxml.addon.wiki.data.jaxb.Server;
import org.openfuxml.addon.wiki.data.jaxb.Servers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiBotFactory {
    static final Logger logger = LoggerFactory.getLogger(WikiBotFactory.class);
    private URL url;
    private String httpUsername;
    private String httpPassword;
    private String wikiUsername;
    private String wikiPassword;
    private MediaWikiBot bot;

    public WikiBotFactory() {
        this.setUrl("http://de.wikipedia.org/w/");
    }

    public WikiBotFactory(Servers wikiServers) {
        Server wikiServer = (Server)wikiServers.getServer().get(0);
        try {
            this.url = new URL(wikiServer.getUrl());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setUrl(String wikiURL) {
        try {
            this.url = new URL(wikiURL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setHttpDigestAuth(String httpUsername, String httpPassword) {
        this.httpUsername = httpUsername;
        this.httpPassword = httpPassword;
    }

    public void setWikiAuth(String wikiUsername, String wikiPassword) {
        this.wikiUsername = wikiUsername;
        this.wikiPassword = wikiPassword;
    }

    public MediaWikiBot getBot() {
        if (this.bot == null) {
            logger.debug("Creating MediaWikiBot");
            this.bot = this.createBot();
        }
        return this.bot;
    }

    public MediaWikiBot createBot() {
        MediaWikiBot bot = null;
        try {
            bot = new MediaWikiBot(this.url);
            logger.info("Password deactivated");
        }
        catch (ActionException e) {
            logger.error("", (Throwable)e);
        }
        return bot;
    }
}

