/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.util;

import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.List;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JDomUtil;
import net.sf.exlp.util.xml.JaxbUtil;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.openfuxml.addon.wiki.data.jaxb.Injections;
import org.openfuxml.addon.wiki.data.jaxb.Replacements;
import org.openfuxml.addon.wiki.data.jaxb.Template;
import org.openfuxml.addon.wiki.data.jaxb.Templates;
import org.openfuxml.exception.OfxConfigurationException;
import org.openfuxml.xml.OfxNsPrefixMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiConfigXmlXpathHelper {
    static final Logger logger = LoggerFactory.getLogger(WikiConfigXmlXpathHelper.class);

    public static synchronized Template getTemplate(Templates templates, String name) throws OfxConfigurationException {
        Document doc;
        Template result = new Template();
        List ns = OfxNsPrefixMapper.toOfxNamespaces();
        XPathExpression xpe = XPathFactory.instance().compile("//wiki:template[@name='" + name + "']", Filters.element(), null, (Collection)ns);
        Element e = (Element)xpe.evaluateFirst((Object)(doc = JaxbUtil.toDocument((Object)templates)));
        if (e == null) {
            throw new OfxConfigurationException("No template definition for templateName=" + name);
        }
        result = (Template)JDomUtil.toJaxb((Element)e, Template.class);
        return result;
    }

    public static synchronized Replacements initReplacements(Replacements replacements) throws OfxConfigurationException {
        if (replacements.isSetExternal() && replacements.isExternal()) {
            try {
                if (!replacements.isSetSource()) {
                    throw new OfxConfigurationException("Replacement is set to external, but no source definded");
                }
                replacements = (Replacements)JaxbUtil.loadJAXB((String)replacements.getSource(), Replacements.class);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new OfxConfigurationException(e.getMessage());
            }
        }
        return replacements;
    }

    public static synchronized Injections initInjections(Injections injections) throws OfxConfigurationException {
        if (injections.isSetExternal() && injections.isExternal()) {
            try {
                if (!injections.isSetSource()) {
                    throw new OfxConfigurationException(Injections.class.getSimpleName() + " is set to external, but no source definded");
                }
                logger.debug("Loading external " + Injections.class.getSimpleName() + " file: " + injections.getSource());
                injections = (Injections)JaxbUtil.loadJAXB((String)injections.getSource(), Injections.class);
            }
            catch (FileNotFoundException e) {
                throw new OfxConfigurationException(e.getMessage());
            }
        }
        logger.debug(JaxbUtil.toString((Object)injections));
        return injections;
    }

    public static void main(String[] args) throws Exception {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("resources/config");
        loggerInit.init();
        String fnInjections = "resources/config/wiki/wikiinjection.xml";
        Injections injections = (Injections)JaxbUtil.loadJAXB((String)fnInjections, Injections.class);
        logger.debug(JaxbUtil.toString((Object)injections));
    }
}

