/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.xhtml;

import java.io.File;
import net.sf.exlp.util.io.StringIO;
import net.sf.exlp.util.xml.JaxbUtil;
import org.openfuxml.addon.wiki.data.jaxb.Category;
import org.openfuxml.addon.wiki.data.jaxb.Content;
import org.openfuxml.addon.wiki.data.jaxb.Page;
import org.openfuxml.addon.wiki.data.jaxb.Replacements;
import org.openfuxml.addon.wiki.data.jaxb.Wikireplace;
import org.openfuxml.addon.wiki.processor.util.AbstractWikiProcessor;
import org.openfuxml.addon.wiki.processor.util.WikiConfigXmlXpathHelper;
import org.openfuxml.addon.wiki.processor.util.WikiProcessor;
import org.openfuxml.exception.OfxConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XhtmlReplaceProcessor
extends AbstractWikiProcessor
implements WikiProcessor {
    static final Logger logger = LoggerFactory.getLogger(XhtmlReplaceProcessor.class);
    private Replacements replacements;
    private String xHtmlText;

    public XhtmlReplaceProcessor(Replacements replacements) throws OfxConfigurationException {
        this.replacements = WikiConfigXmlXpathHelper.initReplacements(replacements);
        logger.debug(JaxbUtil.toString((Object)this.replacements));
    }

    @Override
    protected void processCategory(Content content) {
        Category category = content.getCategory();
        for (Page page : category.getPage()) {
            this.processPage(page);
        }
    }

    @Override
    protected void processPage(Content content) {
        Page page = content.getPage();
        this.processPage(page);
    }

    public void processPage(Page page) {
        String fNameModel = page.getFile() + "." + (Object)((Object)WikiProcessor.WikiFileExtension.xhtml);
        String txtMarkup = StringIO.loadTxt((File)this.srcDir, (String)fNameModel);
        String result = this.process(txtMarkup);
        StringIO.writeTxt((File)this.dstDir, (String)fNameModel, (String)result);
    }

    public String process(String text) {
        this.xHtmlText = this.addWellFormed(text);
        this.xHtmlText = this.xHtmlText.replaceAll("&nbsp;", " ");
        for (Wikireplace replace : this.replacements.getWikireplace()) {
            this.xhtmlReplace(replace);
        }
        this.repairXml();
        return this.xHtmlText;
    }

    private void xhtmlReplace(Wikireplace replace) {
        this.xHtmlText = this.xHtmlText.replaceAll(replace.getFrom(), replace.getTo());
    }

    public String addWellFormed(String text) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?>");
        sb.append("<wiki>");
        sb.append(text);
        sb.append("</wiki>");
        return sb.toString();
    }

    private void repairXml() {
        String startTag = "&#60;wikiinjection";
        String endTag = "/&#62;";
        while (this.xHtmlText.indexOf(startTag) > 0) {
            int from = this.xHtmlText.indexOf(startTag);
            int to = this.xHtmlText.indexOf(endTag);
            String insideTag = this.xHtmlText.substring(from + startTag.length(), to);
            insideTag = insideTag.replaceAll("&#34;", "\"");
            StringBuffer sb = new StringBuffer();
            sb.append(this.xHtmlText.substring(0, from - 1));
            sb.append("<wikiinjection");
            sb.append(insideTag);
            sb.append("/>");
            sb.append(this.xHtmlText.substring(to + endTag.length(), this.xHtmlText.length()));
            this.xHtmlText = sb.toString();
        }
    }
}

