/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.xhtml.mods;

import java.util.List;
import net.sf.exlp.util.xml.JDomUtil;
import net.sf.exlp.util.xml.JaxbUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XhtmlCodePreMover {
    static final Logger logger = LoggerFactory.getLogger(XhtmlCodePreMover.class);
    private XPathExpression<Element> xpeCode;
    private XPathExpression<Element> xpeParent;
    private XPathExpression<Element> xpePre;
    private Element rootElement;

    public XhtmlCodePreMover() {
        XPathFactory xf = XPathFactory.instance();
        this.xpeCode = xf.compile("//code", Filters.element());
        this.xpeParent = xf.compile("..", Filters.element());
        this.xpePre = xf.compile("following-sibling::pre[position()=1]", Filters.element());
    }

    public String move(String xHtmlText) throws JDOMException {
        Document doc = JDomUtil.txtToDoc((String)xHtmlText);
        this.rootElement = doc.getRootElement();
        logger.debug(JDomUtil.docToTxt((Document)doc));
        this.process();
        xHtmlText = JDomUtil.docToTxt((Document)doc);
        return xHtmlText;
    }

    private void process() throws JDOMException {
        Document doc = JaxbUtil.toDocument((Object)this.rootElement);
        List list2 = this.xpeCode.evaluate((Object)doc.getRootElement());
        logger.debug(list2.size() + " <code> elements found in " + this.rootElement.getName());
        for (Element eCode : list2) {
            Element eP;
            if (eCode.getChildren().size() != 0 || (eP = (Element)this.xpeParent.evaluateFirst((Object)eCode)) == null) continue;
            logger.trace("eP=" + eP);
            Element ePre = (Element)this.xpePre.evaluateFirst((Object)eP);
            if (ePre == null) continue;
            logger.trace("ePre=" + ePre);
            int iP = eP.getParent().indexOf((Content)eP);
            int iPre = ePre.getParent().indexOf((Content)ePre);
            logger.trace(iP + " " + iPre);
            if (iPre != iP + 1) continue;
            eCode.setText(ePre.getText());
            ePre.detach();
            Element eCodeGrandParent = eCode.getParentElement().getParentElement();
            int iCodeParent = eCodeGrandParent.indexOf((Content)eCode.getParentElement());
            logger.debug(iCodeParent + "");
            eCode.detach();
            eCodeGrandParent.removeContent(iCodeParent);
            eCodeGrandParent.addContent(iCodeParent, (Content)eCode);
        }
    }
}

