/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.transform;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sf.exlp.util.xml.JaxbUtil;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;
import org.openfuxml.addon.wiki.FormattingXMLStreamWriter;
import org.openfuxml.addon.wiki.WikiTemplates;
import org.openfuxml.addon.wiki.processor.ofx.OfxHtmlContentHandler;
import org.openfuxml.addon.wiki.processor.util.AbstractWikiProcessor;
import org.openfuxml.addon.wiki.util.IgnoreDtdEntityResolver;
import org.openfuxml.content.ofx.Section;
import org.openfuxml.trancoder.XhtmlSpecialChars;
import org.openfuxml.transform.TransformerTemplates;
import org.openfuxml.xml.OfxNsPrefixMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XhtmlTransformer
extends AbstractWikiProcessor {
    static final Logger logger = LoggerFactory.getLogger(XhtmlTransformer.class);

    public XhtmlTransformer() {
        WikiTemplates.init();
    }

    public Section process(String htmlContent) {
        Document sDoc = Jsoup.parse((String)htmlContent);
        sDoc.outputSettings().escapeMode(Entities.EscapeMode.xhtml);
        String xhtmlContent = sDoc.body().html();
        try {
            String xml = this.xhtml2Ofx(xhtmlContent);
            if (logger.isTraceEnabled()) {
                logger.info(xml);
            }
            Section section = (Section)JaxbUtil.load((byte[])xml.getBytes("UTF-8"), Section.class);
            return section;
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            logger.error("", (Throwable)e);
        }
        catch (XMLStreamException e) {
            logger.error("", (Throwable)e);
        }
        catch (SAXException e) {
            System.out.println(xhtmlContent);
            logger.error("", (Throwable)e);
        }
        return null;
    }

    private String xhtml2Ofx(String xhtmlContent) throws IOException, ParserConfigurationException, XMLStreamException, SAXException {
        xhtmlContent = XhtmlSpecialChars.replace((String)xhtmlContent);
        Object[] objects = new Object[]{xhtmlContent};
        String html = MessageFormat.format(TransformerTemplates.html, objects);
        if (logger.isTraceEnabled()) {
            logger.info(html);
        }
        InputSource inputSource = new InputSource(new StringReader(html));
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        SAXParser saxParser = factory.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setEntityResolver(IgnoreDtdEntityResolver.getInstance());
        StringWriter out = new StringWriter();
        XMLStreamWriter writer = this.createXMLStreamWriter(out);
        logger.trace("Using dummy String injectionDir");
        OfxHtmlContentHandler contentHandler = new OfxHtmlContentHandler(writer, ".");
        xmlReader.setContentHandler(contentHandler);
        xmlReader.parse(inputSource);
        writer.close();
        String result = out.toString();
        result = this.addNS(result);
        return result;
    }

    private String addNS(String xml) {
        int indexXml = xml.indexOf(">");
        int indexRoot = xml.substring(indexXml + 1, xml.length()).indexOf(">");
        StringBuffer sb = new StringBuffer();
        sb.append(xml.substring(0, indexXml + indexRoot + 1));
        sb.append(" xmlns:ofx=\"http://www.openfuxml.org\"");
        sb.append(" xmlns:").append(OfxNsPrefixMapper.prefix((OfxNsPrefixMapper.NS)OfxNsPrefixMapper.NS.text)).append("=\"").append(OfxNsPrefixMapper.namespace((OfxNsPrefixMapper.NS)OfxNsPrefixMapper.NS.text)).append("\"");
        sb.append(" xmlns:list=\"http://www.openfuxml.org/list\"");
        sb.append(" xmlns:table=\"http://www.openfuxml.org/table\"");
        sb.append(" xmlns:layout=\"http://www.openfuxml.org/layout\"");
        sb.append(" xmlns:wiki=\"http://www.openfuxml.org/wiki\"");
        sb.append(xml.substring(indexXml + indexRoot + 1, xml.length()));
        return sb.toString();
    }

    protected XMLStreamWriter createXMLStreamWriter(Writer out) {
        XMLStreamWriter writer;
        try {
            writer = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
        }
        catch (XMLStreamException e1) {
            throw new IllegalStateException(e1);
        }
        catch (FactoryConfigurationError e1) {
            throw new IllegalStateException(e1);
        }
        return new FormattingXMLStreamWriter(writer);
    }
}

