/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.getrecords;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.opengis.cite.cat20.dgiwg10.CommonFixture;
import org.opengis.cite.cat20.dgiwg10.ETSAssert;
import org.opengis.cite.cat20.dgiwg10.ErrorMessage;
import org.opengis.cite.cat20.dgiwg10.Namespaces;
import org.opengis.cite.cat20.dgiwg10.ProtocolBinding;
import org.opengis.cite.cat20.dgiwg10.SuiteAttribute;
import org.opengis.cite.cat20.dgiwg10.util.DataSampler;
import org.opengis.cite.cat20.dgiwg10.util.ElementSetName;
import org.opengis.cite.cat20.dgiwg10.util.NamespaceBindings;
import org.opengis.cite.cat20.dgiwg10.util.OutputSchema;
import org.opengis.cite.cat20.dgiwg10.util.ServiceMetadataUtils;
import org.opengis.cite.cat20.dgiwg10.util.TestSuiteLogger;
import org.opengis.cite.cat20.dgiwg10.util.ValidationUtils;
import org.opengis.cite.cat20.dgiwg10.xml.FilterCreator;
import org.opengis.cite.cat20.dgiwg10.xml.RequestCreator;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GetRecords
extends CommonFixture {
    private final RequestCreator requestCreator = new RequestCreator();
    private final FilterCreator filterCreator = new FilterCreator();
    private DataSampler dataSampler;
    private Validator cswValidator;
    private Validator isoValidator;

    @BeforeClass
    public void retrieveDataSampler(ITestContext testContext) {
        this.dataSampler = (DataSampler)testContext.getSuite().getAttribute(SuiteAttribute.DATA_SAMPLER.getName());
    }

    @BeforeClass
    public void buildValidators() {
        URL cswSchemaUrl = this.getClass().getResource("/org/opengis/cite/cat20/dgiwg10/xsd/csw/2.0.2/csw.xsd");
        try {
            Schema cswSchema = ValidationUtils.createSchema(cswSchemaUrl.toURI());
            this.cswValidator = cswSchema.newValidator();
            this.cswValidator.setResourceResolver(ValidationUtils.createSchemaResolver(Namespaces.XSD));
        }
        catch (URISyntaxException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to build XML Schema Validator for csw.xsd.", e);
        }
        try {
            URL metadatEntitySchemaUrl = this.getClass().getResource("/org/opengis/cite/cat20/dgiwg10/xsd/iso/19139/20070417/gmd/metadataEntity.xsd");
            URL srvSchemaUrl = this.getClass().getResource("/org/opengis/cite/cat20/dgiwg10/xsd/iso/19139/20070417/srv/1.0/serviceMetadata.xsd");
            Schema schema = ValidationUtils.createSchema(metadatEntitySchemaUrl.toURI(), srvSchemaUrl.toURI(), cswSchemaUrl.toURI());
            this.isoValidator = schema.newValidator();
            this.isoValidator.setResourceResolver(ValidationUtils.createSchemaResolver(Namespaces.XSD));
        }
        catch (URISyntaxException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to build XML Schema Validator for csw.xsd.", e);
        }
    }

    @Test(description="Implements A.1.2 GetRecord for DGIWG Basic CSW - 'csw:Record'/'Identifier'")
    public void issueGetCapabilities_identifier_DublinCore() {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.capabilitiesDoc, "GetRecords", ProtocolBinding.POST);
        if (endpoint == null) {
            throw new SkipException("No POST binding available for GetRecords request.");
        }
        String identifier = this.findIdentifier();
        if (identifier == null) {
            throw new SkipException("No identifier for available.");
        }
        Element identifierFilter = this.filterCreator.createIdentifierFilter(OutputSchema.DC, identifier);
        this.requestDocument = this.requestCreator.createGetRecordsRequest(OutputSchema.DC, ElementSetName.FULL, identifierFilter);
        this.response = this.cswClient.submitPostRequest(endpoint, this.requestDocument);
        Assert.assertEquals(this.response.getStatus(), 200, ErrorMessage.format("UnexpectedStatus", new Object[0]));
        this.responseDocument = this.response.getEntity(Document.class);
        ETSAssert.assertXPath("//csw:GetRecordsResponse", this.responseDocument, NamespaceBindings.withStandardBindings().getAllBindings(), "Response is not a GetRecordsResponse");
        ETSAssert.assertSchemaValid(this.cswValidator, new DOMSource(this.responseDocument));
    }

    @Test(description="Implements A.1.2 GetRecord for DGIWG Basic CSW - 'gmd:MD_Metadata'/'Identifier'")
    public void issueGetCapabilities_identifier_Iso() {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.capabilitiesDoc, "GetRecords", ProtocolBinding.POST);
        if (endpoint == null) {
            throw new SkipException("No POST binding available for GetRecords request.");
        }
        String identifier = this.findIdentifier();
        if (identifier == null) {
            throw new SkipException("No identifier for available.");
        }
        Element identifierFilter = this.filterCreator.createIdentifierFilter(OutputSchema.ISO19193, identifier);
        this.requestDocument = this.requestCreator.createGetRecordsRequest(OutputSchema.ISO19193, ElementSetName.FULL, identifierFilter);
        this.response = this.cswClient.submitPostRequest(endpoint, this.requestDocument);
        Assert.assertEquals(this.response.getStatus(), 200, ErrorMessage.format("UnexpectedStatus", new Object[0]));
        this.responseDocument = this.response.getEntity(Document.class);
        ETSAssert.assertXPath("//csw:GetRecordsResponse", this.responseDocument, NamespaceBindings.withStandardBindings().getAllBindings(), "Response is not a GetRecordsResponse");
        ETSAssert.assertSchemaValid(this.isoValidator, new DOMSource(this.responseDocument));
    }

    private String findIdentifier() {
        Map<String, Node> records = this.dataSampler.getRecords();
        for (String key : records.keySet()) {
            if (key == null) continue;
            return key;
        }
        return null;
    }
}

