/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.xml;

import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opengis.cite.cat20.dgiwg10.util.OutputSchema;
import org.opengis.cite.cat20.dgiwg10.util.TestSuiteLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FilterCreator {
    private DocumentBuilder docBuilder;

    public FilterCreator() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            this.docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to create DOM parser", e);
        }
    }

    public Element createIdentifierFilter(OutputSchema outputSchema, String identifier) {
        Document document = this.docBuilder.newDocument();
        Element filter = document.createElementNS("http://www.opengis.net/ogc", "Filter");
        Element propertyIsEqualTo = document.createElementNS("http://www.opengis.net/ogc", "PropertyIsEqualTo");
        Element propertyName = document.createElementNS("http://www.opengis.net/ogc", "PropertyName");
        String propertyNameValue = this.findPropertyNameValue(outputSchema);
        propertyName.setTextContent(propertyNameValue);
        Element literal = document.createElementNS("http://www.opengis.net/ogc", "Literal");
        literal.setTextContent(identifier);
        propertyIsEqualTo.appendChild(propertyName);
        propertyIsEqualTo.appendChild(literal);
        filter.appendChild(propertyIsEqualTo);
        return filter;
    }

    private String findPropertyNameValue(OutputSchema outputSchema) {
        if (OutputSchema.DC.equals((Object)outputSchema)) {
            return "dc:identifier";
        }
        return "Identifier";
    }
}

