/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.util;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.opengis.cite.cat20.dgiwg10.ProtocolBinding;
import org.opengis.cite.cat20.dgiwg10.util.CSWClient;
import org.opengis.cite.cat20.dgiwg10.util.ElementSetName;
import org.opengis.cite.cat20.dgiwg10.util.NamespaceBindings;
import org.opengis.cite.cat20.dgiwg10.util.OutputSchema;
import org.opengis.cite.cat20.dgiwg10.util.ServiceMetadataUtils;
import org.opengis.cite.cat20.dgiwg10.xml.RequestCreator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataSampler {
    private Document capabilitiesDocument;
    private Map<String, Node> records = new HashMap<String, Node>();

    public DataSampler(Document capabilitiesDocument) {
        this.capabilitiesDocument = capabilitiesDocument;
    }

    public void acquireRecords() {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.capabilitiesDocument, "GetRecords", ProtocolBinding.POST);
        if (endpoint == null) {
            throw new IllegalArgumentException("No POST binding available for GetRecords request.");
        }
        CSWClient cswClient = new CSWClient(this.capabilitiesDocument);
        RequestCreator requestCreator = new RequestCreator();
        Document request = requestCreator.createGetRecordsRequest(OutputSchema.DC, ElementSetName.FULL);
        ClientResponse getRecordsResponse = cswClient.submitPostRequest(endpoint, request);
        if (getRecordsResponse.getStatus() != 200) {
            return;
        }
        try {
            XPath xpath = this.createXPath();
            Document getRecordsResponseDoc = (Document)getRecordsResponse.getEntity(Document.class);
            NodeList records = (NodeList)xpath.evaluate("//csw:Record", getRecordsResponseDoc, XPathConstants.NODESET);
            for (int nodeIndex = 0; nodeIndex < records.getLength(); ++nodeIndex) {
                Node record = records.item(nodeIndex);
                String identifier = (String)xpath.evaluate("dc:identifier", record, XPathConstants.STRING);
                this.records.put(identifier, record);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
    }

    private XPath createXPath() {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(NamespaceBindings.withStandardBindings());
        return xpath;
    }

    public Map<String, Node> getRecords() {
        return this.records;
    }
}

