/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.getcapabilities;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.opengis.cite.cat20.dgiwg10.CommonFixture;
import org.opengis.cite.cat20.dgiwg10.ETSAssert;
import org.opengis.cite.cat20.dgiwg10.ProtocolBinding;
import org.opengis.cite.cat20.dgiwg10.util.NamespaceBindings;
import org.opengis.cite.cat20.dgiwg10.util.ServiceMetadataUtils;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class GetCapabilities
extends CommonFixture {
    private static final String ABSTRACT_TEXT = "This service implements the DGIWG Catalogue Service for the Web ISO Profile version 1.0, DGIWG Basic CSW conformance class (http://www.dgiwg.org/std/csw/1.0/conf/basic)";
    private static List<String> ADDITIONAL_ISO_QUERYABLES = Arrays.asList("AnyText", "Title", "Abstract", "Identifier", "Modified", "Type", "BoundingBox", "Source", "Association", "CRS", "RevisionDate", "AlternateTitle", "CreationDate", "PublicationDate", "OrganisationName", "HasSecurityConstraints", "ResourceIdentifier", "ParentIdentifier", "KeywordType", "TopicCategory", "ResourceLanguage", "GeographicDescriptionCode", "Denominator", "DistanceValue", "DistanceUOM", "ServiceType", "ServiceTypeVersion", "GeographicDescriptionCode", "OperatesOn", "OperatesOnIdentifier", "OperatesOnName", "CouplingType", "Operation");
    private ClientResponse capabilitiesResponse;
    private Document capabilitiesDocument;

    @Test(description="Implements A.1.1 GetCapabilities for DGIWG Basic CSW")
    public void issueGetCapabilities() {
        URI capabilitiesUrl = ServiceMetadataUtils.getOperationEndpoint(this.capabilitiesDoc, "GetCapabilities", ProtocolBinding.GET);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("REQUEST", "GetCapabilities");
        queryParams.put("SERVICE", "CSW");
        queryParams.put("ACCEPTVERSIONS", "2.0.2");
        this.response = this.capabilitiesResponse = this.cswClient.submitGetRequest(capabilitiesUrl, queryParams);
    }

    @Test(description="Implements A.1.1 GetCapabilities for DGIWG Basic CSW (Requirement 1, 3)", dependsOnMethods={"issueGetCapabilities"})
    public void verifyNoError() {
        this.setCurrentResponse();
        int status = this.capabilitiesResponse.getStatus();
        Assert.assertEquals(status, 200, String.format("Expected status code 200 but received %d.", status));
        this.responseDocument = this.capabilitiesDocument = this.response.getEntity(Document.class);
        ETSAssert.assertXPath("//csw:Capabilities", this.capabilitiesDocument, NamespaceBindings.withStandardBindings().getAllBindings());
    }

    @Test(description="Implements A.1.1 GetCapabilities for DGIWG Basic CSW (Requirement 4)", dependsOnMethods={"verifyNoError"})
    public void verifyMetadataLink() {
        this.setCurrentResponse();
        this.assertResponseDocument();
        String xpath = "contains(normalize-space(//csw:Capabilities/ows:ServiceIdentification/ows:Abstract), 'This service implements the DGIWG Catalogue Service for the Web ISO Profile version 1.0, DGIWG Basic CSW conformance class (http://www.dgiwg.org/std/csw/1.0/conf/basic)')";
        ETSAssert.assertXPath(xpath, this.capabilitiesDocument, NamespaceBindings.withStandardBindings().getAllBindings(), "Abstract does not contain the expected text 'This service implements the DGIWG Catalogue Service for the Web ISO Profile version 1.0, DGIWG Basic CSW conformance class (http://www.dgiwg.org/std/csw/1.0/conf/basic)'.");
    }

    @Test(description="Implements A.1.1 GetCapabilities for DGIWG Basic CSW (Requirement 6)", dependsOnMethods={"verifyNoError"})
    public void verifySupportGetRecordsReturnType() {
        this.setCurrentResponse();
        this.assertResponseDocument();
        String xpath = "//ows:OperationsMetadata/ows:Operation[@name='GetRecords']/ows:Parameter[@name='typeNames']/ows:Value [text() = 'csw:Record' ] and //ows:OperationsMetadata/ows:Operation[@name='GetRecords']/ows:Parameter[@name='typeNames']/ows:Value[text() = 'gmd:MD_Metadata' ]";
        ETSAssert.assertXPath(xpath, this.capabilitiesDocument, NamespaceBindings.withStandardBindings().getAllBindings(), "Return types csw:Record and/or gmd:MD_Metadata for the GetRecords operation are not supported.");
    }

    @Test(description="Implements A.1.1 GetCapabilities for DGIWG Basic CSW (Requirement 5, 8, GetRecords)", dependsOnMethods={"verifyNoError"})
    public void verifyGetRecordsQueryables() {
        this.setCurrentResponse();
        this.assertResponseDocument();
        List<String> unsupportedQuerables = this.collectUnsupportedQueryables("GetRecords");
        Assert.assertTrue(unsupportedQuerables.isEmpty(), "Missing queryables for GetRecords operation: " + unsupportedQuerables);
    }

    @Test(description="Implements A.1.1 GetCapabilities for DGIWG Basic CSW (Requirement 11)", dependsOnMethods={"verifyNoError"})
    public void verifySupportGetRecordByIdReturnType() {
        this.setCurrentResponse();
        this.assertResponseDocument();
        String xpath = "//ows:OperationsMetadata/ows:Operation[@name='GetRecordById']/ows:Parameter[@name='typeNames']/ows:Value [text() = 'csw:Record' ] and //ows:OperationsMetadata/ows:Operation[@name='GetRecordById']/ows:Parameter[@name='typeNames']/ows:Value[text() = 'gmd:MD_Metadata' ]";
        ETSAssert.assertXPath(xpath, this.capabilitiesDocument, NamespaceBindings.withStandardBindings().getAllBindings(), "Return types csw:Record and/or gmd:MD_Metadata for the GetRecordById operation are not supported.");
    }

    @Test(description="Implements A.1.1 GetCapabilities for DGIWG Basic CSW (Requirement 5, 10, GetRecordById)", dependsOnMethods={"verifyNoError"})
    public void verifyGetRecordByIdQueryables() {
        this.setCurrentResponse();
        this.assertResponseDocument();
        List<String> unsupportedQuerables = this.collectUnsupportedQueryables("GetRecordById");
        Assert.assertTrue(unsupportedQuerables.isEmpty(), "Missing queryables for GetRecordById operation: " + unsupportedQuerables);
    }

    private void setCurrentResponse() {
        this.response = this.capabilitiesResponse;
        this.responseDocument = this.capabilitiesDocument;
    }

    void setResponseDocument(Document rspDocument) {
        this.capabilitiesDocument = rspDocument;
    }

    private void assertResponseDocument() {
        if (this.capabilitiesDocument == null) {
            throw new SkipException("Capabilities document could not be requested, test will be skipped.");
        }
    }

    private List<String> collectUnsupportedQueryables(String operation) {
        ArrayList<String> unsupportedQuerables = new ArrayList<String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(NamespaceBindings.withStandardBindings());
        for (String additionalQueryable : ADDITIONAL_ISO_QUERYABLES) {
            String xpathExpr = this.createQueryablePropertiesXPath(operation, additionalQueryable);
            try {
                Boolean queryableExists = (Boolean)xpath.evaluate(xpathExpr, this.capabilitiesDocument, XPathConstants.BOOLEAN);
                if (queryableExists.booleanValue()) continue;
                unsupportedQuerables.add(additionalQueryable);
            }
            catch (XPathExpressionException xPathExpressionException) {}
        }
        return unsupportedQuerables;
    }

    private String createQueryablePropertiesXPath(String operationName, String additionalQueryable) {
        StringBuilder xpath = new StringBuilder();
        xpath.append("(");
        xpath.append("//ows:OperationsMetadata/ows:Operation[@name='");
        xpath.append(operationName);
        xpath.append("']/ows:Constraint[@name='SupportedISOQueryables']/ows:Value[text()='");
        xpath.append(additionalQueryable);
        xpath.append("' ]");
        xpath.append(")");
        xpath.append(" or ").append("\n");
        xpath.append("(");
        xpath.append("//ows:OperationsMetadata/ows:Constraint[@name='SupportedISOQueryables']/ows:Value[text()='");
        xpath.append(additionalQueryable);
        xpath.append("' ]");
        xpath.append(")");
        return xpath.toString();
    }
}

