/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.util;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.UriBuilder;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.cat20.dgiwg10.ProtocolBinding;
import org.opengis.cite.cat20.dgiwg10.util.ServiceMetadataUtils;
import org.w3c.dom.Document;

public class CSWClient {
    private static final Logger LOG = Logger.getLogger(CSWClient.class.getName());
    private Client client;
    private Document capabilitiesDocument;

    public CSWClient() {
        DefaultClientConfig config = new DefaultClientConfig();
        this.client = Client.create(config);
        this.client.addFilter(new LoggingFilter());
    }

    public CSWClient(Document capabilitiesDocument) {
        this();
        String docElemName = capabilitiesDocument.getDocumentElement().getLocalName();
        if (!"Capabilities".equals(docElemName)) {
            throw new IllegalArgumentException("Not a capabilities document: " + docElemName);
        }
        this.capabilitiesDocument = capabilitiesDocument;
    }

    public ClientResponse submitGetRequest(URI endpoint, Map<String, String> queryParams) {
        LOG.log(Level.FINE, String.format("Submitting GET request to URI %s", endpoint));
        UriBuilder uriBuilder = UriBuilder.fromUri(endpoint);
        if (queryParams != null) {
            for (Map.Entry<String, String> parameter : queryParams.entrySet()) {
                uriBuilder.queryParam(parameter.getKey(), parameter.getValue());
            }
        }
        URI requestURI = uriBuilder.build(new Object[0]);
        LOG.log(Level.FINE, String.format("Request URI: %s", requestURI));
        WebResource resource = this.client.resource(requestURI);
        return resource.get(ClientResponse.class);
    }

    public ClientResponse submitPostRequest(URI endpoint, Document request) {
        WebResource resource = this.client.resource(endpoint);
        DOMSource requestBody = new DOMSource(request);
        return resource.entity(requestBody).post(ClientResponse.class);
    }

    public Document getCapabilities() {
        if (this.capabilitiesDocument == null) {
            throw new IllegalStateException("Service description is unavailable.");
        }
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.capabilitiesDocument, "GetCapabilities", ProtocolBinding.GET);
        WebResource resource = this.client.resource(endpoint);
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add("REQUEST", "GetCapabilities");
        queryParams.add("SERVICE", "CSW");
        return resource.queryParams(queryParams).get(Document.class);
    }
}

