/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opengis.cite.cat20.dgiwg10.util.ElementSetName;
import org.opengis.cite.cat20.dgiwg10.util.OutputSchema;
import org.opengis.cite.cat20.dgiwg10.util.TestSuiteLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RequestCreator {
    private static final Logger LOG = Logger.getLogger(RequestCreator.class.getName());
    private DocumentBuilder docBuilder;

    public RequestCreator() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            this.docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to create DOM parser", e);
        }
    }

    public Document createGetRecordsRequest(OutputSchema outputSchema, ElementSetName elementSetName) {
        return this.createGetRecordsRequest(outputSchema, elementSetName, null);
    }

    public Document createGetRecordsRequest(OutputSchema outputSchema, ElementSetName elementSetName, Node filter) {
        Document request;
        try {
            InputStream requestAsStream = this.getClass().getResourceAsStream("/org/opengis/cite/cat20/dgiwg10/getrecords/GetRecords-request.xml");
            request = this.docBuilder.parse(requestAsStream);
        }
        catch (IOException | SAXException e) {
            LOG.log(Level.SEVERE, "GetRecords request could not be created", e);
            throw new IllegalArgumentException("GetRecords request could not be created");
        }
        Element getRecords = request.getDocumentElement();
        getRecords.setAttribute("outputSchema", outputSchema.getOutputSchema());
        Element query = (Element)getRecords.getElementsByTagNameNS("http://www.opengis.net/cat/csw/2.0.2", "Query").item(0);
        query.setAttribute("typeNames", outputSchema.getTypeName());
        Element elementSetNameElement = (Element)query.getElementsByTagNameNS("http://www.opengis.net/cat/csw/2.0.2", "ElementSetName").item(0);
        elementSetNameElement.setTextContent(elementSetName.name().toLowerCase());
        this.appendFilter(request, query, filter);
        return request;
    }

    public Document createGetRecordById(OutputSchema outputSchema, ElementSetName elementSetName, String identifier) {
        Document request;
        try {
            InputStream requestAsStream = this.getClass().getResourceAsStream("/org/opengis/cite/cat20/dgiwg10/getrecordbyid/GetRecordById-request.xml");
            request = this.docBuilder.parse(requestAsStream);
        }
        catch (IOException | SAXException e) {
            LOG.log(Level.SEVERE, "GetRecords request could not be created", e);
            throw new IllegalArgumentException("GetRecords request could not be created");
        }
        Element getRecordById = request.getDocumentElement();
        getRecordById.setAttribute("outputSchema", outputSchema.getOutputSchema());
        Element id = (Element)getRecordById.getElementsByTagNameNS("http://www.opengis.net/cat/csw/2.0.2", "Id").item(0);
        id.setTextContent(identifier);
        Element elementSetNameElement = (Element)getRecordById.getElementsByTagNameNS("http://www.opengis.net/cat/csw/2.0.2", "ElementSetName").item(0);
        elementSetNameElement.setTextContent(elementSetName.name().toLowerCase());
        return request;
    }

    private void appendFilter(Document request, Element query, Node filter) {
        if (filter == null) {
            return;
        }
        if (!"Filter".equals(filter.getLocalName())) {
            throw new IllegalArgumentException("filter has no local name 'Filter'");
        }
        Element constraint = request.createElementNS("http://www.opengis.net/cat/csw/2.0.2", "Constraint");
        constraint.setAttribute("version", "1.1.0");
        constraint.appendChild(request.importNode(filter, true));
        query.appendChild(constraint);
    }
}

