/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.ctl;

import com.occamlab.te.CtlEarlReporter;
import com.occamlab.te.Engine;
import com.occamlab.te.Generator;
import com.occamlab.te.RuntimeOptions;
import com.occamlab.te.SetupOptions;
import com.occamlab.te.TEClassLoader;
import com.occamlab.te.TECore;
import com.occamlab.te.index.Index;
import com.occamlab.te.index.SuiteEntry;
import com.occamlab.te.spi.executors.TestRunExecutor;
import com.occamlab.te.spi.util.HtmlReport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CtlExecutor
implements TestRunExecutor {
    private final SetupOptions setupOpts;
    private Map<String, String> testInputs = new HashMap<String, String>();

    public CtlExecutor(SetupOptions config) {
        this.setupOpts = config;
    }

    @Override
    public Source execute(Document testRunArgs) {
        RuntimeOptions runOpts = this.extractTestRunArguments(testRunArgs);
        runOpts.setLogDir(new File(System.getProperty("java.io.tmpdir")));
        if (null == runOpts.getSessionId()) {
            runOpts.setSessionId(UUID.randomUUID().toString());
        }
        String suiteName = null;
        try {
            Index masterIndex = Generator.generateXsl(this.setupOpts);
            SuiteEntry se = null;
            if (suiteName == null) {
                Iterator<String> it = masterIndex.getSuiteKeys().iterator();
                if (!it.hasNext()) {
                    throw new Exception("Error: No suites in sources.");
                }
                se = masterIndex.getSuite(it.next());
            }
            suiteName = se.getTitle();
            TEClassLoader defaultLoader = new TEClassLoader(null);
            Engine engine = new Engine(masterIndex, this.setupOpts.getSourcesName(), defaultLoader);
            TECore ctlRunner = new TECore(engine, masterIndex, runOpts);
            ctlRunner.execute();
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Failed to execute test suite.", ex);
            throw new RuntimeException(ex);
        }
        File resultsDir = new File(runOpts.getLogDir(), runOpts.getSessionId());
        File testLog = new File(resultsDir, "report_logs.xml");
        CtlEarlReporter report = new CtlEarlReporter();
        try {
            report.generateEarlReport(resultsDir, testLog, suiteName, this.testInputs);
        }
        catch (IOException iox) {
            throw new RuntimeException("Failed to serialize EARL results to " + resultsDir.getAbsolutePath(), iox);
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        docFactory.setXIncludeAware(true);
        Source results = null;
        try {
            File resultsFile = this.getResultsFile(this.getPreferredMediaType(testRunArgs), resultsDir.toString());
            if (this.getPreferredMediaType(testRunArgs).endsWith("zip")) {
                FileInputStream inStream = new FileInputStream(resultsFile);
                InputSource inSource = new InputSource(new InputStreamReader((InputStream)inStream, StandardCharsets.UTF_8));
                results = new SAXSource(inSource);
                results.setSystemId(resultsFile.toURI().toString());
            } else {
                Document resultsDoc = docFactory.newDocumentBuilder().parse(resultsFile);
                results = new DOMSource(resultsDoc, resultsFile.toURI().toString());
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Test results: {0}", results.getSystemId());
        return results;
    }

    RuntimeOptions extractTestRunArguments(Document testRunArgs) {
        RuntimeOptions runOpts = new RuntimeOptions();
        if (null != testRunArgs) {
            NodeList entries = testRunArgs.getElementsByTagName("entry");
            for (int i = 0; i < entries.getLength(); ++i) {
                Element entry = (Element)entries.item(i);
                String kvp = String.format("%s=%s", entry.getAttribute("key"), entry.getTextContent().trim());
                runOpts.addParam(kvp);
                this.testInputs.put(entry.getAttribute("key"), entry.getTextContent().trim());
            }
        }
        return runOpts;
    }

    File getResultsFile(String mediaType, String outputDirectory) throws FileNotFoundException {
        String contentType = mediaType.split(";")[0];
        String fileName = null;
        if (contentType.endsWith("rdf+xml") || contentType.endsWith("rdf+earl")) {
            fileName = "earl-results.rdf";
        } else if (contentType.endsWith("zip")) {
            File htmlResult = HtmlReport.getHtmlResultZip((String)outputDirectory);
            fileName = "result.zip";
        } else {
            fileName = "report_logs.xml";
        }
        File resultsFile = new File(outputDirectory, fileName);
        if (!resultsFile.exists()) {
            throw new FileNotFoundException("Test run results not found at " + resultsFile.getAbsolutePath());
        }
        return resultsFile;
    }

    String getPreferredMediaType(Document testRunArgs) {
        String mediaType = "application/rdf+xml";
        NodeList entries = testRunArgs.getElementsByTagName("entry");
        for (int i = 0; i < entries.getLength(); ++i) {
            Element entry = (Element)entries.item(i);
            if (!entry.getAttribute("key").equals("acceptMediaType")) continue;
            if (entry.getTextContent().trim().equalsIgnoreCase("application/xml")) {
                mediaType = "application/xml";
                continue;
            }
            if (entry.getTextContent().trim().equalsIgnoreCase("application/zip")) {
                mediaType = "application/zip";
                continue;
            }
            if (!entry.getTextContent().trim().equalsIgnoreCase("application/rdf+earl")) continue;
            mediaType = "application/rdf+earl";
        }
        return mediaType;
    }
}

