/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.web;

import com.occamlab.te.TECore;
import com.occamlab.te.util.DomUtils;
import com.occamlab.te.web.CoverageMonitor;
import java.io.File;
import net.sf.saxon.expr.XPathContext;
import org.w3c.dom.Element;

public class MonitorCall {
    XPathContext context;
    String url;
    String localName;
    String namespaceURI;
    Element params;
    String callId;
    Element parserConfig;
    boolean modifiesResponse;
    TECore core;
    String testPath;
    private CoverageMonitor coverageMonitor;

    MonitorCall(String url) {
        this.setUrl(url);
    }

    public XPathContext getContext() {
        return this.context;
    }

    public void setContext(XPathContext context) {
        this.context = context;
    }

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public Element getParams() {
        return this.params;
    }

    public void setParams(Element params) {
        this.params = params;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Element getParserInstruction() {
        return this.parserConfig;
    }

    public void setParserInstruction(Element parserInstruction) {
        this.parserConfig = parserInstruction;
    }

    public boolean getModifiesResponse() {
        return this.modifiesResponse;
    }

    public void setModifiesResponse(boolean modifiesResponse) {
        this.modifiesResponse = modifiesResponse;
    }

    public TECore getCore() {
        return this.core;
    }

    public void setCore(TECore core) {
        this.core = core;
        this.testPath = core.getTestPath();
        if (null == this.namespaceURI) {
            throw new RuntimeException("Cannot create coverage monitor: namespaceURI is null.");
        }
        this.coverageMonitor = new CoverageMonitor(this.namespaceURI);
        this.coverageMonitor.setTestSessionDir(new File(core.getLogDir(), core.getTestPath()));
    }

    public String getTestPath() {
        return this.testPath;
    }

    public void checkCoverage(String query) {
        this.coverageMonitor.inspectQuery(query);
    }

    public void destroy() {
        if (null != this.coverageMonitor) {
            this.coverageMonitor.writeCoverageResults();
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder("MonitorCall {\n");
        str.append(" url: ").append(this.url).append(",\n");
        str.append(" localName: ").append(this.localName).append(",\n");
        str.append(" NamespaceURI: ").append(this.namespaceURI).append(",\n");
        str.append(" callId: ").append(this.callId).append(",\n");
        str.append(" modifiesResponse: ").append(this.modifiesResponse).append(",\n");
        str.append(" testPath: ").append(this.testPath).append(",\n");
        str.append(" params: ").append(DomUtils.serializeNode(this.params)).append(",\n");
        str.append(" parserConfig: ").append(DomUtils.serializeNode(this.parserConfig)).append(",\n");
        str.append("}");
        return str.toString();
    }
}

