/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.web;

import com.occamlab.te.Engine;
import com.occamlab.te.Generator;
import com.occamlab.te.RuntimeOptions;
import com.occamlab.te.SetupOptions;
import com.occamlab.te.TEClassLoader;
import com.occamlab.te.TECore;
import com.occamlab.te.index.Index;
import com.occamlab.te.index.SuiteEntry;
import com.occamlab.te.util.DomUtils;
import com.occamlab.te.util.LogUtils;
import com.occamlab.te.util.Misc;
import com.occamlab.te.util.StringUtils;
import com.occamlab.te.web.Config;
import com.occamlab.te.web.ConfigFileCreator;
import com.occamlab.te.web.MonitorServlet;
import com.occamlab.te.web.TestSession;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestServlet
extends HttpServlet {
    public static final String CTL_NS = "http://www.occamlab.com/ctl";
    private static final String ABOUT_ALIAS = "about/";
    private static Logger LOGR = Logger.getLogger("com.occamlab.te.web.TestServlet");
    DocumentBuilder DB;
    Transformer identityTransformer;
    Engine engine;
    Map<String, Index> indexes;
    Config conf;
    SetupOptions setupOpts;

    @Override
    public void init() throws ServletException {
        try {
            String path = this.getServletContext().getInitParameter("teConfigFile");
            String tebase = path.split("config")[0];
            File teBasePath = new File(tebase);
            File resorcePath = null;
            if (teBasePath.exists()) {
                resorcePath = new File(new File(teBasePath, "resources"), "docs");
                if (resorcePath.exists()) {
                    LOGR.info("TE_BASE is located at:" + tebase);
                } else {
                    LOGR.warning("TE_BASE exists but '${TE_BASE}/resources/docs' doesn't");
                }
            } else {
                LOGR.warning("The variable TE_BASE has not been setup");
            }
            ConfigFileCreator creator = new ConfigFileCreator();
            if (null != resorcePath && resorcePath.exists()) {
                creator.create(tebase);
                String workDir = path.split("config")[0] + "work";
                FileUtils.deleteDirectory(new File(workDir));
                LOGR.info("Deleting  the work dir at:" + workDir);
            }
            this.conf = new Config();
            this.setupOpts = new SetupOptions();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setExpandEntityReferences(false);
            this.DB = dbf.newDocumentBuilder();
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            this.identityTransformer = tf.newTransformer();
            this.indexes = new HashMap();
            HashMap<String, TEClassLoader> classLoaders = new HashMap<String, TEClassLoader>();
            Processor processor = new Processor(false);
            processor.setConfigurationProperty("http://saxon.sf.net/feature/xinclude-aware", Boolean.TRUE);
            XsltCompiler sourceGeneratorCompiler = processor.newXsltCompiler();
            File sourceGeneratorStylesheet = Misc.getResourceAsFile("com/occamlab/te/generate_source_html.xsl");
            XsltExecutable sourceGeneratorXsltExecutable = sourceGeneratorCompiler.compile(new StreamSource(sourceGeneratorStylesheet));
            XsltTransformer sourceGeneratorTransformer = sourceGeneratorXsltExecutable.load();
            File listingsBaseDir = new File(this.getServletConfig().getServletContext().getRealPath("/"));
            File listings = new File(listingsBaseDir, "listings");
            if (!listings.mkdir() && !listings.exists()) {
                LOGR.warning("Failed to create directory at " + listings.getAbsolutePath());
            }
            for (Map.Entry sourceEntry : this.conf.getSources().entrySet()) {
                Object source2;
                String sourcesName = (String)sourceEntry.getKey();
                LOGR.fine("TestServlet - Processing Test Suite: " + sourcesName);
                this.setupOpts.setSourcesName(sourcesName);
                for (Object source2 : (List)sourceEntry.getValue()) {
                    this.setupOpts.addSource((File)source2);
                }
                Index index = Generator.generateXsl(this.setupOpts);
                this.indexes.put(sourcesName, index);
                source2 = index.getDependencies().iterator();
                while (source2.hasNext()) {
                    File ctlFile = (File)source2.next();
                    String encodedName = Generator.createEncodedName(ctlFile);
                    String basename = encodedName;
                    int i = basename.lastIndexOf(46);
                    if (i > 0) {
                        basename = basename.substring(0, i);
                    }
                    File indexFile = new File(new File(this.setupOpts.getWorkDir(), encodedName), "index.xml");
                    File htmlFile = new File(listings, basename + ".html");
                    boolean needsGenerating = true;
                    if (htmlFile.exists()) {
                        boolean bl = needsGenerating = indexFile.lastModified() > htmlFile.lastModified();
                    }
                    if (!needsGenerating) continue;
                    sourceGeneratorTransformer.setSource(new StreamSource(ctlFile));
                    Serializer sourceGeneratorSerializer = new Serializer();
                    sourceGeneratorSerializer.setOutputFile(htmlFile);
                    sourceGeneratorTransformer.setDestination(sourceGeneratorSerializer);
                    sourceGeneratorTransformer.transform();
                }
                File resourcesDir = (File)this.conf.getResources().get(sourcesName);
                LOGR.config(String.format("Adding resources directory for %s: %s", sourcesName, resourcesDir));
                classLoaders.put(sourcesName, new TEClassLoader(resourcesDir));
            }
            int cacheSize = 0;
            String s2 = this.getServletConfig().getInitParameter("cacheSize");
            if (s2 != null) {
                cacheSize = Integer.parseInt(s2);
                LOGR.fine("Set cacheSize to " + s2);
            }
            this.engine = new Engine(this.indexes.values(), classLoaders, cacheSize);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.process(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.process(request, response);
    }

    public void process(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            List<FileItem> items = null;
            HashMap<String, String> params = new HashMap<String, String>();
            boolean multipart = ServletFileUpload.isMultipartContent(request);
            if (multipart) {
                DiskFileItemFactory ffactory = new DiskFileItemFactory();
                ServletFileUpload upload = new ServletFileUpload(ffactory);
                items = upload.parseRequest(request);
                for (FileItem item : items) {
                    if (!item.isFormField()) continue;
                    params.put(item.getFieldName(), item.getString());
                }
            } else {
                Enumeration paramNames = request.getParameterNames();
                while (paramNames.hasMoreElements()) {
                    String name = (String)paramNames.nextElement();
                    params.put(name, request.getParameter(name));
                }
            }
            HttpSession session = request.getSession();
            ServletOutputStream out = response.getOutputStream();
            String operation = (String)params.get("te-operation");
            if (operation.equals("Test")) {
                String profileId;
                String sessionid;
                TestSession s2 = new TestSession();
                String user = request.getRemoteUser();
                File logdir = new File(this.conf.getUsersDir(), user);
                LOGR.info("Creating test session in " + logdir.getAbsolutePath());
                String mode = (String)params.get("mode");
                RuntimeOptions opts = new RuntimeOptions();
                opts.setWorkDir(this.setupOpts.getWorkDir());
                opts.setLogDir(logdir);
                if (mode.equals("retest")) {
                    opts.setMode(1);
                    sessionid = (String)params.get("session");
                    String test = (String)params.get("test");
                    if (sessionid == null) {
                        int i = test.indexOf("/");
                        sessionid = i > 0 ? test.substring(0, i) : test;
                    }
                    opts.setSessionId(sessionid);
                    if (test == null) {
                        opts.addTestPath(sessionid);
                    } else {
                        opts.addTestPath(test);
                    }
                    for (String key : new TreeSet(params.keySet())) {
                        if (!key.startsWith("profile_")) continue;
                        profileId = (String)params.get(key);
                        int i = profileId.indexOf("}");
                        opts.addTestPath(sessionid + "/" + profileId.substring(i + 1));
                    }
                    s2.load(logdir, sessionid);
                    opts.setSourcesName(s2.getSourcesName());
                } else if (mode.equals("resume")) {
                    opts.setMode(2);
                    sessionid = (String)params.get("session");
                    opts.setSessionId(sessionid);
                    s2.load(logdir, sessionid);
                    opts.setSourcesName(s2.getSourcesName());
                } else if (mode.equals("cache")) {
                    opts.setMode(3);
                    sessionid = (String)params.get("session");
                    opts.setSessionId(sessionid);
                    s2.load(logdir, sessionid);
                    opts.setSourcesName(s2.getSourcesName());
                    ArrayList<String> profiles = new ArrayList<String>();
                    for (String key : new TreeSet(params.keySet())) {
                        if (!key.startsWith("profile_")) continue;
                        profileId = (String)params.get(key);
                        profiles.add(profileId);
                        opts.addProfile(profileId);
                    }
                    s2.setProfiles(profiles);
                } else {
                    opts.setMode(0);
                    sessionid = LogUtils.generateSessionId(logdir);
                    s2.setSessionId(sessionid);
                    String sources = (String)params.get("sources");
                    s2.setSourcesName(sources);
                    SuiteEntry suite = (SuiteEntry)this.conf.getSuites().get(sources);
                    s2.setSuiteName(suite.getId());
                    String description = (String)params.get("description");
                    s2.setDescription(description);
                    opts.setSessionId(sessionid);
                    opts.setSourcesName(sources);
                    opts.setSuiteName(suite.getId());
                    ArrayList<String> profiles = new ArrayList<String>();
                    for (String key : new TreeSet(params.keySet())) {
                        if (!key.startsWith("profile_")) continue;
                        String profileId2 = (String)params.get(key);
                        profiles.add(profileId2);
                        opts.addProfile(profileId2);
                    }
                    s2.setProfiles(profiles);
                    s2.save(logdir);
                }
                String webdir = (String)this.conf.getWebDirs().get(s2.getSourcesName());
                URI contextURI = new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), request.getRequestURI(), null, null);
                if (webdir == null) {
                    webdir = ".";
                }
                URL baseURL = new URL(contextURI.toURL(), ABOUT_ALIAS + webdir + "/");
                LOGR.fine("Base URL is " + baseURL);
                opts.setBaseURI(baseURL.toString());
                TECore core = new TECore(this.engine, (Index)this.indexes.get(opts.getSourcesName()), opts);
                String servletURL = request.getRequestURL().toString();
                LOGR.fine("Request URL is " + servletURL);
                core.setTestServletURL(servletURL);
                MonitorServlet.setBaseServletURL((String)servletURL.substring(0, servletURL.lastIndexOf(47)));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(baos);
                core.setOut(ps);
                core.setWeb(true);
                Thread thread = new Thread(core);
                session.setAttribute("testsession", core);
                thread.start();
                response.setContentType("text/xml");
                out.println("<thread id=\"" + thread.getId() + "\" sessionId=\"" + s2.getSessionId() + "\"/>");
            } else if (operation.equals("Stop")) {
                response.setContentType("text/xml");
                TECore core = (TECore)session.getAttribute("testsession");
                if (core != null) {
                    core.stopThread();
                    session.removeAttribute("testsession");
                    out.println("<stopped/>");
                } else {
                    out.println("<message>Could not retrieve core object</message>");
                }
            } else if (operation.equals("GetStatus")) {
                TECore core = (TECore)session.getAttribute("testsession");
                response.setContentType("text/xml");
                out.print("<status");
                if (core.getFormHtml() != null) {
                    out.print(" form=\"true\"");
                }
                if (core.isThreadComplete()) {
                    out.print(" complete=\"true\"");
                    session.removeAttribute("testsession");
                }
                out.println(">");
                out.print("<![CDATA[");
                out.print(URLEncoder.encode(core.getOutput(), "UTF-8").replace('+', ' '));
                out.println("]]>");
                out.println("</status>");
            } else if (operation.equals("GetForm")) {
                TECore core = (TECore)session.getAttribute("testsession");
                String html = core.getFormHtml();
                core.setFormHtml(null);
                response.setContentType("text/html");
                out.print(html);
            } else if (operation.equals("SubmitForm")) {
                TECore core = (TECore)session.getAttribute("testsession");
                Document doc = this.DB.newDocument();
                Element root = doc.createElement("values");
                doc.appendChild(root);
                for (String key : params.keySet()) {
                    if (key.startsWith("te-")) continue;
                    Element valueElement = doc.createElement("value");
                    valueElement.setAttribute("key", key);
                    valueElement.appendChild(doc.createTextNode((String)params.get(key)));
                    root.appendChild(valueElement);
                }
                if (multipart) {
                    for (FileItem item : items) {
                        if (item.isFormField() || item.getName().equals("")) continue;
                        File tempDir = new File(URI.create(core.getTestRunDirectory()));
                        File uploadedFile = new File(tempDir, StringUtils.getFilenameFromString(item.getName()));
                        item.write(uploadedFile);
                        Element valueElement = doc.createElement("value");
                        String key = item.getFieldName();
                        valueElement.setAttribute("key", key);
                        if (core.getFormParsers().containsKey(key)) {
                            Element child;
                            Element parser = core.getFormParsers().get(key);
                            URL url = uploadedFile.toURI().toURL();
                            Element resp = core.parse(url.openConnection(), parser, doc);
                            Element content = DomUtils.getElementByTagName(resp, "content");
                            if (content != null && (child = DomUtils.getChildElement(content)) != null) {
                                valueElement.appendChild(child);
                            }
                        } else {
                            Element fileEntry = doc.createElementNS(CTL_NS, "file-entry");
                            fileEntry.setAttribute("full-path", uploadedFile.getAbsolutePath().replace('\\', '/'));
                            fileEntry.setAttribute("media-type", item.getContentType());
                            fileEntry.setAttribute("size", String.valueOf(item.getSize()));
                            valueElement.appendChild(fileEntry);
                        }
                        root.appendChild(valueElement);
                    }
                }
                core.setFormResults(doc);
                response.setContentType("text/html");
                out.println("<html>");
                out.println("<head><title>Form Submitted</title></head>");
                out.print("<body onload=\"window.parent.formSubmitted()\"></body>");
                out.println("</html>");
            }
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }
}

