/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.local;

import com.sun.xml.rpc.client.ClientTransport;
import com.sun.xml.rpc.client.ClientTransportException;
import com.sun.xml.rpc.soap.message.Handler;
import com.sun.xml.rpc.soap.message.SOAPMessageContext;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.localization.Localizable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;

public class LocalClientTransport
implements ClientTransport {
    private Handler _handler;
    private OutputStream _logStream;

    public LocalClientTransport(Handler handler) {
        this._handler = handler;
    }

    public LocalClientTransport(Handler handler, OutputStream logStream) {
        this._handler = handler;
        this._logStream = logStream;
    }

    public void invoke(String endpoint, SOAPMessageContext context) {
        try {
            String s2;
            if (this._logStream != null) {
                s2 = "\n******************\nRequest\n";
                this._logStream.write(s2.getBytes());
                context.getMessage().writeTo(this._logStream);
            }
            this.setSOAPMessageFromSAAJ(context);
            this._handler.handle(context);
            this.setSOAPMessageFromSAAJ(context);
            context.setFailure(false);
            if (this._logStream != null) {
                s2 = "\nResponse\n";
                this._logStream.write(s2.getBytes());
                context.getMessage().writeTo(this._logStream);
                s2 = "\n******************\n\n";
                this._logStream.write(s2.getBytes());
            }
        }
        catch (Exception e) {
            if (e instanceof Localizable) {
                throw new ClientTransportException("local.client.failed", (Localizable)((Object)e));
            }
            throw new ClientTransportException("local.client.failed", new LocalizableExceptionAdapter(e));
        }
    }

    private void setSOAPMessageFromSAAJ(SOAPMessageContext context) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        context.getMessage().writeTo(os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        SOAPMessage message = MessageFactory.newInstance().createMessage(context.getMessage().getMimeHeaders(), is);
        context.setMessage(message);
    }

    public void invokeOneWay(String endpoint, SOAPMessageContext context) {
        try {
            if (this._logStream != null) {
                String s2 = "\n******************\nRequest\n";
                this._logStream.write(s2.getBytes());
                context.getMessage().writeTo(this._logStream);
            }
            this._handler.handle(context);
            context.setFailure(false);
        }
        catch (Exception e) {
            if (e instanceof Localizable) {
                throw new ClientTransportException("local.client.failed", (Localizable)((Object)e));
            }
            throw new ClientTransportException("local.client.failed", new LocalizableExceptionAdapter(e));
        }
    }
}

