/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.util.DirectoryUtil;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.soap.SOAPVersion;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class ServletConfigGenerator
extends GeneratorBase {
    private File configFile = null;
    private Service currentService;
    private IndentingWriter out = null;
    private int portCount = 0;
    private TreeSet operations = null;

    public ServletConfigGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new ServletConfigGenerator(model, config, properties);
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        return new ServletConfigGenerator(model, config, properties);
    }

    private ServletConfigGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    protected void preVisitService(Service service) throws Exception {
        try {
            this.currentService = service;
            String className = service.getName().getLocalPart();
            this.configFile = ServletConfigGenerator.configFileForClass(className, this.nonclassDestDir, this.env);
            GeneratedFileInfo fi = new GeneratedFileInfo();
            fi.setFile(this.configFile);
            fi.setType("ServletConfig");
            this.env.addGeneratedFile(fi);
            this.out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(this.configFile)));
            this.portCount = 0;
            this.out.pln("# This file is generated by wscompile.");
            this.out.pln();
        }
        catch (IOException e) {
            ServletConfigGenerator.fail("cant.write", this.configFile.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postVisitService(Service service) throws Exception {
        try {
            this.out.pln("portcount=" + this.portCount);
            this.closeFile();
        }
        catch (IOException e) {
            ServletConfigGenerator.fail("cant.write", this.configFile.toString());
        }
        finally {
            this.currentService = null;
        }
    }

    public void visit(Port port) throws Exception {
        int myPortNum = this.portCount;
        this.portCount = myPortNum + 1;
        this.operations = new TreeSet(new StringLenComparator());
        Iterator operations = port.getOperations();
        while (operations.hasNext()) {
            ((Operation)operations.next()).accept(this);
        }
        try {
            String portID = "port" + myPortNum;
            String servant = null;
            servant = port.getJavaInterface().getImpl();
            if (servant == null) {
                servant = "Please specify the servant class for port:" + port.getName().getLocalPart();
            }
            this.out.pln(portID + ".tie=" + this.env.getNames().tieFor(port));
            this.out.pln(portID + ".servant=" + servant);
            this.out.pln(portID + ".name=" + port.getName().getLocalPart());
            this.out.pln(portID + ".wsdl.targetNamespace=" + this.model.getTargetNamespaceURI());
            this.out.pln(portID + ".wsdl.serviceName=" + this.currentService.getName().getLocalPart());
            QName portName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
            this.out.pln(portID + ".wsdl.portName=" + portName.getLocalPart());
        }
        catch (IOException e) {
            ServletConfigGenerator.fail("generator.cant.write", this.configFile.toString());
        }
    }

    protected void visitOperation(Operation operation) throws Exception {
        this.operations.add(operation);
    }

    private void closeFile() throws IOException {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }

    private String getBaseName(String s2) {
        if (s2.endsWith("Port")) {
            return s2.substring(0, s2.length() - 4);
        }
        return s2;
    }

    private String getPortName(String s2) {
        return this.getBaseName(s2) + "Port";
    }

    protected static File configFileForClass(String className, File destDir, ProcessorEnvironment env) throws GeneratorException {
        File packageDir = DirectoryUtil.getOutputDirectoryFor(className, destDir, env);
        String outputName = Names.stripQualifier(className);
        String outputFileName = outputName + "_Config.properties";
        return new File(packageDir, outputFileName);
    }

    private static class StringLenComparator
    implements Comparator {
        private StringLenComparator() {
        }

        public int compare(Object o1, Object o2) {
            int len2;
            int len1 = ((Operation)o1).getName().getLocalPart().length();
            return len1 <= (len2 = ((Operation)o2).getName().getLocalPart().length()) ? -1 : 1;
        }
    }
}

