/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model.java;

import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaStructureType
extends JavaType {
    private List members = new ArrayList();
    private Map membersByName = new HashMap();
    private Set subclasses = new HashSet();
    private JavaStructureType superclass;
    private Object owner;
    private boolean isAbstract = false;

    public JavaStructureType() {
    }

    public JavaStructureType(String name, boolean present, Object owner) {
        super(name, present, "null");
        this.owner = owner;
    }

    public void add(JavaStructureMember m3) {
        if (this.membersByName.containsKey(m3.getName())) {
            throw new ModelException("model.uniqueness.javastructuretype", new Object[]{m3.getName(), this.getRealName()});
        }
        this.members.add(m3);
        this.membersByName.put(m3.getName(), m3);
    }

    public JavaStructureMember getMemberByName(String name) {
        if (this.membersByName.size() != this.members.size()) {
            this.initializeMembersByName();
        }
        return (JavaStructureMember)this.membersByName.get(name);
    }

    public Iterator getMembers() {
        return this.members.iterator();
    }

    public int getMembersCount() {
        return this.members.size();
    }

    public List getMembersList() {
        return this.members;
    }

    public void setMembersList(List l) {
        this.members = l;
    }

    private void initializeMembersByName() {
        this.membersByName = new HashMap();
        if (this.members != null) {
            for (JavaStructureMember m3 : this.members) {
                if (m3.getName() != null && this.membersByName.containsKey(m3.getName())) {
                    throw new ModelException("model.uniqueness");
                }
                this.membersByName.put(m3.getName(), m3);
            }
        }
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public JavaStructureType getSuperclass() {
        return this.superclass;
    }

    public void setSuperclass(JavaStructureType superclassType) {
        this.superclass = superclassType;
    }

    public void addSubclass(JavaStructureType subclassType) {
        this.subclasses.add(subclassType);
        subclassType.setSuperclass(this);
    }

    public Iterator getSubclasses() {
        if (this.subclasses == null || this.subclasses.size() == 0) {
            return null;
        }
        return this.subclasses.iterator();
    }

    public Set getSubclassesSet() {
        return this.subclasses;
    }

    public void setSubclassesSet(Set s2) {
        this.subclasses = s2;
        Iterator iter = s2.iterator();
        while (iter.hasNext()) {
            ((JavaStructureType)iter.next()).setSuperclass(this);
        }
    }

    public Iterator getAllSubclasses() {
        Set subs = this.getAllSubclassesSet();
        if (subs.size() == 0) {
            return null;
        }
        return subs.iterator();
    }

    public Set getAllSubclassesSet() {
        HashSet transitiveSet = new HashSet();
        Iterator subs = this.subclasses.iterator();
        while (subs.hasNext()) {
            transitiveSet.addAll(((JavaStructureType)subs.next()).getAllSubclassesSet());
        }
        transitiveSet.addAll(this.subclasses);
        return transitiveSet;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }
}

