/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model.soap;

import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPAttributeOwningType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.soap.SOAPVersion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public abstract class SOAPStructureType
extends SOAPAttributeOwningType {
    private List _members = new ArrayList();
    private Map _membersByName = new HashMap();
    private Set _subtypes = null;
    private SOAPStructureType _parentType = null;

    protected SOAPStructureType() {
    }

    protected SOAPStructureType(QName name) {
        this(name, SOAPVersion.SOAP_11);
    }

    protected SOAPStructureType(QName name, SOAPVersion version) {
        super(name, (JavaStructureType)null);
    }

    protected SOAPStructureType(QName name, JavaStructureType javaType) {
        super(name, javaType);
    }

    public void add(SOAPStructureMember m3) {
        if (this._membersByName.containsKey(m3.getName())) {
            throw new ModelException("model.uniqueness");
        }
        this._members.add(m3);
        this._membersByName.put(m3.getName(), m3);
    }

    public SOAPStructureMember getMemberByName(QName name) {
        if (this._membersByName.size() != this._members.size()) {
            this.initializeMembersByName();
        }
        return (SOAPStructureMember)this._membersByName.get(name);
    }

    public Iterator getMembers() {
        return this._members.iterator();
    }

    public int getMembersCount() {
        return this._members.size();
    }

    public List getMembersList() {
        return this._members;
    }

    public void setMembersList(List l) {
        this._members = l;
    }

    private void initializeMembersByName() {
        this._membersByName = new HashMap();
        if (this._members != null) {
            for (SOAPStructureMember m3 : this._members) {
                if (m3.getName() != null && this._membersByName.containsKey(m3.getName())) {
                    throw new ModelException("model.uniqueness");
                }
                this._membersByName.put(m3.getName(), m3);
            }
        }
    }

    public void addSubtype(SOAPStructureType type) {
        if (this._subtypes == null) {
            this._subtypes = new HashSet();
        }
        this._subtypes.add(type);
        type.setParentType(this);
    }

    public Iterator getSubtypes() {
        if (this._subtypes != null) {
            return this._subtypes.iterator();
        }
        return null;
    }

    public Set getSubtypesSet() {
        return this._subtypes;
    }

    public void setSubtypesSet(Set s2) {
        this._subtypes = s2;
    }

    public void setParentType(SOAPStructureType parent) {
        if (this._parentType != null && parent != null && !this._parentType.equals(parent)) {
            throw new ModelException("model.parent.type.already.set", new Object[]{this.getName().toString(), this._parentType.getName().toString(), parent.getName().toString()});
        }
        this._parentType = parent;
    }

    public SOAPStructureType getParentType() {
        return this._parentType;
    }
}

