/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.wsdl;

import com.sun.xml.rpc.processor.config.NamespaceMappingInfo;
import com.sun.xml.rpc.processor.config.WSDLModelInfo;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.HeaderFault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.ModelObject;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaArrayType;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.model.java.JavaSimpleType;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttachmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralContentMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.literal.LiteralWildcardMember;
import com.sun.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.modeler.JavaSimpleTypeCreator;
import com.sun.xml.rpc.processor.modeler.Modeler;
import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.wsdl.MimeHelper;
import com.sun.xml.rpc.processor.modeler.wsdl.SchemaAnalyzerBase;
import com.sun.xml.rpc.processor.util.ClassNameCollector;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.processor.util.StringUtils;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.soap.SOAPWSDLConstants;
import com.sun.xml.rpc.util.localization.Localizable;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import com.sun.xml.rpc.util.xml.XmlUtil;
import com.sun.xml.rpc.wsdl.document.Binding;
import com.sun.xml.rpc.wsdl.document.BindingFault;
import com.sun.xml.rpc.wsdl.document.BindingOperation;
import com.sun.xml.rpc.wsdl.document.Documentation;
import com.sun.xml.rpc.wsdl.document.Kinds;
import com.sun.xml.rpc.wsdl.document.Message;
import com.sun.xml.rpc.wsdl.document.MessagePart;
import com.sun.xml.rpc.wsdl.document.OperationStyle;
import com.sun.xml.rpc.wsdl.document.PortType;
import com.sun.xml.rpc.wsdl.document.WSDLConstants;
import com.sun.xml.rpc.wsdl.document.WSDLDocument;
import com.sun.xml.rpc.wsdl.document.mime.MIMEContent;
import com.sun.xml.rpc.wsdl.document.mime.MIMEMultipartRelated;
import com.sun.xml.rpc.wsdl.document.mime.MIMEPart;
import com.sun.xml.rpc.wsdl.document.schema.SchemaKinds;
import com.sun.xml.rpc.wsdl.document.soap.SOAPAddress;
import com.sun.xml.rpc.wsdl.document.soap.SOAPBinding;
import com.sun.xml.rpc.wsdl.document.soap.SOAPBody;
import com.sun.xml.rpc.wsdl.document.soap.SOAPFault;
import com.sun.xml.rpc.wsdl.document.soap.SOAPHeader;
import com.sun.xml.rpc.wsdl.document.soap.SOAPHeaderFault;
import com.sun.xml.rpc.wsdl.document.soap.SOAPOperation;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import com.sun.xml.rpc.wsdl.document.soap.SOAPUse;
import com.sun.xml.rpc.wsdl.framework.Entity;
import com.sun.xml.rpc.wsdl.framework.Extensible;
import com.sun.xml.rpc.wsdl.framework.Extension;
import com.sun.xml.rpc.wsdl.framework.GloballyKnown;
import com.sun.xml.rpc.wsdl.framework.NoSuchEntityException;
import com.sun.xml.rpc.wsdl.framework.ParseException;
import com.sun.xml.rpc.wsdl.framework.ParserListener;
import com.sun.xml.rpc.wsdl.framework.ValidationException;
import com.sun.xml.rpc.wsdl.parser.SOAPEntityReferenceValidator;
import com.sun.xml.rpc.wsdl.parser.Util;
import com.sun.xml.rpc.wsdl.parser.WSDLParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public abstract class WSDLModelerBase
implements Modeler {
    private static final String OPERATION_HAS_VOID_RETURN_TYPE = "com.sun.xml.rpc.processor.modeler.wsdl.operationHasVoidReturnType";
    private static final String WSDL_DOCUMENTATION = "com.sun.xml.rpc.processor.modeler.wsdl.documentation";
    private static final String WSDL_PARAMETER_ORDER = "com.sun.xml.rpc.processor.modeler.wsdl.parameterOrder";
    private static final String WSDL_RESULT_PARAMETER = "com.sun.xml.rpc.processor.modeler.wsdl.resultParameter";
    public static final String MESSAGE_HAS_MIME_MULTIPART_RELATED_BINDING = "com.sun.xml.rpc.processor.modeler.wsdl.mimeMultipartRelatedBinding";
    protected ProcessSOAPOperationInfo info;
    private WSDLModelInfo _modelInfo;
    private Properties _options;
    private SchemaAnalyzerBase _analyzer;
    private LocalizableMessageFactory _messageFactory;
    private Set _conflictingClassNames;
    protected Map _javaExceptions;
    protected Map _faultTypeToStructureMap;
    private ProcessorEnvironment _env;
    protected JavaSimpleTypeCreator _javaTypes;
    private Map _bindingNameToPortMap;
    private static SOAPWSDLConstants soap11WSDLConstants = null;
    private static SOAPWSDLConstants soap12WSDLConstants = null;
    private boolean useWSIBasicProfile = false;
    private boolean literalOnly = false;
    private boolean unwrap = true;
    private boolean strictCompliance = false;
    private Model theModel;
    private Set reqResNames;
    private static final boolean RPCLIT_PARAM_REQUIRED = true;
    protected WSDLParser parser;
    protected HashSet hSet;

    public WSDLModelerBase(WSDLModelInfo modelInfo, Properties options) {
        this.init();
        this._modelInfo = modelInfo;
        this._options = options;
        this._messageFactory = new LocalizableMessageFactory("com.sun.xml.rpc.resources.modeler");
        this._conflictingClassNames = null;
        this._env = (ProcessorEnvironment)modelInfo.getParent().getEnvironment();
        this.hSet = null;
        this.reqResNames = new HashSet();
    }

    private void init() {
        soap11WSDLConstants = SOAPConstantsFactory.getSOAPWSDLConstants(SOAPVersion.SOAP_11);
        soap12WSDLConstants = SOAPConstantsFactory.getSOAPWSDLConstants(SOAPVersion.SOAP_12);
    }

    public Model buildModel() {
        try {
            this.parser = new WSDLParser();
            InputSource inputSource = new InputSource(this._modelInfo.getLocation());
            this.parser.addParserListener(new ParserListener(){

                public void ignoringExtension(QName name, QName parent) {
                    if (parent.equals(WSDLConstants.QNAME_TYPES) && name.getLocalPart().equals("schema") && !name.getNamespaceURI().equals("")) {
                        WSDLModelerBase.this.warn("wsdlmodeler.warning.ignoringUnrecognizedSchemaExtension", name.getNamespaceURI());
                    }
                }

                public void doneParsingEntity(QName element, Entity entity) {
                }
            });
            this.useWSIBasicProfile = Boolean.valueOf(this._options.getProperty("useWSIBasicProfile"));
            this.unwrap = Boolean.valueOf(this._options.getProperty("unwrapDocLitWrappers", "true"));
            this.strictCompliance = Boolean.valueOf(this._options.getProperty("strictCompliance"));
            WSDLDocument document = this.parser.parse(inputSource, this.useWSIBasicProfile);
            document.validateLocally();
            this.literalOnly = this.useWSIBasicProfile || Boolean.valueOf(this._options.getProperty("useDocumentLiteralEncoding")) != false;
            this.literalOnly = this.literalOnly || Boolean.valueOf(this._options.getProperty("useRPCLiteralEncoding")) != false;
            boolean validateWSDL = Boolean.valueOf(this._options.getProperty("validationWSDL"));
            if (validateWSDL) {
                document.validate(new SOAPEntityReferenceValidator());
            }
            Model model = this.internalBuildModel(document);
            ClassNameCollector collector = new ClassNameCollector();
            collector.process(model);
            if (collector.getConflictingClassNames().isEmpty()) {
                Model model2 = model;
                return model2;
            }
            this._conflictingClassNames = collector.getConflictingClassNames();
            model = this.internalBuildModel(document);
            ClassNameCollector collector2 = new ClassNameCollector();
            collector2.process(model);
            if (collector2.getConflictingClassNames().isEmpty()) {
                Model model3 = model;
                return model3;
            }
            try {
                StringBuffer conflictList = new StringBuffer();
                boolean first = true;
                Iterator iter = collector2.getConflictingClassNames().iterator();
                while (iter.hasNext()) {
                    if (!first) {
                        conflictList.append(", ");
                    } else {
                        first = false;
                    }
                    conflictList.append((String)iter.next());
                }
                throw new ModelerException("wsdlmodeler.unsolvableNamingConflicts", conflictList.toString());
            }
            catch (ModelException e) {
                throw new ModelerException(e);
            }
            catch (ParseException e) {
                throw new ModelerException(e);
            }
            catch (ValidationException e) {
                throw new ModelerException(e);
            }
        }
        finally {
            this._analyzer = null;
            this._conflictingClassNames = null;
        }
    }

    private Model internalBuildModel(WSDLDocument document) {
        boolean hasServices;
        QName modelName = new QName(document.getDefinitions().getTargetNamespaceURI(), document.getDefinitions().getName() == null ? "model" : document.getDefinitions().getName());
        Model model = new Model(modelName);
        model.setProperty("com.sun.xml.rpc.processor.model.ModelerName", "com.sun.xml.rpc.processor.modeler.wsdl.WSDLModeler");
        this.theModel = model;
        this._javaTypes = new JavaSimpleTypeCreator();
        this._analyzer = this.getSchemaAnalyzerInstance(document, this._modelInfo, this._options, this._conflictingClassNames, this._javaTypes);
        this._javaExceptions = new HashMap();
        this._faultTypeToStructureMap = new HashMap();
        this._bindingNameToPortMap = new HashMap();
        model.setTargetNamespaceURI(document.getDefinitions().getTargetNamespaceURI());
        WSDLModelerBase.setDocumentationIfPresent(model, document.getDefinitions().getDocumentation());
        boolean searchSchema = Boolean.valueOf(this._options.getProperty("searchSchemaForSubtypes"));
        if (searchSchema) {
            this.processSearchSchemaOption(document, model);
        }
        if (hasServices = document.getDefinitions().services().hasNext()) {
            Iterator iter = document.getDefinitions().services();
            while (iter.hasNext()) {
                this.processService((com.sun.xml.rpc.wsdl.document.Service)iter.next(), model, document);
                hasServices = true;
            }
        } else {
            this.warn("wsdlmodeler.warning.noServiceDefinitionsFound");
        }
        return model;
    }

    protected abstract SchemaAnalyzerBase getSchemaAnalyzerInstance(WSDLDocument var1, WSDLModelInfo var2, Properties var3, Set var4, JavaSimpleTypeCreator var5);

    protected SchemaAnalyzerBase getSchemaAnalyzer() {
        return this._analyzer;
    }

    protected void processSearchSchemaOption(WSDLDocument document, Model model) {
        Map typeMap = document.getMap(SchemaKinds.XSD_TYPE);
        int errorcount = 0;
        for (QName typeName : typeMap.keySet()) {
            try {
                AbstractType extraType = null;
                this.hSet = this.parser.getUse();
                if (this.hSet.contains("encoded") && !this.hSet.contains("literal")) {
                    extraType = this._analyzer.schemaTypeToSOAPType(typeName);
                } else if (!this.hSet.contains("encoded") && this.hSet.contains("literal")) {
                    extraType = this._analyzer.schemaTypeToLiteralType(typeName);
                } else {
                    throw new ModelerException("wsdlmodler.warning.operation.use");
                }
                if (extraType != null) {
                    model.addExtraType(extraType);
                    continue;
                }
                ++errorcount;
            }
            catch (ModelException e) {
                ++errorcount;
            }
        }
        if (errorcount > 0) {
            this.warn("wsdlmodeler.warning.searchSchema.unrecognizedTypes", Integer.toString(errorcount));
        }
    }

    protected Documentation getDocumentationFor(Element e) {
        String s2 = XmlUtil.getTextForNode(e);
        if (s2 == null) {
            return null;
        }
        return new Documentation(s2);
    }

    protected void checkNotWsdlElement(Element e) {
        if (e.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/")) {
            Util.fail("parsing.invalidWsdlElement", e.getTagName());
        }
    }

    protected void checkNotWsdlRequired(Element e) {
        String required = XmlUtil.getAttributeNSOrNull(e, "required", "http://schemas.xmlsoap.org/wsdl/");
        if (required != null && required.equals("true")) {
            Util.fail("parsing.requiredExtensibilityElement", e.getTagName(), e.getNamespaceURI());
        }
    }

    protected String getServiceInterfaceName(QName serviceQName, com.sun.xml.rpc.wsdl.document.Service wsdlService) {
        String serviceInterface = "";
        String javaPackageName = null;
        if (this._modelInfo.getJavaPackageName() != null && !this._modelInfo.getJavaPackageName().equals("")) {
            javaPackageName = this._modelInfo.getJavaPackageName();
        }
        if (javaPackageName != null) {
            serviceInterface = javaPackageName + ".";
        }
        serviceInterface = serviceInterface + this._env.getNames().validJavaClassName(wsdlService.getName());
        return serviceInterface;
    }

    protected void processService(com.sun.xml.rpc.wsdl.document.Service wsdlService, Model model, WSDLDocument document) {
        String serviceInterface = "";
        QName serviceQName = WSDLModelerBase.getQNameOf(wsdlService);
        serviceInterface = this.getServiceInterfaceName(serviceQName, wsdlService);
        if (this.isConflictingServiceClassName(serviceInterface)) {
            serviceInterface = serviceInterface + "_Service";
        }
        Service service = new Service(serviceQName, new JavaInterface(serviceInterface, serviceInterface + "Impl"));
        WSDLModelerBase.setDocumentationIfPresent(service, wsdlService.getDocumentation());
        boolean hasPorts = false;
        Iterator iter = wsdlService.ports();
        while (iter.hasNext()) {
            boolean processed = this.processPort((com.sun.xml.rpc.wsdl.document.Port)iter.next(), service, document);
            hasPorts = hasPorts || processed;
        }
        model.addService(service);
        if (!hasPorts) {
            this.warn("wsdlmodeler.warning.noPortsInService", wsdlService.getName());
        }
    }

    protected String getJavaNameOfPort(QName portQName) {
        return null;
    }

    protected boolean processPort(com.sun.xml.rpc.wsdl.document.Port wsdlPort, Service service, WSDLDocument document) {
        try {
            QName portQName = WSDLModelerBase.getQNameOf(wsdlPort);
            Port port = new Port(portQName);
            this.setCurrentPort(port);
            String metaPortName = this.getJavaNameOfPort(portQName);
            if (metaPortName != null) {
                port.setProperty("com.sun.xml.rpc.processor.model.JavaPortName", metaPortName);
            }
            WSDLModelerBase.setDocumentationIfPresent(port, wsdlPort.getDocumentation());
            SOAPAddress soapAddress = (SOAPAddress)WSDLModelerBase.getExtensionOfType(wsdlPort, SOAPAddress.class);
            if (soapAddress == null) {
                this.warn("wsdlmodeler.warning.ignoringNonSOAPPort.noAddress", wsdlPort.getName());
                return false;
            }
            port.setAddress(soapAddress.getLocation());
            Binding binding = wsdlPort.resolveBinding(document);
            QName bindingName = WSDLModelerBase.getQNameOf(binding);
            PortType portType = binding.resolvePortType(document);
            port.setProperty("com.sun.xml.rpc.processor.model.WSDLPortName", WSDLModelerBase.getQNameOf(wsdlPort));
            port.setProperty("com.sun.xml.rpc.processor.model.WSDLPortTypeName", WSDLModelerBase.getQNameOf(portType));
            port.setProperty("com.sun.xml.rpc.processor.model.WSDLBindingName", bindingName);
            if (this._bindingNameToPortMap.containsKey(bindingName)) {
                Port existingPort = (Port)this._bindingNameToPortMap.get(bindingName);
                port.setOperationsList(existingPort.getOperationsList());
                port.setJavaInterface(existingPort.getJavaInterface());
            } else {
                BindingOperation bindingOperation;
                SOAPBinding soapBinding = (SOAPBinding)WSDLModelerBase.getExtensionOfType(binding, SOAPBinding.class);
                if (soapBinding == null) {
                    this.warn("wsdlmodeler.warning.ignoringNonSOAPPort", wsdlPort.getName());
                    return false;
                }
                if (soapBinding.getTransport() == null || !soapBinding.getTransport().equals(soap11WSDLConstants.getSOAPTransportHttpURI())) {
                    this.warn("wsdlmodeler.warning.ignoringSOAPBinding.nonHTTPTransport", wsdlPort.getName());
                    return false;
                }
                boolean hasOverloadedOperations = false;
                HashSet<String> operationNames = new HashSet<String>();
                Iterator iter = portType.operations();
                block2: while (iter.hasNext()) {
                    com.sun.xml.rpc.wsdl.document.Operation operation = (com.sun.xml.rpc.wsdl.document.Operation)iter.next();
                    if (operationNames.contains(operation.getName())) {
                        hasOverloadedOperations = true;
                        break;
                    }
                    operationNames.add(operation.getName());
                    Iterator itr = binding.operations();
                    while (iter.hasNext()) {
                        bindingOperation = (BindingOperation)itr.next();
                        if (operation.getName().equals(bindingOperation.getName())) continue block2;
                        if (itr.hasNext()) continue;
                        throw new ModelerException("wsdlmodeler.invalid.bindingOperation.notFound", new Object[]{operation.getName(), binding.getName()});
                    }
                }
                HashMap headers = new HashMap();
                boolean hasOperations = false;
                Iterator iter2 = binding.operations();
                while (iter2.hasNext()) {
                    bindingOperation = (BindingOperation)iter2.next();
                    com.sun.xml.rpc.wsdl.document.Operation portTypeOperation = null;
                    Set operations = portType.getOperationsNamed(bindingOperation.getName());
                    if (operations.size() == 0) {
                        throw new ModelerException("wsdlmodeler.invalid.bindingOperation.notInPortType", new Object[]{bindingOperation.getName(), binding.getName()});
                    }
                    if (operations.size() == 1) {
                        portTypeOperation = (com.sun.xml.rpc.wsdl.document.Operation)operations.iterator().next();
                    } else {
                        SOAPOperation soapOperation;
                        boolean found = false;
                        String expectedInputName = bindingOperation.getInput().getName();
                        String expectedOutputName = bindingOperation.getOutput().getName();
                        if (this.useWSIBasicProfile && (soapOperation = (SOAPOperation)WSDLModelerBase.getExtensionOfType(bindingOperation, SOAPOperation.class)).getStyle() != null && soapBinding.getStyle() != null && soapOperation.getStyle() != soapBinding.getStyle()) {
                            this.warn("wsdlmodeler.warning.ignoringOperation.conflictStyleInWSIMode", bindingOperation.getName());
                            continue;
                        }
                        for (com.sun.xml.rpc.wsdl.document.Operation candidateOperation : operations) {
                            if (expectedInputName == null) {
                                throw new ModelerException("wsdlmodeler.invalid.bindingOperation.missingInputName", new Object[]{bindingOperation.getName(), binding.getName()});
                            }
                            if (expectedOutputName == null) {
                                throw new ModelerException("wsdlmodeler.invalid.bindingOperation.missingOutputName", new Object[]{bindingOperation.getName(), binding.getName()});
                            }
                            if (!expectedInputName.equals(candidateOperation.getInput().getName()) || !expectedOutputName.equals(candidateOperation.getOutput().getName())) continue;
                            if (found) {
                                throw new ModelerException("wsdlmodeler.invalid.bindingOperation.multipleMatchingOperations", new Object[]{bindingOperation.getName(), binding.getName()});
                            }
                            found = true;
                            portTypeOperation = candidateOperation;
                        }
                        if (!found) {
                            throw new ModelerException("wsdlmodeler.invalid.bindingOperation.notFound", new Object[]{bindingOperation.getName(), binding.getName()});
                        }
                    }
                    this.info = new ProcessSOAPOperationInfo(port, wsdlPort, portTypeOperation, bindingOperation, soapBinding, document, hasOverloadedOperations, headers);
                    Operation operation = this.processSOAPOperation();
                    this.postProcessSOAPOperation(operation);
                    if (operation == null) continue;
                    port.addOperation(operation);
                    hasOperations = true;
                }
                if (!hasOperations) {
                    this.warn("wsdlmodeler.warning.noOperationsInPort", wsdlPort.getName());
                }
                this.createJavaInterfaceForPort(port);
                this._bindingNameToPortMap.put(bindingName, port);
            }
            port.setClientHandlerChainInfo(this._modelInfo.getClientHandlerChainInfo());
            port.setServerHandlerChainInfo(this._modelInfo.getServerHandlerChainInfo());
            String stubClassName = this._env.getNames().stubFor(port, null);
            if (this.isConflictingStubClassName(stubClassName)) {
                stubClassName = this._env.getNames().stubFor(port, this.getNonQualifiedNameFor(port.getName()));
            }
            String tieClassName = this._env.getNames().tieFor(port, this._env.getNames().getSerializerNameInfix());
            tieClassName = this.getInfixedName(port, tieClassName);
            port.setProperty("com.sun.xml.rpc.processor.model.StubClassName", stubClassName);
            port.setProperty("com.sun.xml.rpc.processor.model.TieClassName", tieClassName);
            service.addPort(port);
            this.setCurrentPort(null);
            return true;
        }
        catch (NoSuchEntityException e) {
            this.warn(e);
            return false;
        }
    }

    protected void setCurrentPort(Port port) {
    }

    private String getInfixedName(Port port, String tieClassName) {
        if (this.isConflictingTieClassName(tieClassName)) {
            String str = null;
            str = this._env.getNames().getSerializerNameInfix() != null ? this.getNonQualifiedNameFor(port.getName()) + "_" + this._env.getNames().getSerializerNameInfix() : this.getNonQualifiedNameFor(port.getName());
            tieClassName = this._env.getNames().tieFor(port, str);
        }
        return tieClassName;
    }

    protected Operation processSOAPOperation() {
        Operation operation = new Operation(new QName(null, this.info.bindingOperation.getName()));
        WSDLModelerBase.setDocumentationIfPresent(operation, this.info.portTypeOperation.getDocumentation());
        if (this.info.portTypeOperation.getStyle() != OperationStyle.REQUEST_RESPONSE && this.info.portTypeOperation.getStyle() != OperationStyle.ONE_WAY) {
            this.warn("wsdlmodeler.warning.ignoringOperation.notSupportedStyle", this.info.portTypeOperation.getName());
            return null;
        }
        SOAPStyle soapStyle = this.info.soapBinding.getStyle();
        SOAPOperation soapOperation = (SOAPOperation)WSDLModelerBase.getExtensionOfType(this.info.bindingOperation, SOAPOperation.class);
        if (soapOperation != null) {
            if (soapOperation.getStyle() != null) {
                soapStyle = soapOperation.getStyle();
            }
            if (soapOperation.getSOAPAction() != null) {
                operation.setSOAPAction(soapOperation.getSOAPAction());
            }
        }
        operation.setStyle(soapStyle);
        String uniqueOperationName = this.getUniqueName(this.info.portTypeOperation, this.info.hasOverloadedOperations);
        if (this.info.hasOverloadedOperations) {
            operation.setUniqueName(uniqueOperationName);
        }
        this.info.operation = operation;
        this.info.uniqueOperationName = uniqueOperationName;
        SOAPBody soapRequestBody = this.getSOAPRequestBody();
        if (soapRequestBody == null) {
            throw new ModelerException("wsdlmodeler.invalid.bindingOperation.inputMissingSoapBody", new Object[]{this.info.bindingOperation.getName()});
        }
        if (soapStyle == SOAPStyle.RPC) {
            if (soapRequestBody.isEncoded()) {
                return this.processSOAPOperationRPCEncodedStyle();
            }
            return this.processSOAPOperationRPCLiteralStyle();
        }
        return this.processSOAPOperationDocumentLiteralStyle();
    }

    protected void postProcessSOAPOperation(Operation operation) {
    }

    protected void setJavaOperationNameProperty(Message inputMessage) {
    }

    protected boolean useExplicitServiceContextForRpcEncoded(Message inputMessage) {
        return this.useExplicitServiceContext();
    }

    protected boolean useExplicitServiceContextForRpcLit(Message inputMessage) {
        return this.useExplicitServiceContext();
    }

    protected boolean useExplicitServiceContextForDocLit(Message inputMessage) {
        return this.useExplicitServiceContext();
    }

    private boolean useExplicitServiceContext() {
        return Boolean.valueOf(this._options.getProperty("explicitServiceContext"));
    }

    protected Operation processSOAPOperationRPCEncodedStyle() {
        if (this.useWSIBasicProfile) {
            this.warn("wsdlmodeler.warning.nonconforming.wsdl.use", this.info.portTypeOperation.getName());
        }
        boolean isRequestResponse = this.info.portTypeOperation.getStyle() == OperationStyle.REQUEST_RESPONSE;
        Request request = new Request();
        Response response = new Response();
        this.info.operation.setUse(SOAPUse.ENCODED);
        SOAPBody soapRequestBody = this.getSOAPRequestBody();
        SOAPBody soapResponseBody = null;
        Message outputMessage = null;
        if (isRequestResponse) {
            soapResponseBody = this.getSOAPResponseBody();
            outputMessage = this.getOutputMessage();
            if (outputMessage != null) {
                response.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", WSDLModelerBase.getQNameOf(outputMessage));
            }
        }
        if (soapRequestBody.isLiteral() || !WSDLModelerBase.tokenListContains(soapRequestBody.getEncodingStyle(), soap11WSDLConstants.getSOAPEncodingNamespace()) && !WSDLModelerBase.tokenListContains(soapRequestBody.getEncodingStyle(), soap12WSDLConstants.getSOAPEncodingNamespace()) || soapResponseBody != null && (soapResponseBody.isLiteral() || !WSDLModelerBase.tokenListContains(soapResponseBody.getEncodingStyle(), soap11WSDLConstants.getSOAPEncodingNamespace()) && !WSDLModelerBase.tokenListContains(soapResponseBody.getEncodingStyle(), soap12WSDLConstants.getSOAPEncodingNamespace()))) {
            this.warn("wsdlmodeler.warning.ignoringOperation.notEncoded", this.info.portTypeOperation.getName());
            return null;
        }
        Message inputMessage = this.getInputMessage();
        if (inputMessage != null) {
            request.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", WSDLModelerBase.getQNameOf(inputMessage));
        }
        HashSet inputParameterNames = new HashSet();
        HashSet outputParameterNames = new HashSet();
        String resultParameterName = null;
        StringBuffer result = new StringBuffer();
        this.setJavaOperationNameProperty(inputMessage);
        List parameterList = this.processParameterOrder(inputParameterNames, outputParameterNames, result);
        if (result.length() > 0) {
            resultParameterName = result.toString();
        }
        String requestNamespaceURI = this.getRequestNamespaceURI(soapRequestBody);
        String responseNamespaceURI = null;
        if (isRequestResponse) {
            responseNamespaceURI = this.getResponseNamespaceURI(soapResponseBody);
        }
        String structureNamePrefix = this.getStructureNamePrefix();
        QName requestBodyName = new QName(requestNamespaceURI, this.info.portTypeOperation.getName());
        RPCRequestUnorderedStructureType requestBodyType = new RPCRequestUnorderedStructureType(requestBodyName);
        JavaStructureType requestBodyJavaType = new JavaStructureType(this.getUniqueClassName(this.makePackageQualified(StringUtils.capitalize(structureNamePrefix + this._env.getNames().validExternalJavaIdentifier(this.info.uniqueOperationName)) + "_RequestStruct", requestBodyName)), false, requestBodyType);
        requestBodyType.setJavaType(requestBodyJavaType);
        Block requestBodyBlock = new Block(requestBodyName, requestBodyType);
        request.addBodyBlock(requestBodyBlock);
        RPCResponseStructureType responseBodyType = null;
        JavaStructureType responseBodyJavaType = null;
        Block responseBodyBlock = null;
        if (isRequestResponse) {
            QName responseBodyName = new QName(responseNamespaceURI, this.info.portTypeOperation.getName() + "Response");
            responseBodyType = new RPCResponseStructureType(responseBodyName);
            responseBodyJavaType = new JavaStructureType(this.getUniqueClassName(this.makePackageQualified(StringUtils.capitalize(structureNamePrefix + this._env.getNames().validExternalJavaIdentifier(this.info.uniqueOperationName)) + "_ResponseStruct", responseBodyName)), false, responseBodyType);
            responseBodyType.setJavaType(responseBodyJavaType);
            responseBodyBlock = new Block(responseBodyName, responseBodyType);
            response.addBodyBlock(responseBodyBlock);
        }
        if (resultParameterName == null) {
            this.info.operation.setProperty(OPERATION_HAS_VOID_RETURN_TYPE, "true");
        } else {
            MessagePart part = outputMessage.getPart(resultParameterName);
            SOAPType soapType = this.getSchemaTypeToSOAPType(part.getDescriptor());
            soapType = (SOAPType)this.verifyResultType(soapType, this.info.operation);
            SOAPStructureMember member = new SOAPStructureMember(new QName(null, part.getName()), soapType);
            JavaStructureMember javaMember = new JavaStructureMember(this._env.getNames().validJavaMemberName(part.getName()), soapType.getJavaType(), member, false);
            javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
            javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
            member.setJavaStructureMember(javaMember);
            responseBodyType.add(member);
            responseBodyJavaType.add(javaMember);
            Parameter parameter = new Parameter(this._env.getNames().validJavaMemberName(part.getName()));
            parameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", part.getName());
            parameter.setEmbedded(true);
            parameter.setType(soapType);
            parameter.setBlock(responseBodyBlock);
            response.addParameter(parameter);
            this.info.operation.setProperty(WSDL_RESULT_PARAMETER, parameter.getName());
        }
        ArrayList<String> definitiveParameterList = new ArrayList<String>();
        for (String name : parameterList) {
            JavaStructureMember javaMember;
            SOAPStructureMember member;
            MessagePart part;
            boolean isInput = inputParameterNames.contains(name);
            boolean isOutput = outputParameterNames.contains(name);
            SOAPType soapType = null;
            Parameter inParameter = null;
            if (isInput && isOutput && !inputMessage.getPart(name).getDescriptor().equals(outputMessage.getPart(name).getDescriptor())) {
                throw new ModelerException("wsdlmodeler.invalid.parameter.differentTypes", new Object[]{name, this.info.operation.getName().getLocalPart()});
            }
            if (isInput) {
                part = inputMessage.getPart(name);
                soapType = this.getSchemaTypeToSOAPType(part.getDescriptor());
                soapType = (SOAPType)this.verifyParameterType(soapType, part.getName(), this.info.operation);
                member = new SOAPStructureMember(new QName(null, part.getName()), soapType);
                javaMember = new JavaStructureMember(this._env.getNames().validJavaMemberName(part.getName()), soapType.getJavaType(), member, false);
                javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
                javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
                member.setJavaStructureMember(javaMember);
                requestBodyType.add(member);
                requestBodyJavaType.add(javaMember);
                inParameter = new Parameter(this._env.getNames().validJavaMemberName(part.getName()));
                inParameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", part.getName());
                inParameter.setEmbedded(true);
                inParameter.setType(soapType);
                inParameter.setBlock(requestBodyBlock);
                request.addParameter(inParameter);
                definitiveParameterList.add(inParameter.getName());
            }
            if (!isOutput) continue;
            part = outputMessage.getPart(name);
            if (soapType == null) {
                soapType = this.getSchemaTypeToSOAPType(part.getDescriptor());
                soapType = (SOAPType)this.verifyParameterType(soapType, part.getName(), this.info.operation);
            }
            member = new SOAPStructureMember(new QName(null, part.getName()), soapType);
            responseBodyType.add(member);
            javaMember = new JavaStructureMember(this._env.getNames().validJavaMemberName(part.getName()), soapType.getJavaType(), member, false);
            responseBodyJavaType.add(javaMember);
            javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
            javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
            member.setJavaStructureMember(javaMember);
            Parameter outParameter = new Parameter(this._env.getNames().validJavaMemberName(part.getName()));
            outParameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", part.getName());
            outParameter.setEmbedded(true);
            outParameter.setType(soapType);
            outParameter.setBlock(responseBodyBlock);
            if (inParameter == null) {
                definitiveParameterList.add(outParameter.getName());
            } else {
                inParameter.setLinkedParameter(outParameter);
                outParameter.setLinkedParameter(inParameter);
            }
            response.addParameter(outParameter);
        }
        this.info.operation.setRequest(request);
        if (isRequestResponse) {
            this.info.operation.setResponse(response);
        }
        Set duplicateNames = this.getDuplicateFaultNames();
        this.handleEncodedSOAPFault(response, duplicateNames);
        boolean explicitServiceContext = this.useExplicitServiceContextForRpcEncoded(inputMessage);
        if (explicitServiceContext) {
            this.handleEncodedSOAPHeaders(request, response, this.info.bindingOperation.getInput().extensions(), duplicateNames, definitiveParameterList, true);
            if (isRequestResponse) {
                this.handleEncodedSOAPHeaders(request, response, this.info.bindingOperation.getOutput().extensions(), duplicateNames, definitiveParameterList, false);
            }
        }
        this.info.operation.setProperty(WSDL_PARAMETER_ORDER, definitiveParameterList);
        return this.info.operation;
    }

    protected AbstractType verifyResultType(AbstractType type, Operation operation) {
        return type;
    }

    protected AbstractType verifyParameterType(AbstractType type, String partName, Operation operation) {
        return type;
    }

    private void handleEncodedSOAPHeaders(Request request, Response response, Iterator iter, Set duplicateNames, List definitiveParameterList, boolean processRequest) {
        while (iter.hasNext()) {
            Extension extension = (Extension)iter.next();
            if (!(extension instanceof SOAPHeader)) continue;
            SOAPHeader header = (SOAPHeader)extension;
            if (header.isLiteral() || !WSDLModelerBase.tokenListContains(header.getEncodingStyle(), soap11WSDLConstants.getSOAPEncodingNamespace())) {
                this.warn("wsdlmodeler.warning.ignoringHeader.notEncoded", new Object[]{header.getPart(), this.info.bindingOperation.getName()});
                continue;
            }
            Message headerMessage = WSDLModelerBase.findMessage(header.getMessage(), this.info);
            if (headerMessage == null) {
                this.warn("wsdlmodeler.warning.ignoringHeader.cant.resolve.message", new Object[]{header.getMessage(), this.info.bindingOperation.getName()});
                continue;
            }
            MessagePart part = headerMessage.getPart(header.getPart());
            if (part == null) {
                this.warn("wsdlmodeler.warning.ignoringHeader.notFound", new Object[]{header.getPart(), this.info.bindingOperation.getName()});
                continue;
            }
            if (processRequest) {
                if (this.isHeaderPartPresentInBody(this.getSOAPRequestBody(), this.getInputMessage(), header.getPart(), true)) {
                    this.warn("wsdlmodeler.warning.ignoringHeader.partFromBody", new Object[]{header.getPart()});
                    this.warn("wsdlmodeler.warning.ignoringHeader", new Object[]{header.getPart(), this.info.bindingOperation.getName()});
                    continue;
                }
            } else if (this.isHeaderPartPresentInBody(this.getSOAPResponseBody(), this.getOutputMessage(), header.getPart(), false)) {
                this.warn("wsdlmodeler.warning.ignoringHeader.partFromBody", new Object[]{header.getPart()});
                this.warn("wsdlmodeler.warning.ignoringHeader", new Object[]{header.getPart(), this.info.bindingOperation.getName()});
                continue;
            }
            SOAPType headerType = this.getSchemaTypeToSOAPType(part.getDescriptor());
            String namespaceURI = header.getNamespace();
            if (namespaceURI == null) {
                namespaceURI = headerType.getName().getNamespaceURI();
            }
            QName headerName = new QName(namespaceURI, header.getPart());
            Block headerBlock = new Block(headerName, headerType);
            headerBlock.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", WSDLModelerBase.getQNameOf(headerMessage));
            AbstractType alreadySeenHeaderType = (AbstractType)this.info.headers.get(headerName);
            if (alreadySeenHeaderType != null && alreadySeenHeaderType != headerType) {
                this.warn("wsdlmodeler.warning.ignoringHeader.inconsistentDefinition", new Object[]{header.getPart(), this.info.bindingOperation.getName()});
            } else {
                this.info.headers.put(headerName, headerType);
                if (processRequest) {
                    request.addHeaderBlock(headerBlock);
                } else {
                    response.addHeaderBlock(headerBlock);
                }
                Parameter parameter = new Parameter(this._env.getNames().validJavaMemberName(part.getName()));
                parameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", part.getName());
                parameter.setEmbedded(false);
                parameter.setType(headerType);
                parameter.setBlock(headerBlock);
                if (processRequest && definitiveParameterList != null) {
                    request.addParameter(parameter);
                    definitiveParameterList.add(parameter.getName());
                } else {
                    if (definitiveParameterList != null) {
                        for (String inParamName : definitiveParameterList) {
                            if (!inParamName.equals(parameter.getName())) continue;
                            Parameter inParam = request.getParameterByName(inParamName);
                            parameter.setLinkedParameter(inParam);
                            inParam.setLinkedParameter(parameter);
                        }
                        if (!definitiveParameterList.contains(parameter.getName())) {
                            definitiveParameterList.add(parameter.getName());
                        }
                    }
                    response.addParameter(parameter);
                }
            }
            this.processHeaderFaults(header, this.info, response, duplicateNames);
        }
    }

    private void handleEncodedSOAPFault(Response response, Set duplicateNames) {
        Iterator iter = this.info.bindingOperation.faults();
        while (iter.hasNext()) {
            BindingFault bindingFault = (BindingFault)iter.next();
            com.sun.xml.rpc.wsdl.document.Fault portTypeFault = null;
            Iterator iter2 = this.info.portTypeOperation.faults();
            while (iter2.hasNext()) {
                com.sun.xml.rpc.wsdl.document.Fault aFault = (com.sun.xml.rpc.wsdl.document.Fault)iter2.next();
                if (!aFault.getName().equals(bindingFault.getName())) continue;
                if (portTypeFault != null) {
                    throw new ModelerException("wsdlmodeler.invalid.bindingFault.notUnique", new Object[]{bindingFault.getName(), this.info.bindingOperation.getName()});
                }
                portTypeFault = aFault;
            }
            if (portTypeFault == null) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.notFound", new Object[]{bindingFault.getName(), this.info.bindingOperation.getName()});
            }
            Fault fault = new Fault(portTypeFault.getMessage().getLocalPart());
            SOAPFault soapFault = (SOAPFault)WSDLModelerBase.getExtensionOfType(bindingFault, SOAPFault.class);
            if (soapFault == null) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.outputMissingSoapFault", new Object[]{bindingFault.getName(), this.info.bindingOperation.getName()});
            }
            if (soapFault.getName() != null && !soapFault.getName().equals(bindingFault.getName())) {
                this.warn("wsdlmodeler.invalid.bindingFault.wrongSoapFaultName", new Object[]{soapFault.getName(), bindingFault.getName(), this.info.bindingOperation.getName()});
            }
            if (soapFault.isLiteral() || !WSDLModelerBase.tokenListContains(soapFault.getEncodingStyle(), soap11WSDLConstants.getSOAPEncodingNamespace())) {
                this.warn("wsdlmodeler.warning.ignoringFault.notEncoded", new Object[]{bindingFault.getName(), this.info.bindingOperation.getName()});
                continue;
            }
            String faultNamespaceURI = soapFault.getNamespace();
            if (faultNamespaceURI == null) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.missingNamespace", new Object[]{bindingFault.getName(), this.info.bindingOperation.getName()});
            }
            Message faultMessage = portTypeFault.resolveMessage(this.info.document);
            Iterator iter22 = faultMessage.parts();
            if (!iter22.hasNext()) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.emptyMessage", new Object[]{bindingFault.getName(), faultMessage.getName()});
            }
            MessagePart faultPart = (MessagePart)iter22.next();
            QName faultQName = new QName(faultNamespaceURI, faultMessage.getName());
            if (duplicateNames.contains(faultQName)) {
                this.warn("wsdlmodeler.duplicate.fault.part.name", new Object[]{bindingFault.getName(), this.info.portTypeOperation.getName(), faultPart.getName()});
                continue;
            }
            if (iter22.hasNext()) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.messageHasMoreThanOnePart", new Object[]{bindingFault.getName(), faultMessage.getName()});
            }
            if (faultPart.getDescriptorKind() != SchemaKinds.XSD_TYPE) {
                throw new ModelerException("wsdlmodeler.invalid.message.partMustHaveTypeDescriptor", new Object[]{faultMessage.getName(), faultPart.getName()});
            }
            SOAPType faultType = this.getSchemaTypeToSOAPType(faultPart.getDescriptor());
            QName elementName = new QName(faultNamespaceURI, faultPart.getName());
            fault.setElementName(elementName);
            fault.setJavaMemberName(elementName.getLocalPart());
            Block faultBlock = new Block(faultQName, faultType);
            fault.setBlock(faultBlock);
            this.createParentFault(fault);
            this.createSubfaults(fault);
            response.addFaultBlock(faultBlock);
            this.info.operation.addFault(fault);
        }
    }

    protected void createParentFault(Fault fault) {
        AbstractType faultType = fault.getBlock().getType();
        AbstractType parentType = null;
        if (faultType instanceof SOAPStructureType) {
            parentType = ((SOAPStructureType)faultType).getParentType();
        } else if (faultType instanceof LiteralStructuredType) {
            parentType = ((LiteralStructuredType)faultType).getParentType();
        }
        if (parentType == null) {
            return;
        }
        if (fault.getParentFault() != null) {
            return;
        }
        Fault parentFault = new Fault(parentType.getName().getLocalPart());
        QName faultQName = new QName(fault.getBlock().getName().getNamespaceURI(), parentFault.getName());
        Block block = new Block(faultQName);
        block.setType(parentType);
        parentFault.setBlock(block);
        parentFault.addSubfault(fault);
        this.createParentFault(parentFault);
    }

    protected void createSubfaults(Fault fault) {
        AbstractType faultType = fault.getBlock().getType();
        Iterator subtypes = null;
        if (faultType instanceof SOAPStructureType) {
            subtypes = ((SOAPStructureType)faultType).getSubtypes();
        } else if (faultType instanceof LiteralStructuredType) {
            subtypes = ((LiteralStructuredType)faultType).getSubtypes();
        }
        if (subtypes != null) {
            while (subtypes.hasNext()) {
                AbstractType subtype = (AbstractType)subtypes.next();
                Fault subFault = new Fault(subtype.getName().getLocalPart());
                QName faultQName = new QName(fault.getBlock().getName().getNamespaceURI(), subFault.getName());
                Block block = new Block(faultQName);
                block.setType(subtype);
                subFault.setBlock(block);
                fault.addSubfault(subFault);
                this.createSubfaults(subFault);
            }
        }
    }

    protected SOAPBody getSOAPRequestBody() {
        SOAPBody requestBody = (SOAPBody)this.getAnyExtensionOfType(this.info.bindingOperation.getInput(), SOAPBody.class);
        if (requestBody == null) {
            throw new ModelerException("wsdlmodeler.invalid.bindingOperation.inputMissingSoapBody", new Object[]{this.info.bindingOperation.getName()});
        }
        return requestBody;
    }

    protected boolean isRequestMimeMultipart() {
        Iterator iter = this.info.bindingOperation.getInput().extensions();
        while (iter.hasNext()) {
            Extension extension = (Extension)iter.next();
            if (!extension.getClass().equals(MIMEMultipartRelated.class)) continue;
            return true;
        }
        return false;
    }

    protected boolean isResponseMimeMultipart() {
        Iterator iter = this.info.bindingOperation.getOutput().extensions();
        while (iter.hasNext()) {
            Extension extension = (Extension)iter.next();
            if (!extension.getClass().equals(MIMEMultipartRelated.class)) continue;
            return true;
        }
        return false;
    }

    protected SOAPBody getSOAPResponseBody() {
        SOAPBody responseBody = (SOAPBody)this.getAnyExtensionOfType(this.info.bindingOperation.getOutput(), SOAPBody.class);
        if (responseBody == null) {
            throw new ModelerException("wsdlmodeler.invalid.bindingOperation.outputMissingSoapBody", new Object[]{this.info.bindingOperation.getName()});
        }
        return responseBody;
    }

    protected Message getOutputMessage() {
        if (this.info.portTypeOperation.getOutput() == null) {
            return null;
        }
        return this.info.portTypeOperation.getOutput().resolveMessage(this.info.document);
    }

    protected Message getInputMessage() {
        return this.info.portTypeOperation.getInput().resolveMessage(this.info.document);
    }

    protected void setSOAPUse() {
        SOAPBody requestBody = this.getSOAPRequestBody();
        SOAPBody responseBody = null;
        if (this.useWSIBasicProfile && requestBody != null && !requestBody.isLiteral() && !requestBody.isEncoded()) {
            requestBody.setUse(SOAPUse.LITERAL);
        } else if (requestBody != null && requestBody.isEncoded()) {
            requestBody.setUse(SOAPUse.ENCODED);
        }
        if (this.info.portTypeOperation.getStyle() == OperationStyle.REQUEST_RESPONSE) {
            responseBody = this.getSOAPResponseBody();
            if (this.useWSIBasicProfile && responseBody != null && !responseBody.isLiteral() && !responseBody.isEncoded()) {
                responseBody.setUse(SOAPUse.LITERAL);
            } else if (responseBody != null && responseBody.isEncoded()) {
                responseBody.setUse(SOAPUse.ENCODED);
            }
        }
    }

    protected List getMessageParts(SOAPBody body, Message message, boolean isInput) {
        MessagePart mPart;
        Iterator iter;
        String bodyParts = body.getParts();
        ArrayList<MessagePart> partsList = new ArrayList<MessagePart>();
        ArrayList<MessagePart> parts = new ArrayList<MessagePart>();
        List mimeParts = null;
        mimeParts = isInput ? this.getMimeContentParts(message, this.info.bindingOperation.getInput()) : this.getMimeContentParts(message, this.info.bindingOperation.getOutput());
        if (bodyParts != null) {
            StringTokenizer in = new StringTokenizer(bodyParts.trim(), " ");
            while (in.hasMoreTokens()) {
                String part = in.nextToken();
                MessagePart mPart2 = message.getPart(part);
                if (null == mPart2) {
                    throw new ModelerException("wsdlmodeler.error.partsNotFound", new Object[]{part, message.getName()});
                }
                mPart2.setBindingExtensibilityElementKind(1);
                partsList.add(mPart2);
            }
        } else {
            iter = message.parts();
            while (iter.hasNext()) {
                mPart = (MessagePart)iter.next();
                if (!mimeParts.contains(mPart)) {
                    mPart.setBindingExtensibilityElementKind(1);
                }
                partsList.add(mPart);
            }
        }
        iter = message.parts();
        while (iter.hasNext()) {
            mPart = (MessagePart)iter.next();
            if (mimeParts.contains(mPart)) {
                mPart.setBindingExtensibilityElementKind(5);
                parts.add(mPart);
                continue;
            }
            if (!partsList.contains(mPart)) continue;
            mPart.setBindingExtensibilityElementKind(1);
            parts.add(mPart);
        }
        return parts;
    }

    private List getMimeContentParts(Message message, Extensible ext) {
        ArrayList<MessagePart> mimeContentParts = new ArrayList<MessagePart>();
        Object mimeContentPartName = null;
        Iterator mimeParts = this.getMimeParts(ext);
        while (mimeParts.hasNext()) {
            MessagePart part = this.getMimeContentPart(message, (MIMEPart)mimeParts.next());
            if (part == null) continue;
            mimeContentParts.add(part);
        }
        return mimeContentParts;
    }

    private boolean validateMimeParts(Iterator mimeParts) {
        boolean gotRootPart = false;
        ArrayList<MIMEContent> mimeContents = new ArrayList<MIMEContent>();
        while (mimeParts.hasNext()) {
            MIMEPart mPart = (MIMEPart)mimeParts.next();
            Iterator extns = mPart.extensions();
            while (extns.hasNext()) {
                Object obj = extns.next();
                if (obj instanceof SOAPBody) {
                    if (gotRootPart) {
                        this.warn("mimemodeler.invalidMimePart.moreThanOneSOAPBody", new Object[]{this.info.operation.getName().getLocalPart()});
                        return false;
                    }
                    gotRootPart = true;
                    continue;
                }
                if (!(obj instanceof MIMEContent)) continue;
                mimeContents.add((MIMEContent)obj);
            }
            if (!this.validateMimeContentPartNames(mimeContents.iterator())) {
                return false;
            }
            if (mPart.getName() == null) continue;
            this.warn("mimemodeler.invalidMimePart.nameNotAllowed", this.info.portTypeOperation.getName());
        }
        return true;
    }

    private MessagePart getMimeContentPart(Message message, MIMEPart part) {
        String mimeContentPartName = null;
        Iterator mimeContents = this.getMimeContents(part).iterator();
        if (mimeContents.hasNext()) {
            mimeContentPartName = ((MIMEContent)mimeContents.next()).getPart();
            MessagePart mPart = message.getPart(mimeContentPartName);
            if (null == mPart) {
                throw new ModelerException("wsdlmodeler.error.partsNotFound", new Object[]{mimeContentPartName, message.getName()});
            }
            mPart.setBindingExtensibilityElementKind(5);
            return mPart;
        }
        return null;
    }

    private List getAlternateMimeTypes(List mimeContents) {
        ArrayList<String> mimeTypes = new ArrayList<String>();
        String mimeType = null;
        for (MIMEContent mimeContent : mimeContents) {
            String newMimeType;
            if (mimeType == null) {
                mimeType = this.getMimeContentType(mimeContent);
                mimeTypes.add(mimeType);
            }
            if ((newMimeType = this.getMimeContentType(mimeContent)).equals(mimeType)) continue;
            mimeTypes.add(newMimeType);
        }
        return mimeTypes;
    }

    private boolean validateMimeContentPartNames(Iterator mimeContents) {
        while (mimeContents.hasNext()) {
            String mimeContnetPart = null;
            if (mimeContnetPart == null) {
                mimeContnetPart = this.getMimeContentPartName((MIMEContent)mimeContents.next());
                if (mimeContnetPart != null) continue;
                this.warn("mimemodeler.invalidMimeContent.missingPartAttribute", new Object[]{this.info.operation.getName().getLocalPart()});
                return false;
            }
            String newMimeContnetPart = this.getMimeContentPartName((MIMEContent)mimeContents.next());
            if (newMimeContnetPart == null) {
                this.warn("mimemodeler.invalidMimeContent.missingPartAttribute", new Object[]{this.info.operation.getName().getLocalPart()});
                return false;
            }
            if (newMimeContnetPart.equals(mimeContnetPart)) continue;
            this.warn("mimemodeler.invalidMimeContent.differentPart");
            return false;
        }
        return true;
    }

    private Iterator getMimeParts(Extensible ext) {
        MIMEMultipartRelated multiPartRelated = (MIMEMultipartRelated)this.getAnyExtensionOfType(ext, MIMEMultipartRelated.class);
        if (multiPartRelated == null) {
            ArrayList parts = new ArrayList();
            return parts.iterator();
        }
        return multiPartRelated.getParts();
    }

    private List getMimeContents(MIMEPart part) {
        ArrayList<MIMEContent> mimeContents = new ArrayList<MIMEContent>();
        Iterator parts = part.extensions();
        while (parts.hasNext()) {
            Extension mimeContent = (Extension)parts.next();
            if (!(mimeContent instanceof MIMEContent)) continue;
            mimeContents.add((MIMEContent)mimeContent);
        }
        return mimeContents;
    }

    private String getMimeContentPartName(MIMEContent mimeContent) {
        return mimeContent.getPart();
    }

    private String getMimeContentType(MIMEContent mimeContent) {
        String mimeType = mimeContent.getType();
        if (mimeType == null) {
            throw new ModelerException("mimemodeler.invalidMimeContent.missingTypeAttribute", new Object[]{this.info.operation.getName().getLocalPart()});
        }
        return mimeType;
    }

    protected List processParameterOrder(Set inputParameterNames, Set outputParameterNames, StringBuffer resultParameterName) {
        boolean inputIsEmpty;
        if (resultParameterName == null) {
            resultParameterName = new StringBuffer();
        }
        SOAPBody soapRequestBody = this.getSOAPRequestBody();
        Message inputMessage = this.getInputMessage();
        boolean isRequestResponse = this.info.portTypeOperation.getStyle() == OperationStyle.REQUEST_RESPONSE;
        SOAPBody soapResponseBody = null;
        Message outputMessage = null;
        String parameterOrder = this.info.portTypeOperation.getParameterOrder();
        List<String> parameterList = null;
        boolean buildParameterList = false;
        if (parameterOrder != null && !parameterOrder.trim().equals("")) {
            parameterList = XmlUtil.parseTokenList(parameterOrder);
        } else {
            parameterList = new ArrayList();
            buildParameterList = true;
        }
        HashSet<String> partNames = new HashSet<String>();
        boolean gotOne = false;
        List inputMessageParts = this.getMessageParts(soapRequestBody, inputMessage, true);
        SOAPOperation soapOperation = (SOAPOperation)WSDLModelerBase.getExtensionOfType(this.info.bindingOperation, SOAPOperation.class);
        for (MessagePart part : inputMessageParts) {
            if (part.getBindingExtensibilityElementKind() == 1 && !this.isStyleAndPartMatch(soapOperation, part)) continue;
            partNames.add(part.getName());
            inputParameterNames.add(part.getName());
            if (buildParameterList) {
                parameterList.add(part.getName());
            }
            gotOne = true;
        }
        boolean bl = inputIsEmpty = !gotOne;
        if (isRequestResponse) {
            outputMessage = this.getOutputMessage();
            soapResponseBody = this.getSOAPResponseBody();
            gotOne = false;
            List outputMessageParts = this.getMessageParts(soapResponseBody, outputMessage, false);
            Iterator partsIter = outputMessageParts.iterator();
            while (partsIter.hasNext()) {
                MessagePart part = (MessagePart)partsIter.next();
                if (part.getBindingExtensibilityElementKind() == 1 && !this.isStyleAndPartMatch(soapOperation, part)) continue;
                partNames.add(part.getName());
                if (!partsIter.hasNext() && outputParameterNames.size() == 0 && buildParameterList && !this.isSingleInOutPart(inputParameterNames, part)) {
                    resultParameterName.append(part.getName());
                } else {
                    outputParameterNames.add(part.getName());
                    if (buildParameterList && !inputParameterNames.contains(part.getName())) {
                        parameterList.add(part.getName());
                    }
                }
                gotOne = true;
            }
        }
        if (!buildParameterList) {
            String partName;
            for (String name : parameterList) {
                if (!partNames.contains(name)) {
                    throw new ModelerException("wsdlmodeler.invalid.parameterorder.parameter", new Object[]{name, this.info.operation.getName().getLocalPart()});
                }
                partNames.remove(name);
            }
            if (partNames.size() > 1) {
                for (String name : partNames) {
                    if (inputParameterNames.contains(name) && !outputParameterNames.contains(name)) {
                        throw new ModelerException("wsdlmodeler.invalid.parameterOrder.tooManyUnmentionedParts", new Object[]{this.info.operation.getName().getLocalPart()});
                    }
                    if (!outputParameterNames.contains(name)) continue;
                    parameterList.add(name);
                }
            }
            if (partNames.size() == 1 && outputParameterNames.contains(partName = (String)partNames.iterator().next())) {
                resultParameterName.append(partName);
            }
        }
        return parameterList;
    }

    protected boolean isSingleInOutPart(Set inputParameterNames, MessagePart outputPart) {
        SOAPOperation soapOperation = (SOAPOperation)WSDLModelerBase.getExtensionOfType(this.info.bindingOperation, SOAPOperation.class);
        if (soapOperation != null && (soapOperation.isDocument() || this.info.soapBinding.isDocument())) {
            return false;
        }
        Message inputMessage = this.getInputMessage();
        return inputParameterNames.contains(outputPart.getName()) && inputMessage.getPart(outputPart.getName()).getDescriptor().equals(outputPart.getDescriptor());
    }

    protected boolean isOperationDocumentLiteral() {
        SOAPOperation soapOperation = (SOAPOperation)WSDLModelerBase.getExtensionOfType(this.info.bindingOperation, SOAPOperation.class);
        return soapOperation != null && soapOperation.isDocument() || this.info.soapBinding.isDocument();
    }

    protected boolean isStyleAndPartMatch(SOAPOperation soapOperation, MessagePart part) {
        return !(soapOperation != null && soapOperation.getStyle() != null ? soapOperation.isDocument() && part.getDescriptorKind() != SchemaKinds.XSD_ELEMENT && this.useWSIBasicProfile || soapOperation.isRPC() && part.getDescriptorKind() != SchemaKinds.XSD_TYPE && this.useWSIBasicProfile : this.info.soapBinding.isDocument() && part.getDescriptorKind() != SchemaKinds.XSD_ELEMENT && this.useWSIBasicProfile || this.info.soapBinding.isRPC() && part.getDescriptorKind() != SchemaKinds.XSD_TYPE && this.useWSIBasicProfile);
    }

    protected String getRequestNamespaceURI(SOAPBody body) {
        String namespaceURI = body.getNamespace();
        if (namespaceURI == null) {
            throw new ModelerException("wsdlmodeler.invalid.bindingOperation.inputSoapBody.missingNamespace", new Object[]{this.info.bindingOperation.getName()});
        }
        return namespaceURI;
    }

    protected String getResponseNamespaceURI(SOAPBody body) {
        String namespaceURI = body.getNamespace();
        if (namespaceURI == null) {
            throw new ModelerException("wsdlmodeler.invalid.bindingOperation.outputSoapBody.missingNamespace", new Object[]{this.info.bindingOperation.getName()});
        }
        return namespaceURI;
    }

    protected String getStructureNamePrefix() {
        String structureNamePrefix = null;
        QName portTypeName = (QName)this.info.modelPort.getProperty("com.sun.xml.rpc.processor.model.WSDLPortTypeName");
        structureNamePrefix = portTypeName != null ? this.getNonQualifiedNameFor(portTypeName) : this.getNonQualifiedNameFor(this.info.modelPort.getName());
        structureNamePrefix = structureNamePrefix + "_";
        return structureNamePrefix;
    }

    protected Operation processSOAPOperationRPCLiteralStyle() {
        boolean isRequestResponse = this.info.portTypeOperation.getStyle() == OperationStyle.REQUEST_RESPONSE;
        Request request = new Request();
        Response response = new Response();
        this.info.operation.setUse(SOAPUse.LITERAL);
        SOAPBody soapRequestBody = this.getSOAPRequestBody();
        if (soapRequestBody != null && this.isRequestMimeMultipart()) {
            request.setProperty(MESSAGE_HAS_MIME_MULTIPART_RELATED_BINDING, "true");
        }
        SOAPBody soapResponseBody = null;
        Message outputMessage = null;
        if (isRequestResponse) {
            soapResponseBody = this.getSOAPResponseBody();
            outputMessage = this.getOutputMessage();
            if (outputMessage != null) {
                response.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", WSDLModelerBase.getQNameOf(outputMessage));
            }
            if (soapResponseBody != null && this.isResponseMimeMultipart()) {
                response.setProperty(MESSAGE_HAS_MIME_MULTIPART_RELATED_BINDING, "true");
            }
        }
        this.setSOAPUse();
        if (!soapRequestBody.isLiteral() || soapResponseBody != null && !soapResponseBody.isLiteral()) {
            this.warn("wsdlmodeler.warning.ignoringOperation.notLiteral", this.info.portTypeOperation.getName());
            return null;
        }
        if (!this.validateMimeParts(this.getMimeParts(this.info.bindingOperation.getInput())) || !this.validateMimeParts(this.getMimeParts(this.info.bindingOperation.getOutput()))) {
            return null;
        }
        Message inputMessage = this.getInputMessage();
        this.setJavaOperationNameProperty(inputMessage);
        if (inputMessage != null) {
            request.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", WSDLModelerBase.getQNameOf(inputMessage));
        }
        HashSet inputParameterNames = new HashSet();
        HashSet outputParameterNames = new HashSet();
        HashSet mimeContentParameterNames = new HashSet();
        String resultParameterName = null;
        StringBuffer result = new StringBuffer();
        List parameterList = this.processParameterOrder(inputParameterNames, outputParameterNames, result);
        if (result.length() > 0) {
            resultParameterName = result.toString();
        }
        String requestNamespaceURI = this.getRequestNamespaceURI(soapRequestBody);
        String responseNamespaceURI = null;
        if (isRequestResponse) {
            responseNamespaceURI = this.getResponseNamespaceURI(soapResponseBody);
        }
        String structureNamePrefix = this.getStructureNamePrefix();
        QName reqBodyName = new QName(requestNamespaceURI, this.info.portTypeOperation.getName());
        LiteralSequenceType reqType = new LiteralSequenceType(reqBodyName);
        reqType.setRpcWrapper(true);
        Block reqBlock = new Block(reqBodyName, reqType);
        JavaStructureType requestBodyJavaType = new JavaStructureType(this.getUniqueClassName(this.makePackageQualified(StringUtils.capitalize(structureNamePrefix + this._env.getNames().validExternalJavaIdentifier(this.info.uniqueOperationName)) + "_RequestStruct", reqBodyName)), false, reqType);
        reqType.setJavaType(requestBodyJavaType);
        request.addBodyBlock(reqBlock);
        LiteralSequenceType resType = null;
        Block resBlock = null;
        JavaStructureType responseBodyJavaType = null;
        if (isRequestResponse) {
            QName resBodyName = new QName(responseNamespaceURI, this.info.portTypeOperation.getName() + "Response");
            resType = new LiteralSequenceType(resBodyName);
            resType.setRpcWrapper(true);
            resBlock = new Block(resBodyName, resType);
            responseBodyJavaType = new JavaStructureType(this.getUniqueClassName(this.makePackageQualified(StringUtils.capitalize(structureNamePrefix + this._env.getNames().validExternalJavaIdentifier(this.info.uniqueOperationName)) + "_ResponseStruct", resBodyName)), false, resType);
            resType.setJavaType(responseBodyJavaType);
            response.addBodyBlock(resBlock);
        }
        if (resultParameterName == null) {
            this.info.operation.setProperty(OPERATION_HAS_VOID_RETURN_TYPE, "true");
        } else {
            MessagePart part = outputMessage.getPart(resultParameterName);
            if (this.isBoundToMimeContent(part)) {
                List mimeContents = this.getMimeContents(this.info.bindingOperation.getOutput(), this.getOutputMessage(), resultParameterName);
                LiteralAttachmentType mimeModelType = this.getAttachmentType(mimeContents, part);
                Block block = new Block(new QName(part.getName()), mimeModelType);
                response.addAttachmentBlock(block);
                Parameter outParameter = new Parameter(this.getEnvironment().getNames().validJavaMemberName(part.getName()));
                outParameter.setEmbedded(false);
                outParameter.setType(mimeModelType);
                outParameter.setBlock(block);
                outParameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", part.getName());
                response.addParameter(outParameter);
                this.info.operation.setProperty(WSDL_RESULT_PARAMETER, outParameter.getName());
            } else if (this.isBoundToSOAPBody(part)) {
                LiteralType literalType = part.getDescriptorKind() == SchemaKinds.XSD_TYPE ? this._analyzer.schemaTypeToLiteralType(part.getDescriptor()) : this.getElementTypeToLiteralType(part.getDescriptor());
                literalType = (LiteralType)this.verifyResultType(literalType, this.info.operation);
                LiteralElementMember member = new LiteralElementMember(new QName(null, part.getName()), literalType);
                member.setRequired(true);
                JavaStructureMember javaMember = this.getJavaMember(part, literalType, member);
                member.setJavaStructureMember(javaMember);
                resType.add(member);
                responseBodyJavaType.add(javaMember);
                Parameter parameter = this.getParameter(part, literalType, resBlock);
                response.addParameter(parameter);
                this.info.operation.setProperty(WSDL_RESULT_PARAMETER, parameter.getName());
            }
        }
        ArrayList<String> definitiveParameterList = new ArrayList<String>();
        for (String name : parameterList) {
            Block block;
            LiteralAttachmentType mimeModelType;
            List mimeContents;
            LiteralType literalType;
            MessagePart part;
            boolean isInput = inputParameterNames.contains(name);
            boolean isOutput = outputParameterNames.contains(name);
            boolean isBoundToSoapBody = this.isBoundToSOAPBody(inputMessage.getPart(name));
            boolean isBoundToMimeContent = this.isBoundToMimeContent(inputMessage.getPart(name));
            Parameter outParameter = null;
            Parameter inParameter = null;
            if (isInput && isOutput && this.isBoundToSOAPBody(inputMessage.getPart(name)) && !inputMessage.getPart(name).getDescriptor().equals(outputMessage.getPart(name).getDescriptor())) {
                throw new ModelerException("wsdlmodeler.invalid.parameter.differentTypes", new Object[]{name, this.info.operation.getName().getLocalPart()});
            }
            if (isInput && this.isBoundToSOAPBody(inputMessage.getPart(name))) {
                part = inputMessage.getPart(name);
                literalType = part.getDescriptorKind() == SchemaKinds.XSD_TYPE ? this._analyzer.schemaTypeToLiteralType(part.getDescriptor()) : this.getElementTypeToLiteralType(part.getDescriptor());
                literalType = (LiteralType)this.verifyParameterType(literalType, part.getName(), this.info.operation);
                inParameter = new Parameter(this._env.getNames().validJavaMemberName(part.getName()));
                inParameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", part.getName());
                inParameter.setEmbedded(true);
                inParameter.setType(literalType);
                inParameter.setBlock(reqBlock);
                request.addParameter(inParameter);
                definitiveParameterList.add(inParameter.getName());
                this.addParameterToStructures(part, inParameter, reqType, requestBodyJavaType);
            } else if (isInput && this.isBoundToMimeContent(inputMessage.getPart(name))) {
                part = inputMessage.getPart(name);
                mimeContents = this.getMimeContents(this.info.bindingOperation.getInput(), this.getInputMessage(), name);
                mimeModelType = this.getAttachmentType(mimeContents, part);
                block = new Block(new QName(part.getName()), mimeModelType);
                request.addAttachmentBlock(block);
                inParameter = new Parameter(this.getEnvironment().getNames().validJavaMemberName(part.getName()));
                inParameter.setEmbedded(false);
                inParameter.setType(mimeModelType);
                inParameter.setBlock(block);
                inParameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", part.getName());
                request.addParameter(inParameter);
                definitiveParameterList.add(inParameter.getName());
            }
            if (isOutput && this.isBoundToSOAPBody(outputMessage.getPart(name))) {
                part = outputMessage.getPart(name);
                literalType = part.getDescriptorKind() == SchemaKinds.XSD_TYPE ? this._analyzer.schemaTypeToLiteralType(part.getDescriptor()) : this.getElementTypeToLiteralType(part.getDescriptor());
                literalType = (LiteralType)this.verifyParameterType(literalType, part.getName(), this.info.operation);
                outParameter = new Parameter(this._env.getNames().validJavaMemberName(part.getName()));
                outParameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", part.getName());
                outParameter.setEmbedded(true);
                outParameter.setType(literalType);
                outParameter.setBlock(resBlock);
                response.addParameter(outParameter);
                this.addParameterToStructures(part, outParameter, resType, responseBodyJavaType);
                if (inParameter == null) {
                    definitiveParameterList.add(outParameter.getName());
                    continue;
                }
                inParameter.setLinkedParameter(outParameter);
                outParameter.setLinkedParameter(inParameter);
                continue;
            }
            if (!isOutput || !this.isBoundToMimeContent(outputMessage.getPart(name)) || (part = outputMessage.getPart(name)) == null) continue;
            mimeContents = this.getMimeContents(this.info.bindingOperation.getOutput(), this.getOutputMessage(), name);
            mimeModelType = this.getAttachmentType(mimeContents, part);
            block = new Block(new QName(part.getName()), mimeModelType);
            response.addAttachmentBlock(block);
            outParameter = new Parameter(this.getEnvironment().getNames().validJavaMemberName(part.getName()));
            outParameter.setEmbedded(false);
            outParameter.setType(mimeModelType);
            outParameter.setBlock(block);
            outParameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", part.getName());
            response.addParameter(outParameter);
            if (inParameter == null) {
                definitiveParameterList.add(outParameter.getName());
                continue;
            }
            Parameter inParam = request.getParameterByName(inParameter.getName());
            List inMimeTypes = ((LiteralAttachmentType)inParameter.getType()).getAlternateMIMETypes();
            List outMimeTypes = ((LiteralAttachmentType)outParameter.getType()).getAlternateMIMETypes();
            boolean sameMimeTypes = true;
            if (inMimeTypes.size() == outMimeTypes.size()) {
                Iterator inTypesIter = inMimeTypes.iterator();
                Iterator outTypesIter = outMimeTypes.iterator();
                while (inTypesIter.hasNext()) {
                    String outTypeName;
                    String inTypeName = (String)inTypesIter.next();
                    if (inTypeName.equals(outTypeName = (String)outTypesIter.next())) continue;
                    sameMimeTypes = false;
                    break;
                }
            }
            String inMimeType = ((LiteralAttachmentType)inParam.getType()).getMIMEType();
            String outMimeType = ((LiteralAttachmentType)outParameter.getType()).getMIMEType();
            if (!inParameter.getType().getName().equals(outParameter.getType().getName()) || !sameMimeTypes) continue;
            outParameter.setLinkedParameter(inParameter);
            inParameter.setLinkedParameter(outParameter);
        }
        this.info.operation.setRequest(request);
        if (isRequestResponse) {
            this.info.operation.setResponse(response);
        }
        Set duplicateNames = this.getDuplicateFaultNames();
        this.handleLiteralSOAPFault(response, duplicateNames);
        boolean explicitServiceContext = this.useExplicitServiceContextForRpcLit(inputMessage);
        if (explicitServiceContext) {
            this.handleLiteralSOAPHeaders(request, response, this.getHeaderExtensions(this.info.bindingOperation.getInput()), duplicateNames, definitiveParameterList, true);
            if (isRequestResponse) {
                this.handleLiteralSOAPHeaders(request, response, this.getHeaderExtensions(this.info.bindingOperation.getOutput()), duplicateNames, definitiveParameterList, false);
            }
        }
        this.info.operation.setProperty(WSDL_PARAMETER_ORDER, definitiveParameterList);
        return this.info.operation;
    }

    protected boolean isBoundToMimeContent(MessagePart part) {
        return part != null && part.getBindingExtensibilityElementKind() == 5;
    }

    protected boolean isBoundToSOAPBody(MessagePart part) {
        return part != null && part.getBindingExtensibilityElementKind() == 1;
    }

    private Iterator getHeaderExtensions(Extensible extensible) {
        ArrayList headerList = new ArrayList();
        Iterator bindingIter = extensible.extensions();
        while (bindingIter.hasNext()) {
            Extension extension = (Extension)bindingIter.next();
            if (extension.getClass().equals(MIMEMultipartRelated.class)) {
                Iterator parts = ((MIMEMultipartRelated)extension).getParts();
                while (parts.hasNext()) {
                    Extension part = (Extension)parts.next();
                    if (!part.getClass().equals(MIMEPart.class)) continue;
                    boolean isRootPart = this.isRootPart((MIMEPart)part);
                    Iterator iter = ((MIMEPart)part).extensions();
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        if (!(obj instanceof SOAPHeader)) continue;
                        if (!isRootPart) {
                            this.warn("mimemodeler.warning.IgnoringinvalidHeaderPart.notDeclaredInRootPart", new Object[]{this.info.bindingOperation.getName()});
                            return new ArrayList().iterator();
                        }
                        headerList.add(obj);
                    }
                }
                continue;
            }
            if (!(extension instanceof SOAPHeader)) continue;
            headerList.add(extension);
        }
        return headerList.iterator();
    }

    private boolean isRootPart(MIMEPart part) {
        Iterator iter = part.extensions();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof SOAPBody)) continue;
            return true;
        }
        return false;
    }

    protected void handleLiteralSOAPFault(Response response, Set duplicateNames) {
        Iterator iter = this.info.bindingOperation.faults();
        while (iter.hasNext()) {
            Message faultMessage;
            Iterator iter2;
            String faultNamespaceURI;
            BindingFault bindingFault = (BindingFault)iter.next();
            com.sun.xml.rpc.wsdl.document.Fault portTypeFault = null;
            Iterator iter22 = this.info.portTypeOperation.faults();
            while (iter22.hasNext()) {
                com.sun.xml.rpc.wsdl.document.Fault aFault = (com.sun.xml.rpc.wsdl.document.Fault)iter22.next();
                if (!aFault.getName().equals(bindingFault.getName())) continue;
                if (portTypeFault != null) {
                    throw new ModelerException("wsdlmodeler.invalid.bindingFault.notUnique", new Object[]{bindingFault.getName(), this.info.bindingOperation.getName()});
                }
                portTypeFault = aFault;
            }
            if (portTypeFault == null) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.notFound", new Object[]{bindingFault.getName(), this.info.bindingOperation.getName()});
            }
            Fault fault = new Fault(portTypeFault.getMessage().getLocalPart());
            SOAPFault soapFault = (SOAPFault)WSDLModelerBase.getExtensionOfType(bindingFault, SOAPFault.class);
            if (soapFault == null) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.outputMissingSoapFault", new Object[]{bindingFault.getName(), this.info.bindingOperation.getName()});
            }
            if (!soapFault.isLiteral()) {
                this.warn("wsdlmodeler.warning.ignoringFault.notLiteral", new Object[]{bindingFault.getName(), this.info.bindingOperation.getName()});
                continue;
            }
            if (this.useWSIBasicProfile) {
                if (soapFault.getName() == null) {
                    this.warn("wsdlmodeler.invalid.bindingFault.noSoapFaultName", new Object[]{bindingFault.getName(), this.info.bindingOperation.getName()});
                } else if (!soapFault.getName().equals(bindingFault.getName())) {
                    this.warn("wsdlmodeler.invalid.bindingFault.wrongSoapFaultName", new Object[]{soapFault.getName(), bindingFault.getName(), this.info.bindingOperation.getName()});
                } else if (soapFault.getNamespace() != null) {
                    this.warn("wsdlmodeler.warning.r2716r2726", new Object[]{"soapbind:fault", soapFault.getName()});
                }
            }
            if ((faultNamespaceURI = soapFault.getNamespace()) == null) {
                faultNamespaceURI = portTypeFault.getMessage().getNamespaceURI();
            }
            if (!(iter2 = (faultMessage = portTypeFault.resolveMessage(this.info.document)).parts()).hasNext()) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.emptyMessage", new Object[]{bindingFault.getName(), faultMessage.getName()});
            }
            MessagePart faultPart = (MessagePart)iter2.next();
            QName faultQName = new QName(faultNamespaceURI, faultMessage.getName());
            if (duplicateNames.contains(faultQName)) {
                this.warn("wsdlmodeler.duplicate.fault.soap.name", new Object[]{bindingFault.getName(), this.info.portTypeOperation.getName(), faultPart.getName()});
                continue;
            }
            if (iter2.hasNext()) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.messageHasMoreThanOnePart", new Object[]{bindingFault.getName(), faultMessage.getName()});
            }
            if (faultPart.getDescriptorKind() != SchemaKinds.XSD_ELEMENT && this.useWSIBasicProfile) {
                throw new ModelerException("wsdlmodeler.invalid.message.partMustHaveElementDescriptor", new Object[]{faultMessage.getName(), faultPart.getName()});
            }
            LiteralType faultType = faultPart.getDescriptorKind() == SchemaKinds.XSD_TYPE ? this._analyzer.schemaTypeToLiteralType(faultPart.getDescriptor()) : this.getElementTypeToLiteralType(faultPart.getDescriptor());
            LiteralSequenceType partType = new LiteralSequenceType(faultPart.getDescriptor());
            QName elemName = this.info.soapBinding.getStyle() == SOAPStyle.RPC && !(faultType instanceof LiteralStructuredType) ? new QName(faultNamespaceURI, faultPart.getName()) : faultPart.getDescriptor();
            fault.setElementName(elemName);
            fault.setJavaMemberName(faultPart.getName());
            Block faultBlock = new Block(faultQName, faultType);
            fault.setBlock(faultBlock);
            this.createParentFault(fault);
            this.createSubfaults(fault);
            response.addFaultBlock(faultBlock);
            this.info.operation.addFault(fault);
        }
    }

    private void handleLiteralSOAPHeaders(Request request, Response response, Iterator iter, Set duplicateNames, List definitiveParameterList, boolean processRequest) {
        while (iter.hasNext()) {
            Message headerMessage;
            Extension extension = (Extension)iter.next();
            if (!(extension instanceof SOAPHeader)) continue;
            SOAPHeader header = (SOAPHeader)extension;
            if (this.useWSIBasicProfile && !header.isLiteral() && !header.isEncoded()) {
                header.setUse(SOAPUse.LITERAL);
            }
            if (!header.isLiteral()) {
                this.warn("wsdlmodeler.warning.ignoringHeader.notLiteral", new Object[]{header.getPart(), this.info.bindingOperation.getName()});
                continue;
            }
            if (header.getNamespace() != null) {
                this.warn("wsdlmodeler.warning.r2716r2726", new Object[]{"soapbind:header", this.info.bindingOperation.getName()});
            }
            if ((headerMessage = WSDLModelerBase.findMessage(header.getMessage(), this.info)) == null) {
                this.warn("wsdlmodeler.warning.ignoringHeader.cant.resolve.message", new Object[]{header.getMessage(), this.info.bindingOperation.getName()});
                continue;
            }
            MessagePart part = headerMessage.getPart(header.getPart());
            if (part == null) {
                this.warn("wsdlmodeler.warning.ignoringHeader.notFound", new Object[]{header.getPart(), this.info.bindingOperation.getName()});
                continue;
            }
            if (part.getDescriptorKind() != SchemaKinds.XSD_ELEMENT && this.useWSIBasicProfile) {
                this.warn("wsdlmodeler.invalid.message.partMustHaveElementDescriptor", new Object[]{headerMessage.getName(), part.getName()});
                this.warn("wsdlmodeler.warning.ignoringHeader", new Object[]{header.getPart(), this.info.bindingOperation.getName()});
                continue;
            }
            if (processRequest) {
                if (this.isHeaderPartPresentInBody(this.getSOAPRequestBody(), this.getInputMessage(), header.getPart(), true)) {
                    this.warn("wsdlmodeler.warning.ignoringHeader.partFromBody", new Object[]{header.getPart()});
                    this.warn("wsdlmodeler.warning.ignoringHeader", new Object[]{header.getPart(), this.info.bindingOperation.getName()});
                    continue;
                }
            } else if (this.isHeaderPartPresentInBody(this.getSOAPResponseBody(), this.getOutputMessage(), header.getPart(), false)) {
                this.warn("wsdlmodeler.warning.ignoringHeader.partFromBody", new Object[]{header.getPart()});
                this.warn("wsdlmodeler.warning.ignoringHeader", new Object[]{header.getPart(), this.info.bindingOperation.getName()});
                continue;
            }
            LiteralType headerType = part.getDescriptorKind() == SchemaKinds.XSD_TYPE ? this._analyzer.schemaTypeToLiteralType(part.getDescriptor()) : this.getElementTypeToLiteralType(part.getDescriptor());
            Block block = new Block(part.getDescriptor(), headerType);
            block.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", WSDLModelerBase.getQNameOf(headerMessage));
            AbstractType alreadySeenHeaderType = (AbstractType)this.info.headers.get(block.getName());
            if (alreadySeenHeaderType != null && alreadySeenHeaderType != headerType) {
                this.warn("wsdlmodeler.warning.ignoringHeader.inconsistentDefinition", new Object[]{header.getPart(), this.info.bindingOperation.getName()});
                continue;
            }
            this.info.headers.put(block.getName(), headerType);
            if (processRequest) {
                request.addHeaderBlock(block);
            } else {
                response.addHeaderBlock(block);
            }
            Parameter parameter = new Parameter(this._env.getNames().validJavaMemberName(part.getName()));
            parameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", part.getName());
            parameter.setEmbedded(false);
            parameter.setType(headerType);
            parameter.setBlock(block);
            if (processRequest && definitiveParameterList != null) {
                request.addParameter(parameter);
                definitiveParameterList.add(parameter.getName());
            } else {
                if (definitiveParameterList != null) {
                    for (String inParamName : definitiveParameterList) {
                        if (!inParamName.equals(parameter.getName())) continue;
                        Parameter inParam = request.getParameterByName(inParamName);
                        parameter.setLinkedParameter(inParam);
                        inParam.setLinkedParameter(parameter);
                    }
                    if (!definitiveParameterList.contains(parameter.getName())) {
                        definitiveParameterList.add(parameter.getName());
                    }
                }
                response.addParameter(parameter);
            }
            this.processHeaderFaults(header, this.info, response, duplicateNames);
        }
    }

    private boolean isHeaderPartPresentInBody(SOAPBody body, Message message, String headerPart, boolean isInput) {
        Iterator parts = this.getMessageParts(body, message, isInput).iterator();
        while (parts.hasNext()) {
            if (!((MessagePart)parts.next()).getName().equals(headerPart)) continue;
            return true;
        }
        return false;
    }

    private Set getDuplicateFaultNames() {
        HashSet<QName> faultNames = new HashSet<QName>();
        HashSet<QName> duplicateNames = new HashSet<QName>();
        Iterator iter = this.info.bindingOperation.faults();
        while (iter.hasNext()) {
            MessagePart faultPart;
            String faultName;
            QName faultQName;
            String faultNamespaceURI;
            BindingFault bindingFault = (BindingFault)iter.next();
            com.sun.xml.rpc.wsdl.document.Fault portTypeFault = null;
            Iterator iter2 = this.info.portTypeOperation.faults();
            while (iter2.hasNext()) {
                com.sun.xml.rpc.wsdl.document.Fault aFault = (com.sun.xml.rpc.wsdl.document.Fault)iter2.next();
                if (!aFault.getName().equals(bindingFault.getName())) continue;
                if (portTypeFault != null) {
                    throw new ModelerException("wsdlmodeler.invalid.bindingFault.notUnique", new Object[]{bindingFault.getName(), this.info.bindingOperation.getName()});
                }
                portTypeFault = aFault;
            }
            if (portTypeFault == null) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.notFound", new Object[]{bindingFault.getName(), this.info.bindingOperation.getName()});
            }
            SOAPFault soapFault = (SOAPFault)WSDLModelerBase.getExtensionOfType(bindingFault, SOAPFault.class);
            if (soapFault == null) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.outputMissingSoapFault", new Object[]{bindingFault.getName(), this.info.bindingOperation.getName()});
            }
            Message faultMessage = portTypeFault.resolveMessage(this.info.document);
            Iterator iter22 = faultMessage.parts();
            if (!iter22.hasNext()) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.emptyMessage", new Object[]{bindingFault.getName(), faultMessage.getName()});
            }
            if (this.useWSIBasicProfile && soapFault.getNamespace() != null) {
                this.warn("wsdlmodeler.warning.r2716r2726", new Object[]{"soapbind:fault", soapFault.getName()});
            }
            if ((faultNamespaceURI = soapFault.getNamespace()) == null) {
                faultNamespaceURI = portTypeFault.getMessage().getNamespaceURI();
            }
            if (faultNames.contains(faultQName = new QName(faultNamespaceURI, faultName = this.getFaultName((faultPart = (MessagePart)iter22.next()).getName(), soapFault.getName(), bindingFault.getName(), faultMessage.getName())))) {
                duplicateNames.add(faultQName);
                continue;
            }
            faultNames.add(faultQName);
        }
        return duplicateNames;
    }

    protected String getFaultName(String faultPartName, String soapFaultName, String bindFaultName, String faultMessageName) {
        return faultMessageName;
    }

    private Parameter getParameter(MessagePart part, LiteralType literalType, Block resBlock) {
        Parameter parameter = new Parameter(this._env.getNames().validJavaMemberName(part.getName()));
        parameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", part.getName());
        parameter.setEmbedded(true);
        parameter.setType(literalType);
        parameter.setBlock(resBlock);
        return parameter;
    }

    private JavaStructureMember getJavaMember(MessagePart part, LiteralType literalType, LiteralElementMember member) {
        JavaStructureMember javaMember = new JavaStructureMember(this._env.getNames().validJavaMemberName(part.getName()), literalType.getJavaType(), member, false);
        javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
        javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
        return javaMember;
    }

    protected void addParameterToStructures(MessagePart part, Parameter parameter, LiteralStructuredType literalType, JavaStructureType javaType) {
        LiteralElementMember member = new LiteralElementMember(new QName(part.getName()), (LiteralType)parameter.getType());
        member.setRequired(true);
        JavaStructureMember javaMember = new JavaStructureMember(this._env.getNames().validJavaMemberName(parameter.getName()), parameter.getType().getJavaType(), member, false);
        javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
        javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
        member.setJavaStructureMember(javaMember);
        literalType.add(member);
        javaType.add(javaMember);
    }

    protected boolean isUnwrappable(Message inputMessage) {
        return this.isUnwrappable();
    }

    protected boolean isUnwrappable() {
        Message inputMessage = this.getInputMessage();
        Message outputMessage = this.getOutputMessage();
        if (!this.strictCompliance) {
            if (!this.useWSIBasicProfile) {
                return true;
            }
            if (!this.unwrap) {
                return false;
            }
        }
        if (inputMessage != null && inputMessage.numParts() != 1 || outputMessage != null && outputMessage.numParts() != 1) {
            return false;
        }
        MessagePart inputPart = inputMessage != null ? (MessagePart)inputMessage.parts().next() : null;
        MessagePart outputPart = outputMessage != null ? (MessagePart)outputMessage.parts().next() : null;
        String operationName = this.info.operation.getName().getLocalPart();
        if (inputPart != null && !inputPart.getDescriptor().getLocalPart().equals(operationName) || outputPart != null && !outputPart.getDescriptor().getLocalPart().startsWith(operationName)) {
            return false;
        }
        LiteralType inputType = null;
        LiteralType outputType = null;
        if (inputPart != null) {
            inputType = this.getElementTypeToLiteralType(inputPart.getDescriptor());
        }
        if (outputPart != null) {
            outputType = this.getElementTypeToLiteralType(outputPart.getDescriptor());
        }
        return this.isWrapperType(inputType) && this.isWrapperType(outputType);
    }

    protected boolean isWrapperType(LiteralType type) {
        return type == null || type instanceof LiteralSequenceType && ((LiteralSequenceType)type).getAttributeMembersCount() <= 0;
    }

    protected boolean typeHasNoWildcardElement(LiteralType type, boolean unwrappable) {
        if (!unwrappable) {
            return unwrappable;
        }
        if (type == null || type != null && !(type instanceof LiteralSequenceType)) {
            return unwrappable;
        }
        LiteralSequenceType sequenceType = (LiteralSequenceType)type;
        Iterator iter2 = sequenceType.getElementMembers();
        while (iter2.hasNext()) {
            LiteralElementMember element = (LiteralElementMember)iter2.next();
            if (!element.isWildcard()) continue;
            return false;
        }
        return unwrappable;
    }

    protected void setUnwrapped(LiteralStructuredType type) {
        if (type instanceof LiteralSequenceType) {
            ((LiteralSequenceType)type).setUnwrapped(true);
        }
    }

    protected Operation processSOAPOperationDocumentLiteralStyle() {
        boolean isRequestResponse = this.info.portTypeOperation.getStyle() == OperationStyle.REQUEST_RESPONSE;
        Request request = new Request();
        Response response = new Response();
        this.info.operation.setUse(SOAPUse.LITERAL);
        SOAPBody soapRequestBody = this.getSOAPRequestBody();
        if (soapRequestBody != null && this.isRequestMimeMultipart()) {
            request.setProperty(MESSAGE_HAS_MIME_MULTIPART_RELATED_BINDING, "true");
        }
        if (this.useWSIBasicProfile && soapRequestBody.getNamespace() != null) {
            this.warn("wsdlmodeler.warning.r2716", new Object[]{"soapbind:body", this.info.bindingOperation.getName()});
        }
        SOAPBody soapResponseBody = null;
        Message outputMessage = null;
        if (isRequestResponse) {
            soapResponseBody = this.getSOAPResponseBody();
            if (this.useWSIBasicProfile && soapResponseBody.getNamespace() != null) {
                this.warn("wsdlmodeler.warning.r2716", new Object[]{"soapbind:body", this.info.bindingOperation.getName()});
            }
            if ((outputMessage = this.getOutputMessage()) != null) {
                response.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", WSDLModelerBase.getQNameOf(outputMessage));
            }
            if (soapResponseBody != null && this.isResponseMimeMultipart()) {
                response.setProperty(MESSAGE_HAS_MIME_MULTIPART_RELATED_BINDING, "true");
            }
        }
        this.setSOAPUse();
        if (!soapRequestBody.isLiteral() || soapResponseBody != null && !soapResponseBody.isLiteral()) {
            this.warn("wsdlmodeler.warning.ignoringOperation.notLiteral", this.info.portTypeOperation.getName());
            return null;
        }
        if (!this.validateMimeParts(this.getMimeParts(this.info.bindingOperation.getInput())) || !this.validateMimeParts(this.getMimeParts(this.info.bindingOperation.getOutput()))) {
            return null;
        }
        if (!this.validateBodyParts(this.info.bindingOperation)) {
            this.warn("wsdlmodeler.warning.ignoringOperation.cannotHandleTypeMessagePart", this.info.portTypeOperation.getName());
            return null;
        }
        Message inputMessage = this.getInputMessage();
        this.setJavaOperationNameProperty(inputMessage);
        if (inputMessage != null) {
            request.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", WSDLModelerBase.getQNameOf(inputMessage));
        }
        HashSet inputParameterNames = new HashSet();
        HashSet outputParameterNames = new HashSet();
        HashSet mimeContentParameterNames = new HashSet();
        String resultParameterName = null;
        StringBuffer result = new StringBuffer();
        List parameterList = this.processParameterOrder(inputParameterNames, outputParameterNames, result);
        if (result.length() > 0) {
            resultParameterName = result.toString();
        }
        boolean unwrappable = this.isUnwrappable(inputMessage);
        if (resultParameterName == null) {
            this.info.operation.setProperty(OPERATION_HAS_VOID_RETURN_TYPE, "true");
        } else {
            MessagePart part = outputMessage.getPart(resultParameterName);
            if (this.isBoundToSOAPBody(part)) {
                LiteralType literalType = part.getDescriptorKind() == SchemaKinds.XSD_TYPE ? this._analyzer.schemaTypeToLiteralType(part.getDescriptor()) : this.getElementTypeToLiteralType(part.getDescriptor());
                literalType = (LiteralType)this.verifyParameterType(literalType, part.getName(), this.info.operation);
                unwrappable = this.typeHasNoWildcardElement(literalType, unwrappable);
                Block block = null;
                block = !this.useWSIBasicProfile && part.getDescriptorKind() == SchemaKinds.XSD_TYPE ? new Block(new QName(resultParameterName), literalType) : new Block(part.getDescriptor(), literalType);
                response.addBodyBlock(block);
                if (literalType instanceof LiteralStructuredType) {
                    int memberCount = ((LiteralStructuredType)literalType).getElementMembersCount() + ((LiteralStructuredType)literalType).getAttributeMembersCount();
                    if (((LiteralStructuredType)literalType).getContentMember() != null) {
                        ++memberCount;
                    }
                    boolean j2eeUnwrap = false;
                    if (this.info.operation.getProperty("J2EE_UNWRAP") != null) {
                        j2eeUnwrap = true;
                    }
                    if (memberCount == 0 && unwrappable && (this.useWSIBasicProfile || this.strictCompliance || j2eeUnwrap)) {
                        this.setUnwrapped((LiteralStructuredType)literalType);
                        this.info.operation.setProperty(OPERATION_HAS_VOID_RETURN_TYPE, "true");
                    } else if (memberCount == 1 && unwrappable) {
                        Parameter parameter;
                        LiteralStructuredType structuredType = (LiteralStructuredType)literalType;
                        this.setUnwrapped(structuredType);
                        JavaStructureType javaStructureType = (JavaStructureType)structuredType.getJavaType();
                        Iterator iter2 = structuredType.getAttributeMembers();
                        if (iter2.hasNext()) {
                            LiteralAttributeMember attribute = (LiteralAttributeMember)iter2.next();
                            parameter = new Parameter(attribute.getJavaStructureMember().getName());
                            parameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", attribute.getName().getLocalPart());
                            parameter.setEmbedded(true);
                            parameter.setType(attribute.getType());
                            parameter.setBlock(block);
                            response.addParameter(parameter);
                            this.info.operation.setProperty(WSDL_RESULT_PARAMETER, parameter.getName());
                        } else {
                            iter2 = structuredType.getElementMembers();
                            LiteralElementMember element = (LiteralElementMember)iter2.next();
                            parameter = new Parameter(element.getJavaStructureMember().getName());
                            parameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", element.getName().getLocalPart());
                            parameter.setEmbedded(true);
                            if (element.isRepeated()) {
                                LiteralArrayType arrayType = new LiteralArrayType();
                                arrayType.setName(new QName("synthetic-array-type"));
                                arrayType.setElementType(element.getType());
                                JavaArrayType javaArrayType = new JavaArrayType(element.getType().getJavaType().getName() + "[]");
                                javaArrayType.setElementType(element.getType().getJavaType());
                                arrayType.setJavaType(javaArrayType);
                                parameter.setType(arrayType);
                            } else {
                                parameter.setType(element.getType());
                            }
                            parameter.setBlock(block);
                            response.addParameter(parameter);
                            this.info.operation.setProperty(WSDL_RESULT_PARAMETER, parameter.getName());
                        }
                    } else {
                        Parameter parameter = new Parameter(this._env.getNames().validJavaMemberName(part.getName()));
                        parameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", part.getName());
                        parameter.setEmbedded(false);
                        parameter.setType(literalType);
                        parameter.setBlock(block);
                        response.addParameter(parameter);
                        this.info.operation.setProperty(WSDL_RESULT_PARAMETER, parameter.getName());
                    }
                } else {
                    Parameter parameter = new Parameter(this._env.getNames().validJavaMemberName(part.getName()));
                    parameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", part.getName());
                    parameter.setEmbedded(false);
                    parameter.setType(literalType);
                    parameter.setBlock(block);
                    response.addParameter(parameter);
                    this.info.operation.setProperty(WSDL_RESULT_PARAMETER, parameter.getName());
                }
            } else if (this.isBoundToMimeContent(part) && part != null) {
                List mimeContents = this.getMimeContents(this.info.bindingOperation.getOutput(), this.getOutputMessage(), resultParameterName);
                LiteralAttachmentType mimeModelType = this.getAttachmentType(mimeContents, part);
                Block block = new Block(new QName(part.getName()), mimeModelType);
                response.addAttachmentBlock(block);
                Parameter outMimeParameter = new Parameter(this.getEnvironment().getNames().validJavaMemberName(part.getName()));
                outMimeParameter.setEmbedded(false);
                outMimeParameter.setType(mimeModelType);
                outMimeParameter.setBlock(block);
                outMimeParameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", part.getName());
                response.addParameter(outMimeParameter);
                this.info.operation.setProperty(WSDL_RESULT_PARAMETER, outMimeParameter.getName());
            }
        }
        ArrayList<String> definitiveParameterList = new ArrayList<String>();
        for (String name : parameterList) {
            Block block;
            LiteralAttachmentType mimeModelType;
            List mimeContents;
            Parameter parameter;
            Block block2;
            LiteralType literalType;
            MessagePart part;
            boolean isInput = inputParameterNames.contains(name);
            boolean isOutput = outputParameterNames.contains(name);
            Parameter inMimeParameter = null;
            Parameter outMimeParameter = null;
            if (isInput && this.isBoundToSOAPBody(inputMessage.getPart(name))) {
                part = inputMessage.getPart(name);
                literalType = part.getDescriptorKind() == SchemaKinds.XSD_TYPE ? this._analyzer.schemaTypeToLiteralType(part.getDescriptor()) : this.getElementTypeToLiteralType(part.getDescriptor());
                literalType = (LiteralType)this.verifyParameterType(literalType, part.getName(), this.info.operation);
                unwrappable = this.typeHasNoWildcardElement(literalType, unwrappable);
                block2 = null;
                block2 = !this.useWSIBasicProfile && part.getDescriptorKind() == SchemaKinds.XSD_TYPE ? new Block(new QName(name), literalType) : new Block(part.getDescriptor(), literalType);
                request.addBodyBlock(block2);
                if (literalType instanceof LiteralSequenceType && unwrappable) {
                    Parameter parameter2;
                    LiteralSequenceType sequenceType = (LiteralSequenceType)literalType;
                    this.setUnwrapped(sequenceType);
                    Iterator iter2 = sequenceType.getAttributeMembers();
                    while (iter2.hasNext()) {
                        LiteralAttributeMember attribute = (LiteralAttributeMember)iter2.next();
                        parameter2 = new Parameter(attribute.getJavaStructureMember().getName());
                        parameter2.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", attribute.getName().getLocalPart());
                        parameter2.setEmbedded(true);
                        parameter2.setType(attribute.getType());
                        parameter2.setBlock(block2);
                        request.addParameter(parameter2);
                        definitiveParameterList.add(parameter2.getName());
                    }
                    if (sequenceType.getContentMember() != null) {
                        LiteralContentMember content = sequenceType.getContentMember();
                        Parameter parameter3 = new Parameter(content.getJavaStructureMember().getName());
                        parameter3.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", parameter3.getName());
                        parameter3.setEmbedded(true);
                        parameter3.setType(content.getType());
                        parameter3.setBlock(block2);
                        request.addParameter(parameter3);
                        definitiveParameterList.add(parameter3.getName());
                    }
                    iter2 = sequenceType.getElementMembers();
                    while (iter2.hasNext()) {
                        LiteralElementMember element = (LiteralElementMember)iter2.next();
                        parameter2 = new Parameter(element.getJavaStructureMember().getName());
                        parameter2.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", element.getName().getLocalPart());
                        parameter2.setEmbedded(true);
                        if (element.isRepeated()) {
                            LiteralArrayType arrayType = new LiteralArrayType();
                            arrayType.setName(new QName("synthetic-array-type"));
                            arrayType.setElementType(element.getType());
                            JavaArrayType javaArrayType = new JavaArrayType(element.getType().getJavaType().getName() + "[]");
                            javaArrayType.setElementType(element.getType().getJavaType());
                            arrayType.setJavaType(javaArrayType);
                            parameter2.setType(arrayType);
                        } else {
                            parameter2.setType(element.getType());
                        }
                        parameter2.setBlock(block2);
                        request.addParameter(parameter2);
                        definitiveParameterList.add(parameter2.getName());
                    }
                } else {
                    parameter = new Parameter(this._env.getNames().validJavaMemberName(part.getName()));
                    parameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", part.getName());
                    parameter.setEmbedded(false);
                    parameter.setType(literalType);
                    parameter.setBlock(block2);
                    request.addParameter(parameter);
                    definitiveParameterList.add(parameter.getName());
                }
            } else if (isInput && this.isBoundToMimeContent(inputMessage.getPart(name))) {
                part = inputMessage.getPart(name);
                mimeContents = this.getMimeContents(this.info.bindingOperation.getInput(), this.getInputMessage(), name);
                mimeModelType = this.getAttachmentType(mimeContents, part);
                block = new Block(new QName(part.getName()), mimeModelType);
                request.addAttachmentBlock(block);
                inMimeParameter = new Parameter(this.getEnvironment().getNames().validJavaMemberName(part.getName()));
                inMimeParameter.setEmbedded(false);
                inMimeParameter.setType(mimeModelType);
                inMimeParameter.setBlock(block);
                inMimeParameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", part.getName());
                request.addParameter(inMimeParameter);
                definitiveParameterList.add(inMimeParameter.getName());
            }
            if (isOutput && this.isBoundToSOAPBody(outputMessage.getPart(name))) {
                part = outputMessage.getPart(name);
                literalType = part.getDescriptorKind() == SchemaKinds.XSD_TYPE ? this._analyzer.schemaTypeToLiteralType(part.getDescriptor()) : this.getElementTypeToLiteralType(part.getDescriptor());
                literalType = (LiteralType)this.verifyParameterType(literalType, part.getName(), this.info.operation);
                block2 = null;
                block2 = !this.useWSIBasicProfile && part.getDescriptorKind() == SchemaKinds.XSD_TYPE ? new Block(new QName(name), literalType) : new Block(part.getDescriptor(), literalType);
                response.addBodyBlock(block2);
                if (literalType instanceof LiteralStructuredType) {
                    int memberCount = ((LiteralStructuredType)literalType).getElementMembersCount() + ((LiteralStructuredType)literalType).getAttributeMembersCount();
                    if (((LiteralStructuredType)literalType).getContentMember() != null) {
                        ++memberCount;
                    }
                    if (memberCount == 0 && unwrappable && (this.useWSIBasicProfile || this.strictCompliance)) {
                        this.setUnwrapped((LiteralStructuredType)literalType);
                        continue;
                    }
                    if (memberCount == 1 && unwrappable) {
                        Parameter parameter4;
                        LiteralStructuredType structuredType = (LiteralStructuredType)literalType;
                        this.setUnwrapped(structuredType);
                        JavaStructureType javaStructureType = (JavaStructureType)structuredType.getJavaType();
                        Iterator iter2 = structuredType.getAttributeMembers();
                        if (iter2.hasNext()) {
                            LiteralAttributeMember attribute = (LiteralAttributeMember)iter2.next();
                            parameter4 = new Parameter(attribute.getJavaStructureMember().getName());
                            parameter4.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", attribute.getName().getLocalPart());
                            parameter4.setEmbedded(true);
                            parameter4.setType(attribute.getType());
                            parameter4.setBlock(block2);
                            response.addParameter(parameter4);
                            definitiveParameterList.add(parameter4.getName());
                            continue;
                        }
                        iter2 = structuredType.getElementMembers();
                        LiteralElementMember element = (LiteralElementMember)iter2.next();
                        parameter4 = new Parameter(element.getJavaStructureMember().getName());
                        parameter4.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", element.getName().getLocalPart());
                        parameter4.setEmbedded(true);
                        if (element.isRepeated()) {
                            LiteralArrayType arrayType = new LiteralArrayType();
                            arrayType.setName(new QName("synthetic-array-type"));
                            arrayType.setElementType(element.getType());
                            JavaArrayType javaArrayType = new JavaArrayType(element.getType().getJavaType().getName() + "[]");
                            javaArrayType.setElementType(element.getType().getJavaType());
                            arrayType.setJavaType(javaArrayType);
                            parameter4.setType(arrayType);
                        } else {
                            parameter4.setType(element.getType());
                        }
                        parameter4.setBlock(block2);
                        response.addParameter(parameter4);
                        definitiveParameterList.add(parameter4.getName());
                        continue;
                    }
                    Parameter parameter5 = new Parameter(this._env.getNames().validJavaMemberName(part.getName()));
                    parameter5.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", part.getName());
                    parameter5.setEmbedded(false);
                    parameter5.setType(literalType);
                    parameter5.setBlock(block2);
                    response.addParameter(parameter5);
                    definitiveParameterList.add(parameter5.getName());
                    continue;
                }
                parameter = new Parameter(this._env.getNames().validJavaMemberName(part.getName()));
                parameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", part.getName());
                parameter.setEmbedded(false);
                parameter.setType(literalType);
                parameter.setBlock(block2);
                response.addParameter(parameter);
                definitiveParameterList.add(parameter.getName());
                continue;
            }
            if (!isOutput || !this.isBoundToMimeContent(outputMessage.getPart(name)) || (part = outputMessage.getPart(name)) == null) continue;
            mimeContents = this.getMimeContents(this.info.bindingOperation.getOutput(), this.getOutputMessage(), name);
            mimeModelType = this.getAttachmentType(mimeContents, part);
            block = new Block(new QName(part.getName()), mimeModelType);
            response.addAttachmentBlock(block);
            outMimeParameter = new Parameter(this.getEnvironment().getNames().validJavaMemberName(part.getName()));
            outMimeParameter.setEmbedded(false);
            outMimeParameter.setType(mimeModelType);
            outMimeParameter.setBlock(block);
            outMimeParameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", part.getName());
            response.addParameter(outMimeParameter);
            if (inMimeParameter == null) {
                definitiveParameterList.add(outMimeParameter.getName());
                continue;
            }
            List inMimeTypes = ((LiteralAttachmentType)inMimeParameter.getType()).getAlternateMIMETypes();
            List outMimeTypes = ((LiteralAttachmentType)outMimeParameter.getType()).getAlternateMIMETypes();
            boolean sameMimeTypes = true;
            if (inMimeTypes.size() == outMimeTypes.size()) {
                Iterator inTypesIter = inMimeTypes.iterator();
                Iterator outTypesIter = outMimeTypes.iterator();
                while (inTypesIter.hasNext()) {
                    String outTypeName;
                    String inTypeName = (String)inTypesIter.next();
                    if (inTypeName.equals(outTypeName = (String)outTypesIter.next())) continue;
                    sameMimeTypes = false;
                    break;
                }
            }
            if (!inMimeParameter.getType().getName().equals(outMimeParameter.getType().getName()) || !sameMimeTypes) continue;
            outMimeParameter.setLinkedParameter(inMimeParameter);
            inMimeParameter.setLinkedParameter(outMimeParameter);
        }
        this.info.operation.setRequest(request);
        if (isRequestResponse) {
            this.info.operation.setResponse(response);
        }
        Set duplicateNames = this.getDuplicateFaultNames();
        this.handleLiteralSOAPFault(response, duplicateNames);
        boolean explicitServiceContext = this.useExplicitServiceContextForDocLit(inputMessage);
        if (explicitServiceContext) {
            this.handleLiteralSOAPHeaders(request, response, this.getHeaderExtensions(this.info.bindingOperation.getInput()), duplicateNames, definitiveParameterList, true);
            if (isRequestResponse) {
                this.handleLiteralSOAPHeaders(request, response, this.getHeaderExtensions(this.info.bindingOperation.getOutput()), duplicateNames, definitiveParameterList, false);
            }
        }
        this.info.operation.setProperty(WSDL_PARAMETER_ORDER, definitiveParameterList);
        return this.info.operation;
    }

    private boolean validateBodyParts(BindingOperation operation) {
        List outputParts;
        boolean isRequestResponse = this.info.portTypeOperation.getStyle() == OperationStyle.REQUEST_RESPONSE;
        List inputParts = this.getMessageParts(this.getSOAPRequestBody(), this.getInputMessage(), true);
        if (!this.validateStyleAndPart(operation, inputParts)) {
            return false;
        }
        return !isRequestResponse || this.validateStyleAndPart(operation, outputParts = this.getMessageParts(this.getSOAPResponseBody(), this.getOutputMessage(), false));
    }

    private boolean validateStyleAndPart(BindingOperation operation, List parts) {
        SOAPOperation soapOperation = (SOAPOperation)WSDLModelerBase.getExtensionOfType(operation, SOAPOperation.class);
        for (MessagePart part : parts) {
            if (part.getBindingExtensibilityElementKind() != 1 || this.isStyleAndPartMatch(soapOperation, part)) continue;
            return false;
        }
        return true;
    }

    protected void processHeaderFaults(SOAPHeader header, ProcessSOAPOperationInfo info, Response response, Set duplicateNames) {
        Iterator faults = header.faults();
        while (faults.hasNext()) {
            AbstractType faultType;
            Extension extn = (Extension)faults.next();
            if (!(extn instanceof SOAPHeaderFault)) {
                return;
            }
            SOAPHeaderFault headerFault = (SOAPHeaderFault)extn;
            if (null == headerFault.getMessage()) {
                return;
            }
            if (this.useWSIBasicProfile && headerFault.getNamespace() != null) {
                this.warn("wsdlmodeler.warning.r2716r2726", new Object[]{"soapbind:headerfault", info.bindingOperation.getName()});
            }
            String faultNamespaceURI = headerFault.getNamespace();
            Message faultMessage = WSDLModelerBase.findMessage(headerFault.getMessage(), info);
            if (faultMessage == null) {
                this.warn("wsdlmodeler.warning.ignoringFault.cant.resolve.message", new Object[]{header.getMessage(), info.bindingOperation.getName()});
                continue;
            }
            MessagePart faultPart = faultMessage.getPart(headerFault.getPart());
            if (faultPart == null) {
                this.warn("wsdlmodeler.warning.ignoringHeaderFault.notFound", new Object[]{header.getMessage(), headerFault.getPart(), info.bindingOperation.getName()});
                continue;
            }
            QName faultQName = new QName(faultNamespaceURI, faultPart.getName());
            if (duplicateNames.contains(faultQName)) {
                this.warn("wsdlmodeler.duplicate.fault.part.name", new Object[]{headerFault.getMessage(), info.portTypeOperation.getName(), faultPart.getName()});
                continue;
            }
            if (faultPart.getDescriptorKind() != SchemaKinds.XSD_TYPE && headerFault.getUse() == SOAPUse.ENCODED) {
                this.warn("wsdlmodeler.invalid.message.partMustHaveTypeDescriptor", new Object[]{faultMessage.getName(), faultPart.getName()});
                this.warn("wsdlmodeler.warning.ignoringHeaderFault", new Object[]{headerFault.getPart(), info.bindingOperation.getName()});
                continue;
            }
            if (faultPart.getDescriptorKind() != SchemaKinds.XSD_ELEMENT && headerFault.getUse() == SOAPUse.LITERAL) {
                this.warn("wsdlmodeler.invalid.message.partMustHaveElementDescriptor", new Object[]{faultMessage.getName(), faultPart.getName()});
                this.warn("wsdlmodeler.warning.ignoringHeaderFault", new Object[]{headerFault.getPart(), info.bindingOperation.getName()});
                continue;
            }
            if (headerFault.getUse() == SOAPUse.LITERAL) {
                faultType = faultPart.getDescriptorKind() == SchemaKinds.XSD_TYPE ? this._analyzer.schemaTypeToLiteralType(faultPart.getDescriptor()) : this.getElementTypeToLiteralType(faultPart.getDescriptor());
            } else {
                this.warn("wsdlmodeler.warning.ignoringHeader.notLiteral", new Object[]{header.getPart(), info.bindingOperation.getName()});
                continue;
            }
            HeaderFault fault = new HeaderFault(faultPart.getDescriptor().toString());
            fault.setElementName(faultPart.getDescriptor());
            fault.setMessage(headerFault.getMessage());
            fault.setPart(headerFault.getPart());
            faultType = this.getHeaderFaultSequenceType(faultType, faultPart, faultPart.getDescriptor());
            Block faultBlock = new Block(faultPart.getDescriptor(), faultType);
            fault.setBlock(faultBlock);
            this.createParentFault(fault);
            this.createSubfaults(fault);
            response.addFaultBlock(faultBlock);
            info.operation.addFault(fault);
        }
    }

    protected AbstractType getHeaderFaultSequenceType(AbstractType faultType, MessagePart faultPart, QName elemName) {
        if (faultType instanceof LiteralSimpleType) {
            LiteralSimpleType faultSimpleType = new LiteralSimpleType(faultType.getName(), (JavaSimpleType)faultType.getJavaType());
            LiteralSequenceType structureType = new LiteralSequenceType(faultPart.getDescriptor());
            JavaStructureType javaStructureType = new JavaStructureType(this.makePackageQualified(this._env.getNames().validJavaClassName(structureType.getName().getLocalPart()), structureType.getName()), false, structureType);
            structureType.setJavaType(javaStructureType);
            LiteralElementMember member = new LiteralElementMember(elemName, faultSimpleType);
            JavaStructureMember javaMember = new JavaStructureMember(faultPart.getName(), faultSimpleType.getJavaType(), member, false);
            javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
            javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
            member.setJavaStructureMember(javaMember);
            javaStructureType.add(javaMember);
            structureType.add(member);
            return structureType;
        }
        return faultType;
    }

    protected String getJavaNameOfSEI(Port port) {
        QName portTypeName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortTypeName");
        QName bindingName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLBindingName");
        String interfaceName = null;
        interfaceName = portTypeName != null ? this.makePackageQualified(this._env.getNames().validJavaClassName(this.getNonQualifiedNameFor(portTypeName)), portTypeName, false) : this.makePackageQualified(this._env.getNames().validJavaClassName(this.getNonQualifiedNameFor(port.getName())), port.getName(), false);
        return interfaceName;
    }

    protected void createJavaInterfaceForPort(Port port) {
        String interfaceName = this.getJavaNameOfSEI(port);
        if (this.isConflictingPortClassName(interfaceName)) {
            interfaceName = interfaceName + "_PortType";
        }
        JavaInterface intf = new JavaInterface(interfaceName);
        HashSet methodNames = new HashSet();
        HashSet methodSignatures = new HashSet();
        Iterator iter = port.getOperations();
        while (iter.hasNext()) {
            Operation operation = (Operation)iter.next();
            this.createJavaMethodForOperation(port, operation, intf, methodNames, methodSignatures);
        }
        port.setJavaInterface(intf);
    }

    protected String getJavaNameForOperation(Operation operation) {
        return this._env.getNames().validJavaMemberName(operation.getName().getLocalPart());
    }

    private void createJavaMethodForOperation(Port port, Operation operation, JavaInterface intf, Set methodNames, Set methodSignatures) {
        Fault fault;
        JavaType returnType;
        boolean operationHasVoidReturnType;
        String candidateName = this.getJavaNameForOperation(operation);
        JavaMethod method = new JavaMethod(candidateName);
        Request request = operation.getRequest();
        Iterator requestBodyBlocks = request.getBodyBlocks();
        Block requestBlock = requestBodyBlocks.hasNext() ? (Block)request.getBodyBlocks().next() : null;
        Response response = operation.getResponse();
        Iterator responseBodyBlocks = null;
        Block responseBlock = null;
        if (response != null) {
            responseBodyBlocks = response.getBodyBlocks();
            responseBlock = responseBodyBlocks.hasNext() ? (Block)response.getBodyBlocks().next() : null;
        }
        String signature = candidateName;
        List parameterOrder = (List)operation.getProperty(WSDL_PARAMETER_ORDER);
        if (parameterOrder == null) {
            Iterator iter = request.getParameters();
            while (iter.hasNext()) {
                Parameter parameter = (Parameter)iter.next();
                if (parameter.getJavaParameter() != null) {
                    throw new ModelerException("wsdlmodeler.invalidOperation", operation.getName().getLocalPart());
                }
                JavaType parameterType = parameter.getType().getJavaType();
                JavaParameter javaParameter = new JavaParameter(this._env.getNames().validJavaMemberName(parameter.getName()), parameterType, parameter, parameter.getLinkedParameter() != null);
                method.addParameter(javaParameter);
                parameter.setJavaParameter(javaParameter);
                signature = signature + "%" + parameterType.getName();
            }
            boolean bl = operationHasVoidReturnType = operation.getProperty(OPERATION_HAS_VOID_RETURN_TYPE) != null;
            if (response != null) {
                Parameter resultParameter = null;
                Iterator iter2 = response.getParameters();
                while (iter2.hasNext()) {
                    if (!operationHasVoidReturnType && resultParameter == null) {
                        resultParameter = (Parameter)iter2.next();
                        if (resultParameter.getJavaParameter() != null) {
                            throw new ModelerException("wsdlmodeler.invalidOperation", operation.getName().getLocalPart());
                        }
                        if (resultParameter.getLinkedParameter() != null) {
                            throw new ModelerException("wsdlmodeler.resultIsInOutParameter", operation.getName().getLocalPart());
                        }
                        if (resultParameter.getBlock() != responseBlock) {
                            throw new ModelerException("wsdlmodeler.invalidOperation", operation.getName().getLocalPart());
                        }
                        returnType = resultParameter.getType().getJavaType();
                        method.setReturnType(returnType);
                        continue;
                    }
                    Parameter parameter = (Parameter)iter2.next();
                    if (parameter.getJavaParameter() != null) {
                        throw new ModelerException("wsdlmodeler.invalidOperation", operation.getName().getLocalPart());
                    }
                    JavaParameter javaParameter = null;
                    if (parameter.getLinkedParameter() != null) {
                        javaParameter = parameter.getLinkedParameter().getJavaParameter();
                    }
                    JavaType parameterType = parameter.getType().getJavaType();
                    parameterType.setHolder(true);
                    parameterType.setHolderPresent(false);
                    if (javaParameter == null) {
                        javaParameter = new JavaParameter(this._env.getNames().validJavaMemberName(parameter.getName()), parameterType, parameter, true);
                    }
                    parameter.setJavaParameter(javaParameter);
                    if (parameter.getLinkedParameter() != null) continue;
                    method.addParameter(javaParameter);
                }
            }
            if (response == null || operationHasVoidReturnType) {
                method.setReturnType(this._javaTypes.VOID_JAVATYPE);
            }
        } else {
            operationHasVoidReturnType = operation.getProperty(OPERATION_HAS_VOID_RETURN_TYPE) != null;
            for (String parameterName : parameterOrder) {
                JavaParameter javaParameter;
                JavaType parameterType;
                Parameter linkedParameter;
                Parameter responseParameter;
                Parameter requestParameter = request.getParameterByName(parameterName);
                Parameter parameter = responseParameter = response != null ? response.getParameterByName(parameterName) : null;
                if (requestParameter == null && responseParameter == null) {
                    throw new ModelerException("wsdlmodeler.invalidState.modelingOperation", operation.getName().getLocalPart());
                }
                if (requestParameter != null) {
                    linkedParameter = requestParameter.getLinkedParameter();
                    if (responseParameter == null || linkedParameter == null) {
                        parameterType = requestParameter.getType().getJavaType();
                        javaParameter = new JavaParameter(this._env.getNames().validJavaMemberName(requestParameter.getName()), parameterType, requestParameter, false);
                        method.addParameter(javaParameter);
                        requestParameter.setJavaParameter(javaParameter);
                        signature = signature + "%" + parameterType.getName();
                        continue;
                    }
                    if (responseParameter != linkedParameter) {
                        throw new ModelerException("wsdlmodeler.invalidState.modelingOperation", operation.getName().getLocalPart());
                    }
                    parameterType = responseParameter.getType().getJavaType();
                    javaParameter = new JavaParameter(this._env.getNames().validJavaMemberName(responseParameter.getName()), parameterType, responseParameter, true);
                    parameterType.setHolder(true);
                    parameterType.setHolderPresent(false);
                    requestParameter.setJavaParameter(javaParameter);
                    responseParameter.setJavaParameter(javaParameter);
                    method.addParameter(javaParameter);
                    requestParameter.setJavaParameter(javaParameter);
                    responseParameter.setJavaParameter(javaParameter);
                    signature = signature + "%" + parameterType.getName();
                    continue;
                }
                if (responseParameter == null) continue;
                linkedParameter = responseParameter.getLinkedParameter();
                if (linkedParameter != null) {
                    throw new ModelerException("wsdlmodeler.invalidState.modelingOperation", operation.getName().getLocalPart());
                }
                parameterType = responseParameter.getType().getJavaType();
                parameterType.setHolder(true);
                parameterType.setHolderPresent(false);
                javaParameter = new JavaParameter(this._env.getNames().validJavaMemberName(responseParameter.getName()), parameterType, responseParameter, true);
                responseParameter.setJavaParameter(javaParameter);
                method.addParameter(javaParameter);
                signature = signature + "%" + parameterType.getName();
            }
            String resultParameterName = (String)operation.getProperty(WSDL_RESULT_PARAMETER);
            if (resultParameterName == null) {
                if (!operationHasVoidReturnType) {
                    throw new ModelerException("wsdlmodeler.invalidState.modelingOperation", operation.getName().getLocalPart());
                }
                method.setReturnType(this._javaTypes.VOID_JAVATYPE);
            } else {
                if (operationHasVoidReturnType) {
                    throw new ModelerException("wsdlmodeler.invalidState.modelingOperation", operation.getName().getLocalPart());
                }
                Parameter resultParameter = response.getParameterByName(resultParameterName);
                returnType = resultParameter.getType().getJavaType();
                method.setReturnType(returnType);
            }
        }
        String operationName = candidateName;
        if (methodSignatures.contains(signature)) {
            operationName = this.makeNameUniqueInSet(candidateName, methodNames);
            method.setName(operationName);
        }
        methodSignatures.add(signature);
        methodNames.add(method.getName());
        operation.setJavaMethod(method);
        intf.addMethod(method);
        Iterator iter = operation.getFaults();
        while (iter != null && iter.hasNext()) {
            fault = (Fault)iter.next();
            this.createJavaException(fault, port, operationName);
        }
        Iterator iter3 = operation.getFaults();
        while (iter3.hasNext()) {
            fault = (Fault)iter3.next();
            JavaException javaException = fault.getJavaException();
            method.addException(javaException.getName());
        }
    }

    protected boolean createJavaException(Fault fault, Port port, String operationName) {
        if (fault.getBlock().getType().isSOAPType()) {
            return this.createJavaExceptionFromSOAPType(fault, port, operationName);
        }
        return this.createJavaExceptionFromLiteralType(fault, port, operationName);
    }

    protected WSDLExceptionInfo getExceptionInfo(Fault fault) {
        return null;
    }

    protected boolean createJavaExceptionFromSOAPType(Fault fault, Port port, String operationName) {
        JavaException existingJavaException;
        SOAPStructureType soapStruct;
        String exceptionName = null;
        String propertyName = this._env.getNames().validJavaMemberName(fault.getName());
        SOAPType faultType = (SOAPType)fault.getBlock().getType();
        WSDLExceptionInfo exInfo = this.getExceptionInfo(fault);
        if (faultType instanceof SOAPStructureType) {
            exceptionName = exInfo != null ? exInfo.exceptionType : this.makePackageQualified(this._env.getNames().validJavaClassName(faultType.getName().getLocalPart()), faultType.getName());
            soapStruct = (SOAPStructureType)this._faultTypeToStructureMap.get(faultType.getName());
            if (soapStruct == null) {
                soapStruct = new SOAPOrderedStructureType(faultType.getName());
                SOAPStructureType temp = (SOAPStructureType)faultType;
                Iterator members = temp.getMembers();
                while (members.hasNext()) {
                    soapStruct.add((SOAPStructureMember)members.next());
                }
                this._faultTypeToStructureMap.put(faultType.getName(), soapStruct);
            }
        } else {
            exceptionName = exInfo != null ? exInfo.exceptionType : this.makePackageQualified(this._env.getNames().validJavaClassName(fault.getName()), port.getName());
            soapStruct = new SOAPOrderedStructureType(new QName(fault.getBlock().getName().getNamespaceURI(), fault.getName()));
            QName memberName = fault.getElementName();
            SOAPStructureMember soapMember = new SOAPStructureMember(memberName, faultType);
            String javaMemberName = fault.getJavaMemberName();
            if (javaMemberName == null) {
                javaMemberName = memberName.getLocalPart();
            }
            JavaStructureMember javaMember = new JavaStructureMember(javaMemberName, faultType.getJavaType(), soapMember);
            soapMember.setJavaStructureMember(javaMember);
            javaMember.setConstructorPos(0);
            javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
            javaMember.setInherited(soapMember.isInherited());
            soapMember.setJavaStructureMember(javaMember);
            soapStruct.add(soapMember);
        }
        if (this.isConflictingExceptionClassName(exceptionName)) {
            exceptionName = exceptionName + "_Exception";
        }
        if ((existingJavaException = (JavaException)this._javaExceptions.get(exceptionName)) != null && existingJavaException.getName().equals(exceptionName) && (((SOAPType)existingJavaException.getOwner()).getName().equals(soapStruct.getName()) || this.isEquivalentSOAPStructures(soapStruct, (SOAPStructureType)existingJavaException.getOwner()))) {
            if (faultType instanceof SOAPStructureType) {
                fault.getBlock().setType((SOAPType)existingJavaException.getOwner());
            }
            fault.setJavaException(existingJavaException);
            this.createRelativeJavaExceptions(fault, port, operationName);
            return false;
        }
        JavaException javaException = new JavaException(exceptionName, false, soapStruct);
        soapStruct.setJavaType(javaException);
        this._javaExceptions.put(javaException.getName(), javaException);
        Iterator members = soapStruct.getMembers();
        SOAPStructureMember member = null;
        int i = 0;
        while (members.hasNext()) {
            member = (SOAPStructureMember)members.next();
            JavaStructureMember javaMember = member.getJavaStructureMember();
            if (faultType instanceof SOAPStructureType && exInfo != null) {
                String memberName = member.getName().getLocalPart();
                Integer pos = (Integer)exInfo.constructorOrder.get(memberName);
                if (pos == null) {
                    throw new ModelerException("unable to find member " + memberName + " in jaxrpcmapping meta for exception whose wsdl message is: " + fault.getBlock().getName());
                }
                javaMember.setConstructorPos(pos);
            } else {
                javaMember.setConstructorPos(i);
            }
            javaException.add(javaMember);
            ++i;
        }
        if (faultType instanceof SOAPStructureType) {
            fault.getBlock().setType(soapStruct);
        }
        fault.setJavaException(javaException);
        this.createRelativeJavaExceptions(fault, port, operationName);
        return true;
    }

    protected String getLiteralJavaMemberName(Fault fault) {
        QName memberName = fault.getElementName();
        String javaMemberName = fault.getJavaMemberName();
        if (javaMemberName == null) {
            javaMemberName = memberName.getLocalPart();
        }
        return javaMemberName;
    }

    public boolean isEquivalentSOAPStructures(SOAPStructureType struct1, SOAPStructureType struct2) {
        if (struct1.getMembersCount() != struct2.getMembersCount()) {
            return false;
        }
        Iterator members = struct1.getMembers();
        int i = 0;
        while (members.hasNext()) {
            SOAPStructureMember member1 = (SOAPStructureMember)members.next();
            JavaStructureMember javaMember1 = member1.getJavaStructureMember();
            JavaStructureMember javaMember2 = ((JavaStructureType)struct2.getJavaType()).getMemberByName(member1.getJavaStructureMember().getName());
            if (javaMember2.getConstructorPos() != i || !javaMember1.getType().equals(javaMember2.getType())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEquivalentLiteralStructures(LiteralStructuredType struct1, LiteralStructuredType struct2) {
        JavaStructureMember javaMember2;
        JavaStructureMember javaMember1;
        if (struct1.getElementMembersCount() != struct2.getElementMembersCount() || struct1.getAttributeMembersCount() != struct2.getAttributeMembersCount()) {
            return false;
        }
        Iterator members = struct1.getElementMembers();
        int i = 0;
        while (members.hasNext()) {
            LiteralElementMember member1 = (LiteralElementMember)members.next();
            javaMember1 = member1.getJavaStructureMember();
            javaMember2 = ((JavaStructureType)struct2.getJavaType()).getMemberByName(member1.getJavaStructureMember().getName());
            if (javaMember2.getConstructorPos() != i || !javaMember1.getType().equals(javaMember2.getType())) {
                return false;
            }
            ++i;
        }
        members = struct1.getAttributeMembers();
        int i2 = 0;
        while (members.hasNext()) {
            LiteralAttributeMember member = (LiteralAttributeMember)members.next();
            javaMember1 = member.getJavaStructureMember();
            javaMember2 = ((JavaStructureType)struct2.getJavaType()).getMemberByName(member.getJavaStructureMember().getName());
            if (javaMember2.getConstructorPos() != i2 || !javaMember1.getType().equals(javaMember2.getType())) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    protected boolean createJavaExceptionFromLiteralType(Fault fault, Port port, String operationName) {
        JavaException existingJavaException;
        JavaStructureMember javaMember;
        LiteralStructuredType literalStruct;
        WSDLExceptionInfo exInfo = this.getExceptionInfo(fault);
        String exceptionName = null;
        String propertyName = this._env.getNames().validJavaMemberName(fault.getName());
        LiteralType faultType = (LiteralType)fault.getBlock().getType();
        if (faultType instanceof LiteralStructuredType) {
            exceptionName = exInfo != null ? exInfo.exceptionType : this.makePackageQualified(this._env.getNames().validJavaClassName(faultType.getName().getLocalPart()), faultType.getName());
            literalStruct = (LiteralStructuredType)this._faultTypeToStructureMap.get(faultType.getName());
            if (literalStruct == null) {
                literalStruct = new LiteralSequenceType(faultType.getName());
                LiteralStructuredType temp = (LiteralStructuredType)faultType;
                Iterator members = temp.getElementMembers();
                while (members.hasNext()) {
                    literalStruct.add((LiteralElementMember)members.next());
                }
                Iterator iter2 = temp.getAttributeMembers();
                while (iter2.hasNext()) {
                    LiteralAttributeMember attribute = (LiteralAttributeMember)iter2.next();
                    literalStruct.add(attribute);
                }
                this._faultTypeToStructureMap.put(faultType.getName(), literalStruct);
            }
        } else {
            exceptionName = exInfo != null ? exInfo.exceptionType : this.makePackageQualified(this._env.getNames().validJavaClassName(fault.getName()), port.getName());
            literalStruct = new LiteralSequenceType(new QName(fault.getBlock().getName().getNamespaceURI(), fault.getName()));
            QName memberName = fault.getElementName();
            LiteralElementMember literalMember = new LiteralElementMember(memberName, faultType);
            literalMember.setNillable(faultType.isNillable());
            String javaMemberName = this.getLiteralJavaMemberName(fault);
            javaMember = new JavaStructureMember(javaMemberName, faultType.getJavaType(), literalMember);
            literalMember.setJavaStructureMember(javaMember);
            javaMember.setConstructorPos(0);
            javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
            javaMember.setInherited(false);
            literalMember.setJavaStructureMember(javaMember);
            literalStruct.add(literalMember);
        }
        if (this.isConflictingExceptionClassName(exceptionName)) {
            exceptionName = exceptionName + "_Exception";
        }
        if ((existingJavaException = (JavaException)this._javaExceptions.get(exceptionName)) != null && existingJavaException.getName().equals(exceptionName) && (((LiteralType)existingJavaException.getOwner()).getName().equals(literalStruct.getName()) || this.isEquivalentLiteralStructures(literalStruct, (LiteralStructuredType)existingJavaException.getOwner()))) {
            if (faultType instanceof LiteralStructuredType) {
                fault.getBlock().setType((LiteralType)existingJavaException.getOwner());
            }
            fault.setJavaException(existingJavaException);
            this.createRelativeJavaExceptions(fault, port, operationName);
            return false;
        }
        JavaException javaException = new JavaException(exceptionName, false, literalStruct);
        literalStruct.setJavaType(javaException);
        this._javaExceptions.put(javaException.getName(), javaException);
        int constPos = 0;
        Iterator iter2 = literalStruct.getAttributeMembers();
        while (iter2.hasNext()) {
            LiteralAttributeMember attribute = (LiteralAttributeMember)iter2.next();
            javaMember = attribute.getJavaStructureMember();
            javaMember.setConstructorPos(constPos++);
            javaException.add(javaMember);
        }
        Iterator members = literalStruct.getElementMembers();
        LiteralElementMember member = null;
        int i = constPos;
        while (members.hasNext()) {
            member = (LiteralElementMember)members.next();
            javaMember = member.getJavaStructureMember();
            if (faultType instanceof LiteralStructuredType && exInfo != null) {
                String memberName = null;
                memberName = member instanceof LiteralWildcardMember ? javaMember.getName() : member.getName().getLocalPart();
                Integer pos = (Integer)exInfo.constructorOrder.get(memberName);
                if (pos == null) {
                    throw new ModelerException("unable to find member " + memberName + " in jaxrpcmapping meta for exception whose wsdl message is: " + fault.getBlock().getName());
                }
                javaMember.setConstructorPos(pos);
            } else {
                javaMember.setConstructorPos(i);
            }
            javaException.add(javaMember);
            ++i;
        }
        if (faultType instanceof LiteralStructuredType) {
            fault.getBlock().setType(literalStruct);
        }
        fault.setJavaException(javaException);
        this.createRelativeJavaExceptions(fault, port, operationName);
        return true;
    }

    protected void createRelativeJavaExceptions(Fault fault, Port port, String operationName) {
        Iterator subfaults;
        if (fault.getParentFault() != null && fault.getParentFault().getJavaException() == null) {
            this.createJavaException(fault.getParentFault(), port, operationName);
            fault.getParentFault().getJavaException().addSubclass(fault.getJavaException());
            if (fault.getParentFault().getJavaException().getOwner() instanceof SOAPStructureType) {
                ((SOAPStructureType)fault.getParentFault().getJavaException().getOwner()).addSubtype((SOAPStructureType)fault.getJavaException().getOwner());
            } else if (fault.getParentFault().getJavaException().getOwner() instanceof LiteralStructuredType) {
                ((LiteralStructuredType)fault.getParentFault().getJavaException().getOwner()).addSubtype((LiteralStructuredType)fault.getJavaException().getOwner());
            }
        }
        if ((subfaults = fault.getSubfaults()) != null) {
            while (subfaults.hasNext()) {
                Fault subfault = (Fault)subfaults.next();
                if (subfault.getJavaException() != null) continue;
                boolean didCreateNewException = this.createJavaException(subfault, port, operationName);
                fault.getJavaException().addSubclass(subfault.getJavaException());
                if (fault.getJavaException().getOwner() instanceof SOAPStructureType) {
                    ((SOAPStructureType)fault.getJavaException().getOwner()).addSubtype((SOAPStructureType)subfault.getJavaException().getOwner());
                    continue;
                }
                if (!(fault.getJavaException().getOwner() instanceof LiteralStructuredType)) continue;
                ((LiteralStructuredType)fault.getJavaException().getOwner()).addSubtype((LiteralStructuredType)subfault.getJavaException().getOwner());
            }
        }
    }

    private List getMimeContents(Extensible ext, Message message, String name) {
        Iterator mimeParts = this.getMimeParts(ext);
        String mimeContentPartName = null;
        while (mimeParts.hasNext()) {
            MIMEContent mimeContent;
            MIMEPart mimePart = (MIMEPart)mimeParts.next();
            List mimeContents = this.getMimeContents(mimePart);
            Iterator mimeIter = mimeContents.iterator();
            if (!mimeIter.hasNext() || !(mimeContentPartName = (mimeContent = (MIMEContent)mimeIter.next()).getPart()).equals(name)) continue;
            return mimeContents;
        }
        return null;
    }

    private LiteralAttachmentType getAttachmentType(List mimeContents, MessagePart part) {
        JavaSimpleType type = null;
        MimeHelper mimeHelper = new MimeHelper();
        boolean useDataHandlerOnly = Boolean.valueOf(this._options.getProperty("useDataHandlerOnly"));
        List mimeTypes = this.getAlternateMimeTypes(mimeContents);
        if (mimeTypes.size() > 1) {
            type = MimeHelper.javaType.DATA_HANDLER_JAVATYPE;
        } else if (mimeTypes.size() == 1) {
            String mimeType = (String)mimeTypes.iterator().next();
            type = (JavaSimpleType)MimeHelper.mimeTypeToJavaType.get(mimeType);
            if (type == null && mimeType.startsWith("multipart/")) {
                type = (JavaSimpleType)MimeHelper.mimeTypeToJavaType.get("multipart/*");
            } else if (type == null || useDataHandlerOnly) {
                type = MimeHelper.javaType.DATA_HANDLER_JAVATYPE;
            }
        }
        LiteralType contentType = null;
        if (part.getDescriptorKind() == SchemaKinds.XSD_TYPE) {
            contentType = this.getSchemaAnalyzer().schemaTypeToLiteralType(part.getDescriptor());
        } else if (part.getDescriptorKind() == SchemaKinds.XSD_ELEMENT) {
            for (String mimeType : mimeTypes) {
                if (!mimeType.equals("text/xml") && !mimeType.equals("applicatioon/xml")) {
                    this.warn("mimemodeler.elementPart.invalidElementMimeType", new Object[]{part.getName(), mimeType});
                }
                contentType = this.getElementTypeToLiteralType(part.getDescriptor());
            }
        }
        if (contentType == null) {
            throw new ModelerException("mimemodeler.invalidMimeContent.unknownSchemaType", new Object[]{part.getName(), part.getDescriptor()});
        }
        LiteralAttachmentType mimeModelType = new LiteralAttachmentType(contentType.getName(), type);
        if (mimeModelType == null) {
            throw new ModelerException("mimemodeler.invalidMimeContent.invalidSchemaType", new Object[]{part.getName(), part.getDescriptor()});
        }
        if (mimeTypes.size() >= 1) {
            mimeModelType.setMIMEType((String)mimeTypes.iterator().next());
        }
        mimeModelType.setContentID(MimeHelper.getAttachmentUniqueID(part.getName()));
        mimeModelType.addAlternateMIMEType(this.getAlternateMimeTypes(mimeContents).iterator());
        return mimeModelType;
    }

    protected ProcessorEnvironment getEnvironment() {
        return this._env;
    }

    protected void warn(Localizable msg) {
        this.getEnvironment().warn(msg);
    }

    protected void warn(String key) {
        this.getEnvironment().warn(this._messageFactory.getMessage(key));
    }

    protected void warn(String key, String arg) {
        this.getEnvironment().warn(this._messageFactory.getMessage(key, arg));
    }

    protected void warn(String key, Object[] args) {
        this.getEnvironment().warn(this._messageFactory.getMessage(key, args));
    }

    protected void info(String key) {
        this.getEnvironment().info(this._messageFactory.getMessage(key));
    }

    protected void info(String key, String arg) {
        this.getEnvironment().info(this._messageFactory.getMessage(key, arg));
    }

    protected String makePackageQualified(String s2, QName name) {
        return this.makePackageQualified(s2, name, true);
    }

    protected String makePackageQualified(String s2, QName name, boolean useNamespaceMapping) {
        String javaPackageName = null;
        if (useNamespaceMapping) {
            javaPackageName = this.getJavaPackageName(name);
        }
        if (javaPackageName != null) {
            return javaPackageName + "." + s2;
        }
        if (this._modelInfo.getJavaPackageName() != null && !this._modelInfo.getJavaPackageName().equals("")) {
            return this._modelInfo.getJavaPackageName() + "." + s2;
        }
        return s2;
    }

    protected QName makePackageQualified(QName name) {
        return this.makePackageQualified(name, true);
    }

    protected QName makePackageQualified(QName name, boolean useNamespaceMapping) {
        return new QName(name.getNamespaceURI(), this.makePackageQualified(name.getLocalPart(), name));
    }

    protected String makeNameUniqueInSet(String candidateName, Set names) {
        String baseName;
        String name = baseName = candidateName;
        int i = 2;
        while (names.contains(name)) {
            name = baseName + Integer.toString(i);
            ++i;
        }
        return name;
    }

    protected String getUniqueName(com.sun.xml.rpc.wsdl.document.Operation operation, boolean hasOverloadedOperations) {
        if (hasOverloadedOperations) {
            return operation.getUniqueKey().replace(' ', '_');
        }
        return operation.getName();
    }

    protected String getUniqueParameterName(Operation operation, String baseName) {
        Parameter p;
        HashSet<String> names = new HashSet<String>();
        Iterator iter = operation.getRequest().getParameters();
        while (iter.hasNext()) {
            p = (Parameter)iter.next();
            names.add(p.getName());
        }
        iter = operation.getResponse().getParameters();
        while (iter.hasNext()) {
            p = (Parameter)iter.next();
            names.add(p.getName());
        }
        String candidateName = baseName;
        while (names.contains(candidateName)) {
            candidateName = candidateName + "_prime";
        }
        return candidateName;
    }

    protected String getNonQualifiedNameFor(QName name) {
        return this._env.getNames().validJavaClassName(name.getLocalPart());
    }

    protected static void setDocumentationIfPresent(ModelObject obj, Documentation documentation) {
        if (documentation != null && documentation.getContent() != null) {
            obj.setProperty(WSDL_DOCUMENTATION, documentation.getContent());
        }
    }

    protected static QName getQNameOf(GloballyKnown entity) {
        return new QName(entity.getDefining().getTargetNamespaceURI(), entity.getName());
    }

    protected static Extension getExtensionOfType(Extensible extensible, Class type) {
        Iterator iter = extensible.extensions();
        while (iter.hasNext()) {
            Extension extension = (Extension)iter.next();
            if (!extension.getClass().equals(type)) continue;
            return extension;
        }
        return null;
    }

    protected Extension getAnyExtensionOfType(Extensible extensible, Class type) {
        if (extensible == null) {
            return null;
        }
        Iterator iter = extensible.extensions();
        while (iter.hasNext()) {
            Extension extension = (Extension)iter.next();
            if (extension.getClass().equals(type)) {
                return extension;
            }
            if (!extension.getClass().equals(MIMEMultipartRelated.class) || !type.equals(SOAPBody.class) && !type.equals(MIMEContent.class) && !type.equals(MIMEPart.class)) continue;
            Iterator parts = ((MIMEMultipartRelated)extension).getParts();
            while (parts.hasNext()) {
                Extension part = (Extension)parts.next();
                if (!part.getClass().equals(MIMEPart.class)) continue;
                MIMEPart mPart = (MIMEPart)part;
                Extension extn = WSDLModelerBase.getExtensionOfType((Extensible)((Object)part), type);
                if (extn == null) continue;
                return extn;
            }
        }
        return null;
    }

    protected static Message findMessage(QName messageName, ProcessSOAPOperationInfo info) {
        Message message = null;
        try {
            message = (Message)info.document.find(Kinds.MESSAGE, messageName);
        }
        catch (NoSuchEntityException noSuchEntityException) {
            // empty catch block
        }
        return message;
    }

    protected static boolean tokenListContains(String tokenList, String target) {
        if (tokenList == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(tokenList, " ");
        while (tokenizer.hasMoreTokens()) {
            String s2 = tokenizer.nextToken();
            if (!target.equals(s2)) continue;
            return true;
        }
        return false;
    }

    private String getUniqueClassName(String className) {
        int cnt = 2;
        String uniqueName = className;
        while (this.reqResNames.contains(uniqueName.toLowerCase())) {
            uniqueName = className + cnt;
            ++cnt;
        }
        this.reqResNames.add(uniqueName.toLowerCase());
        return uniqueName;
    }

    private String getJavaPackageName(QName name) {
        NamespaceMappingInfo i;
        String packageName = null;
        if (this._modelInfo.getNamespaceMappingRegistry() != null && (i = this._modelInfo.getNamespaceMappingRegistry().getNamespaceMappingInfo(name)) != null) {
            return i.getJavaPackageName();
        }
        return packageName;
    }

    protected boolean isConflictingClassName(String name) {
        if (this._conflictingClassNames == null) {
            return false;
        }
        return this._conflictingClassNames.contains(name);
    }

    protected boolean isConflictingServiceClassName(String name) {
        return this.isConflictingClassName(name);
    }

    protected boolean isConflictingStubClassName(String name) {
        return this.isConflictingClassName(name);
    }

    protected boolean isConflictingTieClassName(String name) {
        return this.isConflictingClassName(name);
    }

    protected boolean isConflictingPortClassName(String name) {
        return this.isConflictingClassName(name);
    }

    protected boolean isConflictingExceptionClassName(String name) {
        return this.isConflictingClassName(name);
    }

    protected LiteralType getElementTypeToLiteralType(QName elementType) {
        return this._analyzer.schemaElementTypeToLiteralType(elementType);
    }

    private SOAPType getSchemaTypeToSOAPType(QName elementType) {
        return this._analyzer.schemaTypeToSOAPType(elementType);
    }

    public static class WSDLExceptionInfo {
        public String exceptionType;
        public QName wsdlMessage;
        public String wsdlMessagePartName;
        public HashMap constructorOrder;
    }

    public class ProcessSOAPOperationInfo {
        public Port modelPort;
        public com.sun.xml.rpc.wsdl.document.Port port;
        public com.sun.xml.rpc.wsdl.document.Operation portTypeOperation;
        public BindingOperation bindingOperation;
        public SOAPBinding soapBinding;
        public WSDLDocument document;
        public boolean hasOverloadedOperations;
        public Map headers;
        public Operation operation;
        public String uniqueOperationName;

        public ProcessSOAPOperationInfo(Port modelPort, com.sun.xml.rpc.wsdl.document.Port port, com.sun.xml.rpc.wsdl.document.Operation portTypeOperation, BindingOperation bindingOperation, SOAPBinding soapBinding, WSDLDocument document, boolean hasOverloadedOperations, Map headers) {
            this.modelPort = modelPort;
            this.port = port;
            this.portTypeOperation = portTypeOperation;
            this.bindingOperation = bindingOperation;
            this.soapBinding = soapBinding;
            this.document = document;
            this.hasOverloadedOperations = hasOverloadedOperations;
            this.headers = headers;
        }
    }
}

