/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.wsdeploy;

import com.sun.xml.rpc.processor.Processor;
import com.sun.xml.rpc.processor.ProcessorNotificationListener;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.ModelFileModelInfo;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.XMLModelWriter;
import com.sun.xml.rpc.tools.wscompile.CompileTool;
import com.sun.xml.rpc.tools.wsdeploy.EndpointClientInfo;
import com.sun.xml.rpc.tools.wsdeploy.WebServicesInfo;
import com.sun.xml.rpc.util.localization.Localizable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class EndpointClientCompileTool
extends CompileTool {
    protected WebServicesInfo webServicesInfo;
    protected File targetDirectory;
    protected boolean useModel;
    protected String additionalClasspath;
    protected Hashtable hashtable;
    protected ArrayList vector;
    protected EndpointClientInfo endpointClient;
    protected ArrayList clientList;
    protected boolean localUseWSIBasicProfile = false;
    private static final String PS = System.getProperty("path.separator");
    private static final char PSCHAR = System.getProperty("path.separator").charAt(0);
    private static final String FS = System.getProperty("file.separator");
    private static final char FSCHAR = System.getProperty("file.separator").charAt(0);

    public EndpointClientCompileTool(OutputStream out, String program, WebServicesInfo wsi, ArrayList list, File dir, String target, String classpath, ProcessorNotificationListener l) {
        super(out, program);
        this.webServicesInfo = wsi;
        this.targetDirectory = dir;
        this.additionalClasspath = classpath;
        this.listener = l;
        this.clientList = list;
        this.endpointClient = (EndpointClientInfo)this.clientList.get(0);
        this.useModel = this.endpointClient.getModel() != null;
        this.targetVersion = target;
    }

    protected void beforeHook() {
        String targetPath = this.targetDirectory.getAbsolutePath();
        this.nonclassDestDir = new File(targetPath + FS + "WEB-INF");
        this.userClasspath = targetPath + FS + "WEB-INF" + FS + "lib";
        this.destDir = new File(this.userClasspath);
        this.userClasspath = targetPath + FS + "WEB-INF" + FS + "lib" + PS + targetPath + FS + "WEB-INF" + FS + "classes";
        if (new File(targetPath + FS + "WEB-INF" + FS + "lib").exists()) {
            File[] fs = new File(targetPath + FS + "WEB-INF" + FS + "lib").listFiles();
            for (int counter = 0; counter < fs.length; ++counter) {
                this.userClasspath = this.userClasspath + PS + fs[counter];
            }
        }
        if (this.additionalClasspath != null && this.additionalClasspath.length() > 0) {
            this.userClasspath = this.userClasspath + PS + this.additionalClasspath;
        }
        if (!this.useModel) {
            this.modelFile = new File(this.makeModelFileName());
        } else if (this.targetVersion != null) {
            this.onWarning(this.getMessage("wscompile.warning.ignoringTargetVersionForModel", this.endpointClient.getModel(), this.targetVersion));
            this.targetVersion = null;
        }
        this.serializerInfix = "_" + this.endpointClient.getName() + "_";
        this.keepGenerated = true;
        this.compilerDebug = false;
        this.compilerOptimize = true;
        super.beforeHook();
    }

    protected void withModelHook() {
    }

    public com.sun.xml.rpc.spi.tools.Configuration createConfiguration() throws Exception {
        Configuration config = new Configuration(this.environment);
        if (this.useModel) {
            ModelFileModelInfo modelInfo = new ModelFileModelInfo();
            modelInfo.setLocation(this.makeAbsolute(this.endpointClient.getModel()));
            config.setModelInfo(modelInfo);
        }
        return config;
    }

    protected String makeTargetNamespaceURI() {
        String base = this.webServicesInfo.getTargetNamespaceBase();
        if (base.endsWith("/") || base.startsWith("urn:")) {
            return base + this.endpointClient.getName();
        }
        return base + "/" + this.endpointClient.getName();
    }

    protected String makeTypeNamespaceURI() {
        String base = this.webServicesInfo.getTypeNamespaceBase();
        if (base.endsWith("/") || base.startsWith("urn:")) {
            return base + this.endpointClient.getName();
        }
        return base + "/" + this.endpointClient.getName();
    }

    protected String makeModelFileName() {
        return this.targetDirectory.getAbsolutePath() + FS + "WEB-INF" + FS + this.endpointClient.getName() + "_model.xml.gz";
    }

    protected String makeJavaPackageName() {
        return "jaxrpc.generated." + this.environment.getNames().validJavaPackageName(this.endpointClient.getName());
    }

    protected String makeAbsolute(String s2) {
        if (s2 == null) {
            return null;
        }
        return new File(this.targetDirectory.getAbsolutePath() + s2).getAbsolutePath();
    }

    protected String makeAppRelative(File f) {
        String target;
        if (f == null) {
            return null;
        }
        String s2 = f.getAbsolutePath();
        if (s2.startsWith(target = this.targetDirectory.getAbsolutePath())) {
            return s2.substring(target.length()).replace(FSCHAR, '/');
        }
        return null;
    }

    protected File findGeneratedFileEndingWith(String s2) {
        Iterator iter = this.environment.getGeneratedFiles();
        while (iter.hasNext()) {
            GeneratedFileInfo fileInfo = (GeneratedFileInfo)iter.next();
            File file = fileInfo.getFile();
            if (!file.getAbsolutePath().endsWith(s2)) continue;
            return file;
        }
        return null;
    }

    protected void registerProcessorActions(Processor processor) {
        if (!this.useModel) {
            try {
                processor.add(new XMLModelWriter(this.modelFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        processor.add(this.getAction("service.interface.generator"));
        processor.add(this.getAction("service.generator"));
        processor.add(this.getAction("custom.class.generator"));
        processor.add(this.getAction("enumeration.encoder.generator"));
        processor.add(this.getAction("literal.object.serializer.generator"));
        processor.add(this.getAction("soap.fault.serializer.generator"));
        processor.add(this.getAction("fault.exception.builder.generator"));
        if (this.delegate != null) {
            this.delegate.postRegisterProcessorActions();
        }
    }

    public void onError(Localizable msg) {
        if (this.delegate != null) {
            this.delegate.preOnError();
        }
        this.report(this.getMessage("wscompile.error", this.localizer.localize(msg)));
    }

    public void onWarning(Localizable msg) {
        this.report(this.getMessage("wscompile.warning", this.localizer.localize(msg)));
    }

    public void onInfo(Localizable msg) {
        this.report(this.getMessage("wscompile.info", this.localizer.localize(msg)));
    }
}

