/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.document.schema;

import com.sun.xml.rpc.util.NullIterator;
import com.sun.xml.rpc.util.xml.XmlUtil;
import com.sun.xml.rpc.wsdl.document.schema.Schema;
import com.sun.xml.rpc.wsdl.document.schema.SchemaAttribute;
import com.sun.xml.rpc.wsdl.framework.ValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class SchemaElement {
    private String _nsURI;
    private String _localName;
    private List _children;
    private List _attributes;
    private Map _nsPrefixes;
    private SchemaElement _parent;
    private QName _qname;
    private Schema _schema;
    private static final String NEW_NS_PREFIX_BASE = "ns";

    public SchemaElement() {
    }

    public SchemaElement(String localName) {
        this._localName = localName;
    }

    public SchemaElement(QName name) {
        this._qname = name;
        this._localName = name.getLocalPart();
        this._nsURI = name.getNamespaceURI();
    }

    public String getNamespaceURI() {
        return this._nsURI;
    }

    public void setNamespaceURI(String s2) {
        this._nsURI = s2;
    }

    public String getLocalName() {
        return this._localName;
    }

    public void setLocalName(String s2) {
        this._localName = s2;
    }

    public QName getQName() {
        if (this._qname == null) {
            this._qname = new QName(this._nsURI, this._localName);
        }
        return this._qname;
    }

    public SchemaElement getParent() {
        return this._parent;
    }

    public void setParent(SchemaElement e) {
        this._parent = e;
    }

    public SchemaElement getRoot() {
        return this._parent == null ? this : this._parent.getRoot();
    }

    public Schema getSchema() {
        return this._parent == null ? this._schema : this._parent.getSchema();
    }

    public void setSchema(Schema s2) {
        this._schema = s2;
    }

    public void addChild(SchemaElement e) {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        this._children.add(e);
        e.setParent(this);
    }

    public void insertChildAtTop(SchemaElement e) {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        this._children.add(0, e);
        e.setParent(this);
    }

    public Iterator children() {
        if (this._children == null) {
            return NullIterator.getInstance();
        }
        return this._children.iterator();
    }

    public void addAttribute(SchemaAttribute a) {
        if (this._attributes == null) {
            this._attributes = new ArrayList();
        }
        this._attributes.add(a);
        a.setParent(this);
        a.getValue();
    }

    public void addAttribute(String name, String value) {
        SchemaAttribute attr = new SchemaAttribute();
        attr.setLocalName(name);
        attr.setValue(value);
        this.addAttribute(attr);
    }

    public void addAttribute(String name, QName value) {
        SchemaAttribute attr = new SchemaAttribute();
        attr.setLocalName(name);
        attr.setValue(value);
        this.addAttribute(attr);
    }

    public Iterator attributes() {
        if (this._attributes == null) {
            return NullIterator.getInstance();
        }
        return this._attributes.iterator();
    }

    public SchemaAttribute getAttribute(String localName) {
        if (this._attributes != null) {
            for (SchemaAttribute attr : this._attributes) {
                if (!localName.equals(attr.getLocalName())) continue;
                return attr;
            }
        }
        return null;
    }

    public String getValueOfMandatoryAttribute(String localName) {
        SchemaAttribute attr = this.getAttribute(localName);
        if (attr == null) {
            throw new ValidationException("validation.missingRequiredAttribute", new Object[]{localName, this._localName});
        }
        return attr.getValue();
    }

    public String getValueOfAttributeOrNull(String localName) {
        SchemaAttribute attr = this.getAttribute(localName);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public boolean getValueOfBooleanAttributeOrDefault(String localName, boolean defaultValue) {
        String stringValue = this.getValueOfAttributeOrNull(localName);
        if (stringValue == null) {
            return defaultValue;
        }
        if (stringValue.equals("true") || stringValue.equals("1")) {
            return true;
        }
        if (stringValue.equals("false") || stringValue.equals("0")) {
            return false;
        }
        throw new ValidationException("validation.invalidAttributeValue", new Object[]{localName, stringValue});
    }

    public int getValueOfIntegerAttributeOrDefault(String localName, int defaultValue) {
        String stringValue = this.getValueOfAttributeOrNull(localName);
        if (stringValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            throw new ValidationException("validation.invalidAttributeValue", new Object[]{localName, stringValue});
        }
    }

    public QName getValueOfQNameAttributeOrNull(String localName) {
        String uri;
        String stringValue = this.getValueOfAttributeOrNull(localName);
        if (stringValue == null) {
            return null;
        }
        String prefix = XmlUtil.getPrefix(stringValue);
        String string2 = uri = prefix == null ? this.getURIForPrefix("") : this.getURIForPrefix(prefix);
        if (uri == null) {
            throw new ValidationException("validation.invalidAttributeValue", new Object[]{localName, stringValue});
        }
        return new QName(uri, XmlUtil.getLocalPart(stringValue));
    }

    public void addPrefix(String prefix, String uri) {
        if (this._nsPrefixes == null) {
            this._nsPrefixes = new HashMap();
        }
        this._nsPrefixes.put(prefix, uri);
    }

    public String getURIForPrefix(String prefix) {
        String result;
        if (this._nsPrefixes != null && (result = (String)this._nsPrefixes.get(prefix)) != null) {
            return result;
        }
        if (this._parent != null) {
            return this._parent.getURIForPrefix(prefix);
        }
        if (this._schema != null) {
            return this._schema.getURIForPrefix(prefix);
        }
        return null;
    }

    public boolean declaresPrefixes() {
        return this._nsPrefixes != null;
    }

    public Iterator prefixes() {
        if (this._nsPrefixes == null) {
            return NullIterator.getInstance();
        }
        return this._nsPrefixes.keySet().iterator();
    }

    public QName asQName(String s2) {
        String uri;
        String prefix = XmlUtil.getPrefix(s2);
        if (prefix == null) {
            prefix = "";
        }
        if ((uri = this.getURIForPrefix(prefix)) == null) {
            throw new ValidationException("validation.invalidPrefix", prefix);
        }
        String localPart = XmlUtil.getLocalPart(s2);
        return new QName(uri, localPart);
    }

    public String asString(QName name) {
        String result;
        if (name.getNamespaceURI().equals("")) {
            return name.getLocalPart();
        }
        Iterator iter = this.prefixes();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            String uri = this.getURIForPrefix(prefix);
            if (!uri.equals(name.getNamespaceURI())) continue;
            if (prefix.equals("")) {
                return name.getLocalPart();
            }
            return prefix + ":" + name.getLocalPart();
        }
        if (this._parent != null) {
            return this._parent.asString(name);
        }
        if (this._schema != null && (result = this._schema.asString(name)) != null) {
            return result;
        }
        String prefix = this.getNewPrefix();
        this.addPrefix(prefix, name.getNamespaceURI());
        return this.asString(name);
    }

    protected String getNewPrefix() {
        String base = NEW_NS_PREFIX_BASE;
        int count = 2;
        String prefix = null;
        boolean needNewOne = true;
        while (needNewOne) {
            prefix = base + Integer.toString(count);
            needNewOne = this.getURIForPrefix(prefix) != null;
            ++count;
        }
        return prefix;
    }
}

