/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.DataDerivFailure;
import com.thaiopensource.relaxng.pattern.DataDerivType;
import com.thaiopensource.relaxng.pattern.DataPattern;
import com.thaiopensource.relaxng.pattern.InconsistentDataDerivType;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternMemo;
import com.thaiopensource.relaxng.pattern.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.pattern.ValueDataDerivType;
import java.util.List;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataDataDerivType
extends DataDerivType {
    private final DataPattern dp;
    private PatternMemo validMemo;
    private PatternMemo invalidMemo;

    DataDataDerivType(DataPattern dataPattern) {
        this.dp = dataPattern;
    }

    @Override
    PatternMemo dataDeriv(ValidatorPatternBuilder validatorPatternBuilder, Pattern pattern, String string2, ValidationContext validationContext, List<DataDerivFailure> list) {
        boolean bl;
        Datatype datatype = this.dp.getDatatype();
        DataDerivFailure dataDerivFailure = null;
        if (list != null) {
            try {
                datatype.checkValid(string2, validationContext);
                bl = true;
            }
            catch (DatatypeException datatypeException) {
                bl = false;
                dataDerivFailure = new DataDerivFailure(this.dp, datatypeException);
            }
        } else {
            bl = datatype.isValid(string2, validationContext);
        }
        if (bl) {
            if (this.validMemo == null || list != null && this.validMemo.isNotAllowed()) {
                this.validMemo = super.dataDeriv(validatorPatternBuilder, pattern, string2, validationContext, list);
            }
            return this.validMemo;
        }
        if (this.invalidMemo == null) {
            this.invalidMemo = super.dataDeriv(validatorPatternBuilder, pattern, string2, validationContext, list);
        } else if (this.invalidMemo.isNotAllowed() && dataDerivFailure != null) {
            list.add(dataDerivFailure);
        }
        return this.invalidMemo;
    }

    @Override
    DataDerivType copy() {
        return new DataDataDerivType(this.dp);
    }

    @Override
    DataDerivType combine(DataDerivType dataDerivType) {
        if (dataDerivType instanceof DataDataDerivType) {
            if (((DataDataDerivType)dataDerivType).dp.getDatatype() == this.dp.getDatatype()) {
                return this;
            }
            return InconsistentDataDerivType.getInstance();
        }
        if (dataDerivType instanceof ValueDataDerivType) {
            if (((ValueDataDerivType)dataDerivType).getDatatype() == this.dp.getDatatype()) {
                return dataDerivType;
            }
            return InconsistentDataDerivType.getInstance();
        }
        return dataDerivType.combine(this);
    }
}

