/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.resolver.xml.ls;

import com.thaiopensource.resolver.AbstractResolver;
import com.thaiopensource.resolver.Identifier;
import com.thaiopensource.resolver.Input;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.ResolverException;
import com.thaiopensource.resolver.xml.ExternalIdentifier;
import com.thaiopensource.resolver.xml.TargetNamespaceIdentifier;
import com.thaiopensource.resolver.xml.XMLDocumentIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class LS {
    private static final String XML_TYPE = "http://www.w3.org/TR/REC-xml";
    private static final String IANA_MEDIA_TYPE_URI = "http://www.iana.org/assignments/media-types/";

    private LS() {
    }

    public static Resolver createResolver(final LSResourceResolver lSResourceResolver) {
        return new AbstractResolver(){

            public void resolve(Identifier identifier, Input input) throws IOException, ResolverException {
                LSInput lSInput;
                String string2;
                if (input.isResolved()) {
                    return;
                }
                String string3 = identifier.getBase();
                String string4 = null;
                String string5 = null;
                if (identifier instanceof ExternalIdentifier) {
                    string4 = ((ExternalIdentifier)identifier).getPublicId();
                    string5 = LS.XML_TYPE;
                } else if (identifier instanceof XMLDocumentIdentifier) {
                    string5 = ((XMLDocumentIdentifier)identifier).getNamespaceUri();
                }
                if (string5 == null && (string2 = identifier.getMediaType()).indexOf(42) < 0) {
                    string5 = LS.IANA_MEDIA_TYPE_URI + string2;
                }
                string2 = null;
                if (identifier instanceof TargetNamespaceIdentifier) {
                    string2 = ((TargetNamespaceIdentifier)((Object)identifier)).getTargetNamespace();
                }
                if ((lSInput = lSResourceResolver.resolveResource(string5, string2, string4, identifier.getUriReference(), string3)) == null) {
                    return;
                }
                input.setEncoding(lSInput.getEncoding());
                input.setUri(lSInput.getSystemId());
                Reader reader = lSInput.getCharacterStream();
                if (reader != null) {
                    input.setCharacterStream(reader);
                    return;
                }
                InputStream inputStream = lSInput.getByteStream();
                if (inputStream != null) {
                    input.setByteStream(inputStream);
                    return;
                }
                String string6 = lSInput.getStringData();
                if (string6 != null) {
                    input.setCharacterStream(new StringReader(string6));
                    return;
                }
            }
        };
    }
}

