/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.resolver.xml.sax;

import com.thaiopensource.resolver.BasicResolver;
import com.thaiopensource.resolver.Identifier;
import com.thaiopensource.resolver.Input;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.ResolverException;
import com.thaiopensource.resolver.SequenceResolver;
import com.thaiopensource.resolver.xml.XMLDocumentIdentifier;
import com.thaiopensource.resolver.xml.sax.SAX;
import com.thaiopensource.resolver.xml.sax.SAXInput;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXResolver {
    private final Resolver resolver;
    private final SAXParserFactory parserFactory;

    public SAXResolver(Resolver resolver2) {
        Resolver resolver3 = BasicResolver.getInstance();
        if (resolver2 != null) {
            resolver3 = new SequenceResolver(resolver2, resolver3);
        }
        this.resolver = resolver3;
        this.parserFactory = SAXParserFactory.newInstance();
        this.parserFactory.setNamespaceAware(true);
        this.parserFactory.setValidating(false);
    }

    public SAXResolver() {
        this(null);
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public SAXSource resolve(String string2, String string3) throws SAXException, IOException {
        return this.resolve(new Identifier(string2, string3));
    }

    public SAXSource resolve(String string2, String string3, String string4) throws SAXException, IOException {
        return this.resolve(new XMLDocumentIdentifier(string2, string3, string4));
    }

    public SAXSource resolve(Identifier identifier) throws SAXException, IOException {
        SAXInput sAXInput = new SAXInput();
        try {
            this.resolver.resolve(identifier, sAXInput);
            if (!sAXInput.isResolved()) {
                sAXInput.setUri(BasicResolver.resolveUri(identifier));
            }
            InputSource inputSource = SAX.createInputSource(identifier, sAXInput);
            XMLReader xMLReader = sAXInput.getXMLReader();
            if (xMLReader == null) {
                xMLReader = this.createXMLReader();
            }
            return new SAXSource(xMLReader, inputSource);
        }
        catch (ResolverException resolverException) {
            throw SAX.toSAXException(resolverException);
        }
    }

    public SAXSource createSAXSource(Input input) throws SAXException {
        InputSource inputSource = SAX.createInputSource(input);
        XMLReader xMLReader = null;
        if (input instanceof SAXInput) {
            xMLReader = ((SAXInput)input).getXMLReader();
        }
        if (xMLReader == null) {
            xMLReader = this.createXMLReader();
        }
        return new SAXSource(xMLReader, inputSource);
    }

    public XMLReader createXMLReader() throws SAXException {
        XMLReader xMLReader = this.createXMLReaderWithoutResolver();
        xMLReader.setEntityResolver(SAX.createEntityResolver(this.resolver));
        return xMLReader;
    }

    protected XMLReader createXMLReaderWithoutResolver() throws SAXException {
        try {
            return this.parserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
    }

    public InputSource open(InputSource inputSource) throws SAXException, IOException {
        if (inputSource.getByteStream() != null || inputSource.getCharacterStream() != null) {
            return inputSource;
        }
        Input input = SAX.createInput(inputSource);
        try {
            this.resolver.open(input);
        }
        catch (ResolverException resolverException) {
            throw SAX.toSAXException(resolverException);
        }
        String string2 = inputSource.getPublicId();
        inputSource = SAX.createInputSource(input);
        inputSource.setPublicId(string2);
        return inputSource;
    }
}

