/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.resolver.xml.transform;

import com.thaiopensource.resolver.AbstractResolver;
import com.thaiopensource.resolver.Identifier;
import com.thaiopensource.resolver.Input;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.ResolverException;
import com.thaiopensource.resolver.xml.sax.SAX;
import com.thaiopensource.resolver.xml.sax.SAXInput;
import com.thaiopensource.resolver.xml.sax.SAXResolver;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Transform {
    private Transform() {
    }

    public static URIResolver createSAXURIResolver(Resolver resolver2) {
        final SAXResolver sAXResolver = new SAXResolver(resolver2);
        return new URIResolver(){

            public Source resolve(String string2, String string3) throws TransformerException {
                try {
                    return sAXResolver.resolve(string2, string3);
                }
                catch (SAXException sAXException) {
                    throw Transform.toTransformerException(sAXException);
                }
                catch (IOException iOException) {
                    throw new TransformerException(iOException);
                }
            }
        };
    }

    public static Resolver createResolver(final URIResolver uRIResolver) {
        return new AbstractResolver(){

            public void resolve(Identifier identifier, Input input) throws IOException, ResolverException {
                Source source;
                if (input.isResolved()) {
                    return;
                }
                try {
                    source = uRIResolver.resolve(identifier.getUriReference(), identifier.getBase());
                }
                catch (TransformerException transformerException) {
                    throw Transform.toResolverException(transformerException);
                }
                if (source == null) {
                    return;
                }
                if (source instanceof SAXSource) {
                    Transform.setInput(input, (SAXSource)source);
                    return;
                }
                InputSource inputSource = SAXSource.sourceToInputSource(source);
                if (inputSource != null) {
                    SAX.setInput(input, inputSource);
                    return;
                }
                throw new ResolverException("URIResolver returned unsupported subclass of Source");
            }
        };
    }

    private static void setInput(Input input, SAXSource sAXSource) {
        InputSource inputSource;
        XMLReader xMLReader = sAXSource.getXMLReader();
        if (xMLReader != null && input instanceof SAXInput) {
            ((SAXInput)input).setXMLReader(xMLReader);
        }
        if ((inputSource = sAXSource.getInputSource()) != null) {
            SAX.setInput(input, inputSource);
        }
    }

    private static TransformerException toTransformerException(SAXException sAXException) {
        Exception exception = SAX.getWrappedException(sAXException);
        if (exception != null) {
            if (exception instanceof TransformerException) {
                return (TransformerException)exception;
            }
            return new TransformerException(exception);
        }
        return new TransformerException(sAXException);
    }

    private static ResolverException toResolverException(TransformerException transformerException) {
        Throwable throwable = Transform.getWrappedException(transformerException);
        if (throwable != null) {
            if (throwable instanceof ResolverException) {
                return (ResolverException)throwable;
            }
            return new ResolverException(throwable);
        }
        return new ResolverException(transformerException);
    }

    private static Throwable getWrappedException(TransformerException transformerException) {
        Throwable throwable = transformerException.getException();
        if (throwable == null) {
            return null;
        }
        String string2 = transformerException.getMessage();
        if (string2 != null && !string2.equals(throwable.getMessage())) {
            return null;
        }
        return throwable;
    }
}

