/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nrl;

import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.auto.SchemaReceiver;
import com.thaiopensource.validate.auto.SchemaReceiverFactory;
import com.thaiopensource.validate.nrl.SchemaImpl;
import com.thaiopensource.validate.nrl.ValidatorImpl;
import com.thaiopensource.validate.prop.wrap.WrapProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.validate.rng.SAXSchemaReader;
import com.thaiopensource.xml.util.Name;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class SchemaReceiverImpl
implements SchemaReceiver {
    private static final String NRL_SCHEMA = "nrl.rng";
    private static final String RNC_MEDIA_TYPE = "application/x-rnc";
    private final PropertyMap properties;
    private final Name attributeOwner;
    private final SchemaReader autoSchemaReader;
    private Schema nrlSchema = null;
    private static final PropertyId[] subSchemaProperties = new PropertyId[]{ValidateProperty.ERROR_HANDLER, ValidateProperty.XML_READER_CREATOR, ValidateProperty.ENTITY_RESOLVER, SchemaReceiverFactory.PROPERTY};

    public SchemaReceiverImpl(PropertyMap propertyMap) {
        this.attributeOwner = propertyMap.get(WrapProperty.ATTRIBUTE_OWNER);
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        for (int i = 0; i < subSchemaProperties.length; ++i) {
            Object t = propertyMap.get(subSchemaProperties[i]);
            if (t == null) continue;
            propertyMapBuilder.put(subSchemaProperties[i], t);
        }
        this.properties = propertyMapBuilder.toPropertyMap();
        this.autoSchemaReader = new AutoSchemaReader(propertyMap.get(SchemaReceiverFactory.PROPERTY));
    }

    public SchemaFuture installHandlers(XMLReader xMLReader) {
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(this.properties);
        if (this.attributeOwner != null) {
            propertyMapBuilder.put(WrapProperty.ATTRIBUTE_OWNER, this.attributeOwner);
        }
        return new SchemaImpl(propertyMapBuilder.toPropertyMap()).installHandlers(xMLReader, this);
    }

    Schema getNrlSchema() throws IOException, IncorrectSchemaException, SAXException {
        if (this.nrlSchema == null) {
            String string2 = SchemaReceiverImpl.class.getName();
            String string3 = string2.substring(0, string2.lastIndexOf(46)).replace('.', '/') + "/resources/" + NRL_SCHEMA;
            URL uRL = SchemaReceiverImpl.getResource(string3);
            this.nrlSchema = SAXSchemaReader.getInstance().createSchema(new InputSource(uRL.openStream()), this.properties);
        }
        return this.nrlSchema;
    }

    private static URL getResource(String string2) {
        ClassLoader classLoader = SchemaReceiverImpl.class.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string2);
        }
        return classLoader.getResource(string2);
    }

    PropertyMap getProperties() {
        return this.properties;
    }

    Schema createChildSchema(SAXSource sAXSource, String string2, PropertyMap propertyMap, boolean bl) throws IOException, IncorrectSchemaException, SAXException {
        SchemaReader schemaReader = SchemaReceiverImpl.isRnc(string2) ? CompactSchemaReader.getInstance() : this.autoSchemaReader;
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(this.properties);
        if (bl) {
            propertyMapBuilder.put(WrapProperty.ATTRIBUTE_OWNER, ValidatorImpl.OWNER_NAME);
        }
        propertyMapBuilder.add(propertyMap);
        return schemaReader.createSchema(sAXSource, propertyMapBuilder.toPropertyMap());
    }

    Option getOption(String string2) {
        Option option = this.autoSchemaReader.getOption(string2);
        if (option != null) {
            return option;
        }
        return CompactSchemaReader.getInstance().getOption(string2);
    }

    private static boolean isRnc(String string2) {
        if (string2 == null) {
            return false;
        }
        string2 = string2.trim();
        return string2.equals(RNC_MEDIA_TYPE);
    }
}

