/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.picl;

import com.thaiopensource.validate.picl.ErrorContext;
import com.thaiopensource.validate.picl.KeyConstraint;
import com.thaiopensource.validate.picl.Pattern;
import com.thaiopensource.validate.picl.PatternManager;
import com.thaiopensource.validate.picl.SelectedValueHandler;
import com.thaiopensource.validate.picl.ValueSelectionHandler;
import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.Locator;

class KeyRefConstraint
extends KeyConstraint {
    private final Pattern ref;

    KeyRefConstraint(Pattern pattern, Pattern pattern2) {
        super(pattern);
        this.ref = pattern2;
    }

    void activate(PatternManager patternManager, KeyConstraint.KeyIndex keyIndex) {
        super.activate(patternManager, keyIndex);
        patternManager.registerPattern(this.ref, new ValueSelectionHandler(new RefSelectionHandler(keyIndex)));
    }

    static class RefSelectionHandler
    extends SelectedValueHandler {
        private final KeyConstraint.KeyIndex index;

        RefSelectionHandler(KeyConstraint.KeyIndex keyIndex) {
            this.index = keyIndex;
        }

        void select(ErrorContext errorContext, Locator locator, Object object, String string2) {
            KeyConstraint.KeyInfo keyInfo = this.index.lookupCreate(object);
            if (keyInfo.firstKeyLocator == null) {
                if (keyInfo.pendingRefLocators == null) {
                    keyInfo.pendingRefLocators = new Vector();
                }
                if (locator == null) {
                    locator = errorContext.saveLocator();
                }
                keyInfo.pendingRefLocators.addElement(locator);
            }
            if (keyInfo.representation == null) {
                keyInfo.representation = string2;
            }
        }

        public void selectComplete(ErrorContext errorContext) {
            Enumeration enumeration = this.index.keys();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                KeyConstraint.KeyInfo keyInfo = this.index.lookupCreate(e);
                if (keyInfo.pendingRefLocators == null) continue;
                int n = keyInfo.pendingRefLocators.size();
                for (int i = 0; i < n; ++i) {
                    Locator locator = (Locator)keyInfo.pendingRefLocators.elementAt(i);
                    errorContext.error(locator, "undefined_key", keyInfo.representation);
                }
            }
        }
    }
}

