/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.ws.spi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.ws.WebServiceException;

class FactoryFinder {
    private static final String OSGI_SERVICE_LOADER_CLASS_NAME = "org.glassfish.hk2.osgiresourcelocator.ServiceLoader";

    FactoryFinder() {
    }

    private static Object newInstance(String className, ClassLoader classLoader) {
        try {
            Class spiClass = FactoryFinder.safeLoadClass(className, classLoader);
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new WebServiceException("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new WebServiceException("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    static Object find(String factoryId, String fallbackClassName) {
        ClassLoader classLoader;
        if (FactoryFinder.isOsgi()) {
            return FactoryFinder.lookupUsingOSGiServiceLoader(factoryId);
        }
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception x) {
            throw new WebServiceException(x.toString(), x);
        }
        String serviceId = "META-INF/services/" + factoryId;
        try {
            InputStream is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId);
            if (is != null) {
                BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String factoryClassName = rd.readLine();
                rd.close();
                if (factoryClassName != null && !"".equals(factoryClassName)) {
                    return FactoryFinder.newInstance(factoryClassName, classLoader);
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            String javah = System.getProperty("java.home");
            String configFile = javah + File.separator + "lib" + File.separator + "jaxws.properties";
            File f = new File(configFile);
            if (f.exists()) {
                Properties props = new Properties();
                props.load(new FileInputStream(f));
                String factoryClassName = props.getProperty(factoryId);
                return FactoryFinder.newInstance(factoryClassName, classLoader);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            String systemProp = System.getProperty(factoryId);
            if (systemProp != null) {
                return FactoryFinder.newInstance(systemProp, classLoader);
            }
        }
        catch (SecurityException se) {
            // empty catch block
        }
        if (fallbackClassName == null) {
            throw new WebServiceException("Provider for " + factoryId + " cannot be found", null);
        }
        return FactoryFinder.newInstance(fallbackClassName, classLoader);
    }

    private static Class safeLoadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            int i;
            SecurityManager s2 = System.getSecurityManager();
            if (s2 != null && (i = className.lastIndexOf(46)) != -1) {
                s2.checkPackageAccess(className.substring(0, i));
            }
            if (classLoader == null) {
                return Class.forName(className);
            }
            return classLoader.loadClass(className);
        }
        catch (SecurityException se) {
            if ("com.sun.xml.internal.ws.spi.ProviderImpl".equals(className)) {
                return Class.forName(className);
            }
            throw se;
        }
    }

    private static boolean isOsgi() {
        try {
            Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static Object lookupUsingOSGiServiceLoader(String factoryId) {
        try {
            Class<?> serviceClass = Class.forName(factoryId);
            Class[] args = new Class[]{serviceClass};
            Class<?> target = Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
            Method m3 = target.getMethod("lookupProviderInstances", Class.class);
            Iterator iter = ((Iterable)m3.invoke(null, (Object[])args)).iterator();
            return iter.hasNext() ? iter.next() : null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

